<?php

namespace AureroIpom\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Wyszukanie ServiceType
 * @subpackage Services
 */
class Wyszukanie extends AbstractSoapClientBase
{
    /**
     * Sets the KontekstWywolania SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AureroIpom\StructType\KontekstMT $kontekstWywolania
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderKontekstWywolania(\AureroIpom\StructType\KontekstMT $kontekstWywolania, $nameSpace = 'http://csioz.gov.pl/p1/kontekst/mt/v20180509', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'kontekstWywolania', $kontekstWywolania, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named
     * wyszukaniePlanowOpiekiMedycznejWystawcy
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20180509
     * - SOAPHeaderTypes: \AureroIpom\StructType\KontekstMT
     * - SOAPHeaders: required
     * - documentation: Operacja wyszukania dokumentów indywidualnych planów opieki medycznej wystawionych przez użytkownika w ramach podmiotu z kontekstu.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AureroIpom\StructType\WyszukaniePlanowOpiekiMedycznejWystawcyRequest $wyszukaniePlanowOpiekiMedycznejWystawcyRequest
     * @return \AureroIpom\StructType\WyszukaniePlanowOpiekiMedycznejResponse|bool
     */
    public function wyszukaniePlanowOpiekiMedycznejWystawcy(\AureroIpom\StructType\WyszukaniePlanowOpiekiMedycznejWystawcyRequest $wyszukaniePlanowOpiekiMedycznejWystawcyRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->wyszukaniePlanowOpiekiMedycznejWystawcy($wyszukaniePlanowOpiekiMedycznejWystawcyRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * wyszukaniePlanowOpiekiMedycznejUslugobiorcy
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20180509
     * - SOAPHeaderTypes: \AureroIpom\StructType\KontekstMT
     * - SOAPHeaders: required
     * - documentation: Operacja wyszukania dokumentów indywidualnych planów opieki medycznej wskazanego usługobiorcy.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AureroIpom\StructType\WyszukaniePlanowOpiekiMedycznejUslugobiorcyRequest $wyszukaniePlanowOpiekiMedycznejUslugobiorcyRequest
     * @return \AureroIpom\StructType\WyszukaniePlanowOpiekiMedycznejResponse|bool
     */
    public function wyszukaniePlanowOpiekiMedycznejUslugobiorcy(\AureroIpom\StructType\WyszukaniePlanowOpiekiMedycznejUslugobiorcyRequest $wyszukaniePlanowOpiekiMedycznejUslugobiorcyRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->wyszukaniePlanowOpiekiMedycznejUslugobiorcy($wyszukaniePlanowOpiekiMedycznejUslugobiorcyRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AureroIpom\StructType\WyszukaniePlanowOpiekiMedycznejResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
