<?php

namespace AureroIpom\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Odczyt ServiceType
 * @subpackage Services
 */
class Odczyt extends AbstractSoapClientBase
{
    /**
     * Sets the KontekstWywolania SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AureroIpom\StructType\KontekstMT $kontekstWywolania
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderKontekstWywolania(\AureroIpom\StructType\KontekstMT $kontekstWywolania, $nameSpace = 'http://csioz.gov.pl/p1/kontekst/mt/v20180509', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'kontekstWywolania', $kontekstWywolania, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named odczytPlanuOpiekiMedycznej
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20180509
     * - SOAPHeaderTypes: \AureroIpom\StructType\KontekstMT
     * - SOAPHeaders: required
     * - documentation: Operacja odczytu dokumentu indywidualnego planu opieki medycznej.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AureroIpom\StructType\OdczytPlanuOpiekiMedycznejRequest $odczytPlanuOpiekiMedycznejRequest
     * @return \AureroIpom\StructType\OdczytPlanuOpiekiMedycznejResponse|bool
     */
    public function odczytPlanuOpiekiMedycznej(\AureroIpom\StructType\OdczytPlanuOpiekiMedycznejRequest $odczytPlanuOpiekiMedycznejRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->odczytPlanuOpiekiMedycznej($odczytPlanuOpiekiMedycznejRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * odczytAktualnegoHarmonogramuPlanuOpiekiMedycznej
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20180509
     * - SOAPHeaderTypes: \AureroIpom\StructType\KontekstMT
     * - SOAPHeaders: required
     * - documentation: Operacja odczytu aktualnego dokumentu harmonogramu indywidualnego planu opieki medycznej.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AureroIpom\StructType\OdczytAktualnegoHarmonogramuPlanuOpiekiMedycznejRequest $odczytAktualnegoHarmonogramuPlanuOpiekiMedycznejRequest
     * @return \AureroIpom\StructType\OdczytAktualnegoHarmonogramuPlanuOpiekiMedycznejResponse|bool
     */
    public function odczytAktualnegoHarmonogramuPlanuOpiekiMedycznej(\AureroIpom\StructType\OdczytAktualnegoHarmonogramuPlanuOpiekiMedycznejRequest $odczytAktualnegoHarmonogramuPlanuOpiekiMedycznejRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->odczytAktualnegoHarmonogramuPlanuOpiekiMedycznej($odczytAktualnegoHarmonogramuPlanuOpiekiMedycznejRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * odczytWersjiHistorycznejPlanuOpiekiMedycznej
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20180509
     * - SOAPHeaderTypes: \AureroIpom\StructType\KontekstMT
     * - SOAPHeaders: required
     * - documentation: Operacja odczytu wersji historycznej planu opieki medycznej.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AureroIpom\StructType\OdczytWersjiHistorycznejPlanuOpiekiMedycznejRequest $odczytWersjiHistorycznejPlanuOpiekiMedycznejRequest
     * @return \AureroIpom\StructType\OdczytWersjiHistorycznejPlanuOpiekiMedycznejResponse|bool
     */
    public function odczytWersjiHistorycznejPlanuOpiekiMedycznej(\AureroIpom\StructType\OdczytWersjiHistorycznejPlanuOpiekiMedycznejRequest $odczytWersjiHistorycznejPlanuOpiekiMedycznejRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->odczytWersjiHistorycznejPlanuOpiekiMedycznej($odczytWersjiHistorycznejPlanuOpiekiMedycznejRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * odczytWersjiHistorycznejHarmonogramuPlanuOpiekiMedycznej
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20180509
     * - SOAPHeaderTypes: \AureroIpom\StructType\KontekstMT
     * - SOAPHeaders: required
     * - documentation: Operacja odczytu wersji historycznej harmonogramu planu opieki medycznej.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AureroIpom\StructType\OdczytWersjiHistorycznejHarmonogramuPlanuOpiekiMedycznejRequest $odczytWersjiHistorycznejHarmonogramuPlanuOpiekiMedycznejRequest
     * @return \AureroIpom\StructType\OdczytWersjiHistorycznejHarmonogramuPlanuOpiekiMedycznejResponse|bool
     */
    public function odczytWersjiHistorycznejHarmonogramuPlanuOpiekiMedycznej(\AureroIpom\StructType\OdczytWersjiHistorycznejHarmonogramuPlanuOpiekiMedycznejRequest $odczytWersjiHistorycznejHarmonogramuPlanuOpiekiMedycznejRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->odczytWersjiHistorycznejHarmonogramuPlanuOpiekiMedycznej($odczytWersjiHistorycznejHarmonogramuPlanuOpiekiMedycznejRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AureroIpom\StructType\OdczytAktualnegoHarmonogramuPlanuOpiekiMedycznejResponse|\AureroIpom\StructType\OdczytPlanuOpiekiMedycznejResponse|\AureroIpom\StructType\OdczytWersjiHistorycznejHarmonogramuPlanuOpiekiMedycznejResponse|\AureroIpom\StructType\OdczytWersjiHistorycznejPlanuOpiekiMedycznejResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
