<?php

namespace AureroIpom\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WynikMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Klasa z wynikiem wykonania operacji biznesowej. Lista kodów operacji (major, minor) oraz komunikatów jest dostępna w dokumentacji integracyjnej.
 * @subpackage Structs
 */
class WynikMT extends AbstractStructBase
{
    /**
     * The major
     * Meta information extracted from the WSDL
     * - documentation: Kod główny wyniku.
     * @var string
     */
    public $major;
    /**
     * The minor
     * Meta information extracted from the WSDL
     * - documentation: Uzupełniający kod wyniku.
     * - minOccurs: 0
     * @var string
     */
    public $minor;
    /**
     * The komunikat
     * Meta information extracted from the WSDL
     * - documentation: Treść komunikatu związanego z wynikiem operacji.
     * - minOccurs: 0
     * @var string
     */
    public $komunikat;
    /**
     * Constructor method for WynikMT
     * @uses WynikMT::setMajor()
     * @uses WynikMT::setMinor()
     * @uses WynikMT::setKomunikat()
     * @param string $major
     * @param string $minor
     * @param string $komunikat
     */
    public function __construct($major = null, $minor = null, $komunikat = null)
    {
        $this
            ->setMajor($major)
            ->setMinor($minor)
            ->setKomunikat($komunikat);
    }
    /**
     * Get major value
     * @return string|null
     */
    public function getMajor()
    {
        return $this->major;
    }
    /**
     * Set major value
     * @param string $major
     * @return \AureroIpom\StructType\WynikMT
     */
    public function setMajor($major = null)
    {
        // validation for constraint: string
        if (!is_null($major) && !is_string($major)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($major, true), gettype($major)), __LINE__);
        }
        $this->major = $major;
        return $this;
    }
    /**
     * Get minor value
     * @return string|null
     */
    public function getMinor()
    {
        return $this->minor;
    }
    /**
     * Set minor value
     * @param string $minor
     * @return \AureroIpom\StructType\WynikMT
     */
    public function setMinor($minor = null)
    {
        // validation for constraint: string
        if (!is_null($minor) && !is_string($minor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minor, true), gettype($minor)), __LINE__);
        }
        $this->minor = $minor;
        return $this;
    }
    /**
     * Get komunikat value
     * @return string|null
     */
    public function getKomunikat()
    {
        return $this->komunikat;
    }
    /**
     * Set komunikat value
     * @param string $komunikat
     * @return \AureroIpom\StructType\WynikMT
     */
    public function setKomunikat($komunikat = null)
    {
        // validation for constraint: string
        if (!is_null($komunikat) && !is_string($komunikat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($komunikat, true), gettype($komunikat)), __LINE__);
        }
        $this->komunikat = $komunikat;
        return $this;
    }
}
