<?php

namespace AureroIpom\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Zapis ServiceType
 * @subpackage Services
 */
class Zapis extends AbstractSoapClientBase
{
    /**
     * Sets the KontekstWywolania SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \AureroIpom\StructType\KontekstMT $kontekstWywolania
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderKontekstWywolania(\AureroIpom\StructType\KontekstMT $kontekstWywolania, $nameSpace = 'http://csioz.gov.pl/p1/kontekst/mt/v20180509', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'kontekstWywolania', $kontekstWywolania, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named zapisPlanuOpiekiMedycznej
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20180509
     * - SOAPHeaderTypes: \AureroIpom\StructType\KontekstMT
     * - SOAPHeaders: required
     * - documentation: Operacja zapisu dokumentu indywidualnego planu opieki medycznej.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AureroIpom\StructType\ZapisPlanuOpiekiMedycznejRequest $zapisPlanuOpiekiMedycznejRequest
     * @return \AureroIpom\StructType\ZapisPlanuOpiekiMedycznejResponse|bool
     */
    public function zapisPlanuOpiekiMedycznej(\AureroIpom\StructType\ZapisPlanuOpiekiMedycznejRequest $zapisPlanuOpiekiMedycznejRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->zapisPlanuOpiekiMedycznej($zapisPlanuOpiekiMedycznejRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * zapisHarmonogramuPlanuOpiekiMedycznej
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20180509
     * - SOAPHeaderTypes: \AureroIpom\StructType\KontekstMT
     * - SOAPHeaders: required
     * - documentation: Operacja zapisu aktualnego dokumentu harmonogramu planu opieki medycznej.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AureroIpom\StructType\ZapisHarmonogramuPlanuOpiekiMedycznejRequest $zapisHarmonogramuPlanuOpiekiMedycznejRequest
     * @return \AureroIpom\StructType\ZapisHarmonogramuPlanuOpiekiMedycznejResponse|bool
     */
    public function zapisHarmonogramuPlanuOpiekiMedycznej(\AureroIpom\StructType\ZapisHarmonogramuPlanuOpiekiMedycznejRequest $zapisHarmonogramuPlanuOpiekiMedycznejRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->zapisHarmonogramuPlanuOpiekiMedycznej($zapisHarmonogramuPlanuOpiekiMedycznejRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * zapisAnulowaniaPlanuOpiekiMedycznej
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20180509
     * - SOAPHeaderTypes: \AureroIpom\StructType\KontekstMT
     * - SOAPHeaders: required
     * - documentation: Operacja zapisu dokumentu anulowania planu opieki medycznej.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AureroIpom\StructType\ZapisAnulowaniaPlanuOpiekiMedycznejRequest $zapisAnulowaniaPlanuOpiekiMedycznejRequest
     * @return \AureroIpom\StructType\ZapisAnulowaniaPlanuOpiekiMedycznejResponse|bool
     */
    public function zapisAnulowaniaPlanuOpiekiMedycznej(\AureroIpom\StructType\ZapisAnulowaniaPlanuOpiekiMedycznejRequest $zapisAnulowaniaPlanuOpiekiMedycznejRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->zapisAnulowaniaPlanuOpiekiMedycznej($zapisAnulowaniaPlanuOpiekiMedycznejRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * zapisAnulowaniaHarmonogramuPlanuOpiekiMedycznej
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20180509
     * - SOAPHeaderTypes: \AureroIpom\StructType\KontekstMT
     * - SOAPHeaders: required
     * - documentation: Operacja zapisu dokumentu anulowania harmonogramu planu opieki medycznej.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \AureroIpom\StructType\ZapisAnulowaniaHarmonogramuPlanuOpiekiMedycznejRequest $zapisAnulowaniaHarmonogramuPlanuOpiekiMedycznejRequest
     * @return \AureroIpom\StructType\ZapisAnulowaniaHarmonogramuPlanuOpiekiMedycznejResponse|bool
     */
    public function zapisAnulowaniaHarmonogramuPlanuOpiekiMedycznej(\AureroIpom\StructType\ZapisAnulowaniaHarmonogramuPlanuOpiekiMedycznejRequest $zapisAnulowaniaHarmonogramuPlanuOpiekiMedycznejRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->zapisAnulowaniaHarmonogramuPlanuOpiekiMedycznej($zapisAnulowaniaHarmonogramuPlanuOpiekiMedycznejRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \AureroIpom\StructType\ZapisAnulowaniaHarmonogramuPlanuOpiekiMedycznejResponse|\AureroIpom\StructType\ZapisAnulowaniaPlanuOpiekiMedycznejResponse|\AureroIpom\StructType\ZapisHarmonogramuPlanuOpiekiMedycznejResponse|\AureroIpom\StructType\ZapisPlanuOpiekiMedycznejResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
