<?php

namespace AureroIpom\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WyszukaniePlanowOpiekiMedycznejUslugobiorcyRequest
 * StructType
 * Meta information extracted from the WSDL
 * - type: ns:WyszukaniePlanowOpiekiMedycznejUslugobiorcyRequest
 * @subpackage Structs
 */
class WyszukaniePlanowOpiekiMedycznejUslugobiorcyRequest extends AbstractStructBase
{
    /**
     * The dataWystawieniaOd
     * Meta information extracted from the WSDL
     * - documentation: Data zapisu dokumentów indywidualnych planów opieki medycznej.
     * - minOccurs: 0
     * @var string
     */
    public $dataWystawieniaOd;
    /**
     * The dataWystawieniaDo
     * Meta information extracted from the WSDL
     * - documentation: Graniczna data zapisu dokumentów indywidualnych planów opieki medycznej.
     * - minOccurs: 0
     * @var string
     */
    public $dataWystawieniaDo;
    /**
     * The identyfikatorUslugobiorcy
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator usługobiorcy, którego dotyczą wyszukiwane dokumenty.
     * @var \AureroIpom\StructType\IdentyfikatorOIDMT
     */
    public $identyfikatorUslugobiorcy;
    /**
     * The identyfikatorAutora
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator wystawcy wyszukiwanego dokumentu.
     * - minOccurs: 0
     * @var \AureroIpom\StructType\IdentyfikatorOIDMT
     */
    public $identyfikatorAutora;
    /**
     * The identyfikatorPodmiotuAutora
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator podmiotu w ramach którego wystawiono dokument.
     * - minOccurs: 0
     * @var \AureroIpom\StructType\IdentyfikatorOIDMT
     */
    public $identyfikatorPodmiotuAutora;
    /**
     * The statusDokumentu
     * Meta information extracted from the WSDL
     * - documentation: Status dokumentu planu opieki medycznej.
     * - minOccurs: 0
     * @var string
     */
    public $statusDokumentu;
    /**
     * The wlasciwosciWyszukiwania
     * Meta information extracted from the WSDL
     * - documentation: Dodatkowe parametry wyszukiwania.
     * @var \AureroIpom\StructType\WlasciwosciWyszukiwaniaMT
     */
    public $wlasciwosciWyszukiwania;
    /**
     * Constructor method for WyszukaniePlanowOpiekiMedycznejUslugobiorcyRequest
     * @uses WyszukaniePlanowOpiekiMedycznejUslugobiorcyRequest::setDataWystawieniaOd()
     * @uses WyszukaniePlanowOpiekiMedycznejUslugobiorcyRequest::setDataWystawieniaDo()
     * @uses WyszukaniePlanowOpiekiMedycznejUslugobiorcyRequest::setIdentyfikatorUslugobiorcy()
     * @uses WyszukaniePlanowOpiekiMedycznejUslugobiorcyRequest::setIdentyfikatorAutora()
     * @uses WyszukaniePlanowOpiekiMedycznejUslugobiorcyRequest::setIdentyfikatorPodmiotuAutora()
     * @uses WyszukaniePlanowOpiekiMedycznejUslugobiorcyRequest::setStatusDokumentu()
     * @uses WyszukaniePlanowOpiekiMedycznejUslugobiorcyRequest::setWlasciwosciWyszukiwania()
     * @param string $dataWystawieniaOd
     * @param string $dataWystawieniaDo
     * @param \AureroIpom\StructType\IdentyfikatorOIDMT $identyfikatorUslugobiorcy
     * @param \AureroIpom\StructType\IdentyfikatorOIDMT $identyfikatorAutora
     * @param \AureroIpom\StructType\IdentyfikatorOIDMT $identyfikatorPodmiotuAutora
     * @param string $statusDokumentu
     * @param \AureroIpom\StructType\WlasciwosciWyszukiwaniaMT $wlasciwosciWyszukiwania
     */
    public function __construct($dataWystawieniaOd = null, $dataWystawieniaDo = null, \AureroIpom\StructType\IdentyfikatorOIDMT $identyfikatorUslugobiorcy = null, \AureroIpom\StructType\IdentyfikatorOIDMT $identyfikatorAutora = null, \AureroIpom\StructType\IdentyfikatorOIDMT $identyfikatorPodmiotuAutora = null, $statusDokumentu = null, \AureroIpom\StructType\WlasciwosciWyszukiwaniaMT $wlasciwosciWyszukiwania = null)
    {
        $this
            ->setDataWystawieniaOd($dataWystawieniaOd)
            ->setDataWystawieniaDo($dataWystawieniaDo)
            ->setIdentyfikatorUslugobiorcy($identyfikatorUslugobiorcy)
            ->setIdentyfikatorAutora($identyfikatorAutora)
            ->setIdentyfikatorPodmiotuAutora($identyfikatorPodmiotuAutora)
            ->setStatusDokumentu($statusDokumentu)
            ->setWlasciwosciWyszukiwania($wlasciwosciWyszukiwania);
    }
    /**
     * Get dataWystawieniaOd value
     * @return string|null
     */
    public function getDataWystawieniaOd()
    {
        return $this->dataWystawieniaOd;
    }
    /**
     * Set dataWystawieniaOd value
     * @param string $dataWystawieniaOd
     * @return \AureroIpom\StructType\WyszukaniePlanowOpiekiMedycznejUslugobiorcyRequest
     */
    public function setDataWystawieniaOd($dataWystawieniaOd = null)
    {
        // validation for constraint: string
        if (!is_null($dataWystawieniaOd) && !is_string($dataWystawieniaOd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataWystawieniaOd, true), gettype($dataWystawieniaOd)), __LINE__);
        }
        $this->dataWystawieniaOd = $dataWystawieniaOd;
        return $this;
    }
    /**
     * Get dataWystawieniaDo value
     * @return string|null
     */
    public function getDataWystawieniaDo()
    {
        return $this->dataWystawieniaDo;
    }
    /**
     * Set dataWystawieniaDo value
     * @param string $dataWystawieniaDo
     * @return \AureroIpom\StructType\WyszukaniePlanowOpiekiMedycznejUslugobiorcyRequest
     */
    public function setDataWystawieniaDo($dataWystawieniaDo = null)
    {
        // validation for constraint: string
        if (!is_null($dataWystawieniaDo) && !is_string($dataWystawieniaDo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataWystawieniaDo, true), gettype($dataWystawieniaDo)), __LINE__);
        }
        $this->dataWystawieniaDo = $dataWystawieniaDo;
        return $this;
    }
    /**
     * Get identyfikatorUslugobiorcy value
     * @return \AureroIpom\StructType\IdentyfikatorOIDMT|null
     */
    public function getIdentyfikatorUslugobiorcy()
    {
        return $this->identyfikatorUslugobiorcy;
    }
    /**
     * Set identyfikatorUslugobiorcy value
     * @param \AureroIpom\StructType\IdentyfikatorOIDMT $identyfikatorUslugobiorcy
     * @return \AureroIpom\StructType\WyszukaniePlanowOpiekiMedycznejUslugobiorcyRequest
     */
    public function setIdentyfikatorUslugobiorcy(\AureroIpom\StructType\IdentyfikatorOIDMT $identyfikatorUslugobiorcy = null)
    {
        $this->identyfikatorUslugobiorcy = $identyfikatorUslugobiorcy;
        return $this;
    }
    /**
     * Get identyfikatorAutora value
     * @return \AureroIpom\StructType\IdentyfikatorOIDMT|null
     */
    public function getIdentyfikatorAutora()
    {
        return $this->identyfikatorAutora;
    }
    /**
     * Set identyfikatorAutora value
     * @param \AureroIpom\StructType\IdentyfikatorOIDMT $identyfikatorAutora
     * @return \AureroIpom\StructType\WyszukaniePlanowOpiekiMedycznejUslugobiorcyRequest
     */
    public function setIdentyfikatorAutora(\AureroIpom\StructType\IdentyfikatorOIDMT $identyfikatorAutora = null)
    {
        $this->identyfikatorAutora = $identyfikatorAutora;
        return $this;
    }
    /**
     * Get identyfikatorPodmiotuAutora value
     * @return \AureroIpom\StructType\IdentyfikatorOIDMT|null
     */
    public function getIdentyfikatorPodmiotuAutora()
    {
        return $this->identyfikatorPodmiotuAutora;
    }
    /**
     * Set identyfikatorPodmiotuAutora value
     * @param \AureroIpom\StructType\IdentyfikatorOIDMT $identyfikatorPodmiotuAutora
     * @return \AureroIpom\StructType\WyszukaniePlanowOpiekiMedycznejUslugobiorcyRequest
     */
    public function setIdentyfikatorPodmiotuAutora(\AureroIpom\StructType\IdentyfikatorOIDMT $identyfikatorPodmiotuAutora = null)
    {
        $this->identyfikatorPodmiotuAutora = $identyfikatorPodmiotuAutora;
        return $this;
    }
    /**
     * Get statusDokumentu value
     * @return string|null
     */
    public function getStatusDokumentu()
    {
        return $this->statusDokumentu;
    }
    /**
     * Set statusDokumentu value
     * @uses \AureroIpom\EnumType\StatusDokumentuPlanuOpiekiMedycznejEnumMT::valueIsValid()
     * @uses \AureroIpom\EnumType\StatusDokumentuPlanuOpiekiMedycznejEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statusDokumentu
     * @return \AureroIpom\StructType\WyszukaniePlanowOpiekiMedycznejUslugobiorcyRequest
     */
    public function setStatusDokumentu($statusDokumentu = null)
    {
        // validation for constraint: enumeration
        if (!\AureroIpom\EnumType\StatusDokumentuPlanuOpiekiMedycznejEnumMT::valueIsValid($statusDokumentu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \AureroIpom\EnumType\StatusDokumentuPlanuOpiekiMedycznejEnumMT', is_array($statusDokumentu) ? implode(', ', $statusDokumentu) : var_export($statusDokumentu, true), implode(', ', \AureroIpom\EnumType\StatusDokumentuPlanuOpiekiMedycznejEnumMT::getValidValues())), __LINE__);
        }
        $this->statusDokumentu = $statusDokumentu;
        return $this;
    }
    /**
     * Get wlasciwosciWyszukiwania value
     * @return \AureroIpom\StructType\WlasciwosciWyszukiwaniaMT|null
     */
    public function getWlasciwosciWyszukiwania()
    {
        return $this->wlasciwosciWyszukiwania;
    }
    /**
     * Set wlasciwosciWyszukiwania value
     * @param \AureroIpom\StructType\WlasciwosciWyszukiwaniaMT $wlasciwosciWyszukiwania
     * @return \AureroIpom\StructType\WyszukaniePlanowOpiekiMedycznejUslugobiorcyRequest
     */
    public function setWlasciwosciWyszukiwania(\AureroIpom\StructType\WlasciwosciWyszukiwaniaMT $wlasciwosciWyszukiwania = null)
    {
        $this->wlasciwosciWyszukiwania = $wlasciwosciWyszukiwania;
        return $this;
    }
}
