<?php

namespace AureroIpom\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * WynikPobraniaListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznejMT
 * StructType
 * Meta information extracted from the WSDL
 * - documentation: Pojedynczy wynik pobrania listy wersji historycznych harmonogramów indywidualnego planu opieki medycznej.
 * @subpackage Structs
 */
class WynikPobraniaListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznejMT extends AbstractStructBase
{
    /**
     * The identyfikatorZbioruWersji
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator zbioru wersji dokumentu harmonogramu planu opieki medycznej.
     * @var \AureroIpom\StructType\IdentyfikatorOIDMT
     */
    public $identyfikatorZbioruWersji;
    /**
     * The numerWersji
     * Meta information extracted from the WSDL
     * - documentation: Numer wersji dokumentu harmonogramu planu opieki medycznej.
     * @var int
     */
    public $numerWersji;
    /**
     * The identyfikatorAutora
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator OID autora dokumentu harmonogramu planu opieki medycznej.
     * @var \AureroIpom\StructType\IdentyfikatorOIDMT
     */
    public $identyfikatorAutora;
    /**
     * The nazwaAutora
     * Meta information extracted from the WSDL
     * - documentation: Nazwa autora wyszukiwanego dokumentu.
     * @var string
     */
    public $nazwaAutora;
    /**
     * The identyfikatorPodmiotuAutora
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator OID podmiotu, w ramach którego wystawiono dokument harmonogramu indywidualnego planu opieki medycznej.
     * @var \AureroIpom\StructType\IdentyfikatorOIDMT
     */
    public $identyfikatorPodmiotuAutora;
    /**
     * The dataWystawienia
     * Meta information extracted from the WSDL
     * - documentation: Data wystawienia dokumentu harmonogramu indywidualnego planu opieki medycznej.
     * @var string
     */
    public $dataWystawienia;
    /**
     * Constructor method for
     * WynikPobraniaListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznejMT
     * @uses WynikPobraniaListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznejMT::setIdentyfikatorZbioruWersji()
     * @uses WynikPobraniaListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznejMT::setNumerWersji()
     * @uses WynikPobraniaListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznejMT::setIdentyfikatorAutora()
     * @uses WynikPobraniaListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznejMT::setNazwaAutora()
     * @uses WynikPobraniaListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznejMT::setIdentyfikatorPodmiotuAutora()
     * @uses WynikPobraniaListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznejMT::setDataWystawienia()
     * @param \AureroIpom\StructType\IdentyfikatorOIDMT $identyfikatorZbioruWersji
     * @param int $numerWersji
     * @param \AureroIpom\StructType\IdentyfikatorOIDMT $identyfikatorAutora
     * @param string $nazwaAutora
     * @param \AureroIpom\StructType\IdentyfikatorOIDMT $identyfikatorPodmiotuAutora
     * @param string $dataWystawienia
     */
    public function __construct(\AureroIpom\StructType\IdentyfikatorOIDMT $identyfikatorZbioruWersji = null, $numerWersji = null, \AureroIpom\StructType\IdentyfikatorOIDMT $identyfikatorAutora = null, $nazwaAutora = null, \AureroIpom\StructType\IdentyfikatorOIDMT $identyfikatorPodmiotuAutora = null, $dataWystawienia = null)
    {
        $this
            ->setIdentyfikatorZbioruWersji($identyfikatorZbioruWersji)
            ->setNumerWersji($numerWersji)
            ->setIdentyfikatorAutora($identyfikatorAutora)
            ->setNazwaAutora($nazwaAutora)
            ->setIdentyfikatorPodmiotuAutora($identyfikatorPodmiotuAutora)
            ->setDataWystawienia($dataWystawienia);
    }
    /**
     * Get identyfikatorZbioruWersji value
     * @return \AureroIpom\StructType\IdentyfikatorOIDMT|null
     */
    public function getIdentyfikatorZbioruWersji()
    {
        return $this->identyfikatorZbioruWersji;
    }
    /**
     * Set identyfikatorZbioruWersji value
     * @param \AureroIpom\StructType\IdentyfikatorOIDMT $identyfikatorZbioruWersji
     * @return \AureroIpom\StructType\WynikPobraniaListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznejMT
     */
    public function setIdentyfikatorZbioruWersji(\AureroIpom\StructType\IdentyfikatorOIDMT $identyfikatorZbioruWersji = null)
    {
        $this->identyfikatorZbioruWersji = $identyfikatorZbioruWersji;
        return $this;
    }
    /**
     * Get numerWersji value
     * @return int|null
     */
    public function getNumerWersji()
    {
        return $this->numerWersji;
    }
    /**
     * Set numerWersji value
     * @param int $numerWersji
     * @return \AureroIpom\StructType\WynikPobraniaListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznejMT
     */
    public function setNumerWersji($numerWersji = null)
    {
        // validation for constraint: int
        if (!is_null($numerWersji) && !(is_int($numerWersji) || ctype_digit($numerWersji))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numerWersji, true), gettype($numerWersji)), __LINE__);
        }
        $this->numerWersji = $numerWersji;
        return $this;
    }
    /**
     * Get identyfikatorAutora value
     * @return \AureroIpom\StructType\IdentyfikatorOIDMT|null
     */
    public function getIdentyfikatorAutora()
    {
        return $this->identyfikatorAutora;
    }
    /**
     * Set identyfikatorAutora value
     * @param \AureroIpom\StructType\IdentyfikatorOIDMT $identyfikatorAutora
     * @return \AureroIpom\StructType\WynikPobraniaListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznejMT
     */
    public function setIdentyfikatorAutora(\AureroIpom\StructType\IdentyfikatorOIDMT $identyfikatorAutora = null)
    {
        $this->identyfikatorAutora = $identyfikatorAutora;
        return $this;
    }
    /**
     * Get nazwaAutora value
     * @return string|null
     */
    public function getNazwaAutora()
    {
        return $this->nazwaAutora;
    }
    /**
     * Set nazwaAutora value
     * @param string $nazwaAutora
     * @return \AureroIpom\StructType\WynikPobraniaListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznejMT
     */
    public function setNazwaAutora($nazwaAutora = null)
    {
        // validation for constraint: string
        if (!is_null($nazwaAutora) && !is_string($nazwaAutora)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazwaAutora, true), gettype($nazwaAutora)), __LINE__);
        }
        $this->nazwaAutora = $nazwaAutora;
        return $this;
    }
    /**
     * Get identyfikatorPodmiotuAutora value
     * @return \AureroIpom\StructType\IdentyfikatorOIDMT|null
     */
    public function getIdentyfikatorPodmiotuAutora()
    {
        return $this->identyfikatorPodmiotuAutora;
    }
    /**
     * Set identyfikatorPodmiotuAutora value
     * @param \AureroIpom\StructType\IdentyfikatorOIDMT $identyfikatorPodmiotuAutora
     * @return \AureroIpom\StructType\WynikPobraniaListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznejMT
     */
    public function setIdentyfikatorPodmiotuAutora(\AureroIpom\StructType\IdentyfikatorOIDMT $identyfikatorPodmiotuAutora = null)
    {
        $this->identyfikatorPodmiotuAutora = $identyfikatorPodmiotuAutora;
        return $this;
    }
    /**
     * Get dataWystawienia value
     * @return string|null
     */
    public function getDataWystawienia()
    {
        return $this->dataWystawienia;
    }
    /**
     * Set dataWystawienia value
     * @param string $dataWystawienia
     * @return \AureroIpom\StructType\WynikPobraniaListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznejMT
     */
    public function setDataWystawienia($dataWystawienia = null)
    {
        // validation for constraint: string
        if (!is_null($dataWystawienia) && !is_string($dataWystawienia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataWystawienia, true), gettype($dataWystawienia)), __LINE__);
        }
        $this->dataWystawienia = $dataWystawienia;
        return $this;
    }
}
