<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WynikWyszukiwaniaPlanowOpiekiMedycznejMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Pojedynczy wynik wyszukiwania dokumentów indywidualnych planów opieki medycznej.
 * @subpackage Structs
 */
class WynikWyszukiwaniaPlanowOpiekiMedycznejMT extends AbstractStructBase
{
    /**
     * The identyfikatorPlanuOpiekiMedycznej
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator OID dokumentu indywidualnego planu opieki medycznej.
     * @var \StructType\IdentyfikatorOIDMT
     */
    public $identyfikatorPlanuOpiekiMedycznej;
    /**
     * The identyfikatorAutora
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator OID autora dokumentu indywidualnego planu opieki medycznej.
     * @var \StructType\IdentyfikatorOIDMT
     */
    public $identyfikatorAutora;
    /**
     * The nazwaAutora
     * Meta information extracted from the WSDL
     * - documentation: Nazwa wystawcy wyszukiwanego dokumentu.
     * @var string
     */
    public $nazwaAutora;
    /**
     * The identyfikatorPodmiotuAutora
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator OID podmiotu w ramach którego wystawiono dokument indywidualnego planu opieki medycznej.
     * @var \StructType\IdentyfikatorOIDMT
     */
    public $identyfikatorPodmiotuAutora;
    /**
     * The dataWystawienia
     * Meta information extracted from the WSDL
     * - documentation: Data wystawienia dokumentu indywidualnego planu opieki medycznej.
     * @var string
     */
    public $dataWystawienia;
    /**
     * The numerWersji
     * Meta information extracted from the WSDL
     * - documentation: Numer wersji dokumentu planu opieki medycznej.
     * @var int
     */
    public $numerWersji;
    /**
     * The statusDokumentu
     * Meta information extracted from the WSDL
     * - documentation: Status dokumentu planu opieki medycznej.
     * @var string
     */
    public $statusDokumentu;
    /**
     * Constructor method for WynikWyszukiwaniaPlanowOpiekiMedycznejMT
     * @uses WynikWyszukiwaniaPlanowOpiekiMedycznejMT::setIdentyfikatorPlanuOpiekiMedycznej()
     * @uses WynikWyszukiwaniaPlanowOpiekiMedycznejMT::setIdentyfikatorAutora()
     * @uses WynikWyszukiwaniaPlanowOpiekiMedycznejMT::setNazwaAutora()
     * @uses WynikWyszukiwaniaPlanowOpiekiMedycznejMT::setIdentyfikatorPodmiotuAutora()
     * @uses WynikWyszukiwaniaPlanowOpiekiMedycznejMT::setDataWystawienia()
     * @uses WynikWyszukiwaniaPlanowOpiekiMedycznejMT::setNumerWersji()
     * @uses WynikWyszukiwaniaPlanowOpiekiMedycznejMT::setStatusDokumentu()
     * @param \StructType\IdentyfikatorOIDMT $identyfikatorPlanuOpiekiMedycznej
     * @param \StructType\IdentyfikatorOIDMT $identyfikatorAutora
     * @param string $nazwaAutora
     * @param \StructType\IdentyfikatorOIDMT $identyfikatorPodmiotuAutora
     * @param string $dataWystawienia
     * @param int $numerWersji
     * @param string $statusDokumentu
     */
    public function __construct(\StructType\IdentyfikatorOIDMT $identyfikatorPlanuOpiekiMedycznej = null, \StructType\IdentyfikatorOIDMT $identyfikatorAutora = null, $nazwaAutora = null, \StructType\IdentyfikatorOIDMT $identyfikatorPodmiotuAutora = null, $dataWystawienia = null, $numerWersji = null, $statusDokumentu = null)
    {
        $this
            ->setIdentyfikatorPlanuOpiekiMedycznej($identyfikatorPlanuOpiekiMedycznej)
            ->setIdentyfikatorAutora($identyfikatorAutora)
            ->setNazwaAutora($nazwaAutora)
            ->setIdentyfikatorPodmiotuAutora($identyfikatorPodmiotuAutora)
            ->setDataWystawienia($dataWystawienia)
            ->setNumerWersji($numerWersji)
            ->setStatusDokumentu($statusDokumentu);
    }
    /**
     * Get identyfikatorPlanuOpiekiMedycznej value
     * @return \StructType\IdentyfikatorOIDMT|null
     */
    public function getIdentyfikatorPlanuOpiekiMedycznej()
    {
        return $this->identyfikatorPlanuOpiekiMedycznej;
    }
    /**
     * Set identyfikatorPlanuOpiekiMedycznej value
     * @param \StructType\IdentyfikatorOIDMT $identyfikatorPlanuOpiekiMedycznej
     * @return \StructType\WynikWyszukiwaniaPlanowOpiekiMedycznejMT
     */
    public function setIdentyfikatorPlanuOpiekiMedycznej(\StructType\IdentyfikatorOIDMT $identyfikatorPlanuOpiekiMedycznej = null)
    {
        $this->identyfikatorPlanuOpiekiMedycznej = $identyfikatorPlanuOpiekiMedycznej;
        return $this;
    }
    /**
     * Get identyfikatorAutora value
     * @return \StructType\IdentyfikatorOIDMT|null
     */
    public function getIdentyfikatorAutora()
    {
        return $this->identyfikatorAutora;
    }
    /**
     * Set identyfikatorAutora value
     * @param \StructType\IdentyfikatorOIDMT $identyfikatorAutora
     * @return \StructType\WynikWyszukiwaniaPlanowOpiekiMedycznejMT
     */
    public function setIdentyfikatorAutora(\StructType\IdentyfikatorOIDMT $identyfikatorAutora = null)
    {
        $this->identyfikatorAutora = $identyfikatorAutora;
        return $this;
    }
    /**
     * Get nazwaAutora value
     * @return string|null
     */
    public function getNazwaAutora()
    {
        return $this->nazwaAutora;
    }
    /**
     * Set nazwaAutora value
     * @param string $nazwaAutora
     * @return \StructType\WynikWyszukiwaniaPlanowOpiekiMedycznejMT
     */
    public function setNazwaAutora($nazwaAutora = null)
    {
        // validation for constraint: string
        if (!is_null($nazwaAutora) && !is_string($nazwaAutora)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazwaAutora, true), gettype($nazwaAutora)), __LINE__);
        }
        $this->nazwaAutora = $nazwaAutora;
        return $this;
    }
    /**
     * Get identyfikatorPodmiotuAutora value
     * @return \StructType\IdentyfikatorOIDMT|null
     */
    public function getIdentyfikatorPodmiotuAutora()
    {
        return $this->identyfikatorPodmiotuAutora;
    }
    /**
     * Set identyfikatorPodmiotuAutora value
     * @param \StructType\IdentyfikatorOIDMT $identyfikatorPodmiotuAutora
     * @return \StructType\WynikWyszukiwaniaPlanowOpiekiMedycznejMT
     */
    public function setIdentyfikatorPodmiotuAutora(\StructType\IdentyfikatorOIDMT $identyfikatorPodmiotuAutora = null)
    {
        $this->identyfikatorPodmiotuAutora = $identyfikatorPodmiotuAutora;
        return $this;
    }
    /**
     * Get dataWystawienia value
     * @return string|null
     */
    public function getDataWystawienia()
    {
        return $this->dataWystawienia;
    }
    /**
     * Set dataWystawienia value
     * @param string $dataWystawienia
     * @return \StructType\WynikWyszukiwaniaPlanowOpiekiMedycznejMT
     */
    public function setDataWystawienia($dataWystawienia = null)
    {
        // validation for constraint: string
        if (!is_null($dataWystawienia) && !is_string($dataWystawienia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataWystawienia, true), gettype($dataWystawienia)), __LINE__);
        }
        $this->dataWystawienia = $dataWystawienia;
        return $this;
    }
    /**
     * Get numerWersji value
     * @return int|null
     */
    public function getNumerWersji()
    {
        return $this->numerWersji;
    }
    /**
     * Set numerWersji value
     * @param int $numerWersji
     * @return \StructType\WynikWyszukiwaniaPlanowOpiekiMedycznejMT
     */
    public function setNumerWersji($numerWersji = null)
    {
        // validation for constraint: int
        if (!is_null($numerWersji) && !(is_int($numerWersji) || ctype_digit($numerWersji))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numerWersji, true), gettype($numerWersji)), __LINE__);
        }
        $this->numerWersji = $numerWersji;
        return $this;
    }
    /**
     * Get statusDokumentu value
     * @return string|null
     */
    public function getStatusDokumentu()
    {
        return $this->statusDokumentu;
    }
    /**
     * Set statusDokumentu value
     * @uses \EnumType\StatusDokumentuPlanuOpiekiMedycznejEnumMT::valueIsValid()
     * @uses \EnumType\StatusDokumentuPlanuOpiekiMedycznejEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statusDokumentu
     * @return \StructType\WynikWyszukiwaniaPlanowOpiekiMedycznejMT
     */
    public function setStatusDokumentu($statusDokumentu = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StatusDokumentuPlanuOpiekiMedycznejEnumMT::valueIsValid($statusDokumentu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\StatusDokumentuPlanuOpiekiMedycznejEnumMT', is_array($statusDokumentu) ? implode(', ', $statusDokumentu) : var_export($statusDokumentu, true), implode(', ', \EnumType\StatusDokumentuPlanuOpiekiMedycznejEnumMT::getValidValues())), __LINE__);
        }
        $this->statusDokumentu = $statusDokumentu;
        return $this;
    }
}
