<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Odczyt ServiceType
 * @subpackage Services
 */
class Odczyt extends AbstractSoapClientBase
{
    /**
     * Sets the KontekstWywolania SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\KontekstMT $kontekstWywolania
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderKontekstWywolania(\StructType\KontekstMT $kontekstWywolania, $nameSpace = 'http://csioz.gov.pl/p1/kontekst/mt/v20180509', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'kontekstWywolania', $kontekstWywolania, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named odczytPlanuOpiekiMedycznej
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20180509
     * - SOAPHeaderTypes: \StructType\KontekstMT
     * - SOAPHeaders: required
     * - documentation: Operacja odczytu dokumentu indywidualnego planu opieki medycznej.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OdczytPlanuOpiekiMedycznejRequest $odczytPlanuOpiekiMedycznejRequest
     * @return \StructType\OdczytPlanuOpiekiMedycznejResponse|bool
     */
    public function odczytPlanuOpiekiMedycznej(\StructType\OdczytPlanuOpiekiMedycznejRequest $odczytPlanuOpiekiMedycznejRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->odczytPlanuOpiekiMedycznej($odczytPlanuOpiekiMedycznejRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * odczytAktualnegoHarmonogramuPlanuOpiekiMedycznej
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20180509
     * - SOAPHeaderTypes: \StructType\KontekstMT
     * - SOAPHeaders: required
     * - documentation: Operacja odczytu aktualnego dokumentu harmonogramu indywidualnego planu opieki medycznej.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OdczytAktualnegoHarmonogramuPlanuOpiekiMedycznejRequest $odczytAktualnegoHarmonogramuPlanuOpiekiMedycznejRequest
     * @return \StructType\OdczytAktualnegoHarmonogramuPlanuOpiekiMedycznejResponse|bool
     */
    public function odczytAktualnegoHarmonogramuPlanuOpiekiMedycznej(\StructType\OdczytAktualnegoHarmonogramuPlanuOpiekiMedycznejRequest $odczytAktualnegoHarmonogramuPlanuOpiekiMedycznejRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->odczytAktualnegoHarmonogramuPlanuOpiekiMedycznej($odczytAktualnegoHarmonogramuPlanuOpiekiMedycznejRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * odczytWersjiHistorycznejPlanuOpiekiMedycznej
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20180509
     * - SOAPHeaderTypes: \StructType\KontekstMT
     * - SOAPHeaders: required
     * - documentation: Operacja odczytu wersji historycznej planu opieki medycznej.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OdczytWersjiHistorycznejPlanuOpiekiMedycznejRequest $odczytWersjiHistorycznejPlanuOpiekiMedycznejRequest
     * @return \StructType\OdczytWersjiHistorycznejPlanuOpiekiMedycznejResponse|bool
     */
    public function odczytWersjiHistorycznejPlanuOpiekiMedycznej(\StructType\OdczytWersjiHistorycznejPlanuOpiekiMedycznejRequest $odczytWersjiHistorycznejPlanuOpiekiMedycznejRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->odczytWersjiHistorycznejPlanuOpiekiMedycznej($odczytWersjiHistorycznejPlanuOpiekiMedycznejRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * odczytWersjiHistorycznejHarmonogramuPlanuOpiekiMedycznej
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20180509
     * - SOAPHeaderTypes: \StructType\KontekstMT
     * - SOAPHeaders: required
     * - documentation: Operacja odczytu wersji historycznej harmonogramu planu opieki medycznej.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\OdczytWersjiHistorycznejHarmonogramuPlanuOpiekiMedycznejRequest $odczytWersjiHistorycznejHarmonogramuPlanuOpiekiMedycznejRequest
     * @return \StructType\OdczytWersjiHistorycznejHarmonogramuPlanuOpiekiMedycznejResponse|bool
     */
    public function odczytWersjiHistorycznejHarmonogramuPlanuOpiekiMedycznej(\StructType\OdczytWersjiHistorycznejHarmonogramuPlanuOpiekiMedycznejRequest $odczytWersjiHistorycznejHarmonogramuPlanuOpiekiMedycznejRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->odczytWersjiHistorycznejHarmonogramuPlanuOpiekiMedycznej($odczytWersjiHistorycznejHarmonogramuPlanuOpiekiMedycznejRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\OdczytAktualnegoHarmonogramuPlanuOpiekiMedycznejResponse|\StructType\OdczytPlanuOpiekiMedycznejResponse|\StructType\OdczytWersjiHistorycznejHarmonogramuPlanuOpiekiMedycznejResponse|\StructType\OdczytWersjiHistorycznejPlanuOpiekiMedycznejResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
