<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Wyszukanie ServiceType
 */
$wyszukanie = new \ServiceType\Wyszukanie($options);
$wyszukanie->setSoapHeaderKontekstWywolania($kontekstWywolania);
/**
 * Sample call for wyszukaniePlanowOpiekiMedycznejWystawcy operation/method
 */
if ($wyszukanie->wyszukaniePlanowOpiekiMedycznejWystawcy(new \StructType\WyszukaniePlanowOpiekiMedycznejWystawcyRequest()) !== false) {
    print_r($wyszukanie->getResult());
} else {
    print_r($wyszukanie->getLastError());
}
/**
 * Sample call for wyszukaniePlanowOpiekiMedycznejUslugobiorcy operation/method
 */
if ($wyszukanie->wyszukaniePlanowOpiekiMedycznejUslugobiorcy(new \StructType\WyszukaniePlanowOpiekiMedycznejUslugobiorcyRequest()) !== false) {
    print_r($wyszukanie->getResult());
} else {
    print_r($wyszukanie->getLastError());
}
/**
 * Samples for Zapis ServiceType
 */
$zapis = new \ServiceType\Zapis($options);
$zapis->setSoapHeaderKontekstWywolania($kontekstWywolania);
/**
 * Sample call for zapisPlanuOpiekiMedycznej operation/method
 */
if ($zapis->zapisPlanuOpiekiMedycznej(new \StructType\ZapisPlanuOpiekiMedycznejRequest()) !== false) {
    print_r($zapis->getResult());
} else {
    print_r($zapis->getLastError());
}
/**
 * Sample call for zapisHarmonogramuPlanuOpiekiMedycznej operation/method
 */
if ($zapis->zapisHarmonogramuPlanuOpiekiMedycznej(new \StructType\ZapisHarmonogramuPlanuOpiekiMedycznejRequest()) !== false) {
    print_r($zapis->getResult());
} else {
    print_r($zapis->getLastError());
}
/**
 * Sample call for zapisAnulowaniaPlanuOpiekiMedycznej operation/method
 */
if ($zapis->zapisAnulowaniaPlanuOpiekiMedycznej(new \StructType\ZapisAnulowaniaPlanuOpiekiMedycznejRequest()) !== false) {
    print_r($zapis->getResult());
} else {
    print_r($zapis->getLastError());
}
/**
 * Sample call for zapisAnulowaniaHarmonogramuPlanuOpiekiMedycznej operation/method
 */
if ($zapis->zapisAnulowaniaHarmonogramuPlanuOpiekiMedycznej(new \StructType\ZapisAnulowaniaHarmonogramuPlanuOpiekiMedycznejRequest()) !== false) {
    print_r($zapis->getResult());
} else {
    print_r($zapis->getLastError());
}
/**
 * Samples for Odczyt ServiceType
 */
$odczyt = new \ServiceType\Odczyt($options);
$odczyt->setSoapHeaderKontekstWywolania($kontekstWywolania);
/**
 * Sample call for odczytPlanuOpiekiMedycznej operation/method
 */
if ($odczyt->odczytPlanuOpiekiMedycznej(new \StructType\OdczytPlanuOpiekiMedycznejRequest()) !== false) {
    print_r($odczyt->getResult());
} else {
    print_r($odczyt->getLastError());
}
/**
 * Sample call for odczytAktualnegoHarmonogramuPlanuOpiekiMedycznej
 * operation/method
 */
if ($odczyt->odczytAktualnegoHarmonogramuPlanuOpiekiMedycznej(new \StructType\OdczytAktualnegoHarmonogramuPlanuOpiekiMedycznejRequest()) !== false) {
    print_r($odczyt->getResult());
} else {
    print_r($odczyt->getLastError());
}
/**
 * Sample call for odczytWersjiHistorycznejPlanuOpiekiMedycznej operation/method
 */
if ($odczyt->odczytWersjiHistorycznejPlanuOpiekiMedycznej(new \StructType\OdczytWersjiHistorycznejPlanuOpiekiMedycznejRequest()) !== false) {
    print_r($odczyt->getResult());
} else {
    print_r($odczyt->getLastError());
}
/**
 * Sample call for odczytWersjiHistorycznejHarmonogramuPlanuOpiekiMedycznej
 * operation/method
 */
if ($odczyt->odczytWersjiHistorycznejHarmonogramuPlanuOpiekiMedycznej(new \StructType\OdczytWersjiHistorycznejHarmonogramuPlanuOpiekiMedycznejRequest()) !== false) {
    print_r($odczyt->getResult());
} else {
    print_r($odczyt->getLastError());
}
/**
 * Samples for Pobranie ServiceType
 */
$pobranie = new \ServiceType\Pobranie($options);
$pobranie->setSoapHeaderKontekstWywolania($kontekstWywolania);
/**
 * Sample call for pobranieListyWersjiHistorycznychPlanuOpiekiMedycznej
 * operation/method
 */
if ($pobranie->pobranieListyWersjiHistorycznychPlanuOpiekiMedycznej(new \StructType\PobranieListyWersjiHistorycznychPlanuOpiekiMedycznejRequest()) !== false) {
    print_r($pobranie->getResult());
} else {
    print_r($pobranie->getLastError());
}
/**
 * Sample call for pobranieListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznej
 * operation/method
 */
if ($pobranie->pobranieListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznej(new \StructType\PobranieListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznejRequest()) !== false) {
    print_r($pobranie->getResult());
} else {
    print_r($pobranie->getLastError());
}
