<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * WynikPobraniaListyWersjiHistorycznychPlanuOpiekiMedycznejMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Pojedynczy wynik pobrania listy wersji historycznych indywidualnych planów opieki medycznej.
 * @subpackage Structs
 */
class WynikPobraniaListyWersjiHistorycznychPlanuOpiekiMedycznejMT extends AbstractStructBase
{
    /**
     * The identyfikatorZbioruWersji
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator zbioru wersji dokumentu planu opieki medycznej.
     * @var \StructType\IdentyfikatorOIDMT
     */
    public $identyfikatorZbioruWersji;
    /**
     * The numerWersji
     * Meta information extracted from the WSDL
     * - documentation: Numer wersji dokumentu planu opieki medycznej.
     * @var int
     */
    public $numerWersji;
    /**
     * The identyfikatorAutora
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator OID autora dokumentu indywidualnego planu opieki medycznej.
     * @var \StructType\IdentyfikatorOIDMT
     */
    public $identyfikatorAutora;
    /**
     * The nazwaAutora
     * Meta information extracted from the WSDL
     * - documentation: Nazwa autora wyszukiwanego dokumentu.
     * @var string
     */
    public $nazwaAutora;
    /**
     * The identyfikatorPodmiotuAutora
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator OID podmiotu, w ramach którego wystawiono dokument indywidualnego planu opieki medycznej.
     * @var \StructType\IdentyfikatorOIDMT
     */
    public $identyfikatorPodmiotuAutora;
    /**
     * The dataWystawienia
     * Meta information extracted from the WSDL
     * - documentation: Data wystawienia dokumentu indywidualnego planu opieki medycznej.
     * @var string
     */
    public $dataWystawienia;
    /**
     * Constructor method for
     * WynikPobraniaListyWersjiHistorycznychPlanuOpiekiMedycznejMT
     * @uses WynikPobraniaListyWersjiHistorycznychPlanuOpiekiMedycznejMT::setIdentyfikatorZbioruWersji()
     * @uses WynikPobraniaListyWersjiHistorycznychPlanuOpiekiMedycznejMT::setNumerWersji()
     * @uses WynikPobraniaListyWersjiHistorycznychPlanuOpiekiMedycznejMT::setIdentyfikatorAutora()
     * @uses WynikPobraniaListyWersjiHistorycznychPlanuOpiekiMedycznejMT::setNazwaAutora()
     * @uses WynikPobraniaListyWersjiHistorycznychPlanuOpiekiMedycznejMT::setIdentyfikatorPodmiotuAutora()
     * @uses WynikPobraniaListyWersjiHistorycznychPlanuOpiekiMedycznejMT::setDataWystawienia()
     * @param \StructType\IdentyfikatorOIDMT $identyfikatorZbioruWersji
     * @param int $numerWersji
     * @param \StructType\IdentyfikatorOIDMT $identyfikatorAutora
     * @param string $nazwaAutora
     * @param \StructType\IdentyfikatorOIDMT $identyfikatorPodmiotuAutora
     * @param string $dataWystawienia
     */
    public function __construct(\StructType\IdentyfikatorOIDMT $identyfikatorZbioruWersji = null, $numerWersji = null, \StructType\IdentyfikatorOIDMT $identyfikatorAutora = null, $nazwaAutora = null, \StructType\IdentyfikatorOIDMT $identyfikatorPodmiotuAutora = null, $dataWystawienia = null)
    {
        $this
            ->setIdentyfikatorZbioruWersji($identyfikatorZbioruWersji)
            ->setNumerWersji($numerWersji)
            ->setIdentyfikatorAutora($identyfikatorAutora)
            ->setNazwaAutora($nazwaAutora)
            ->setIdentyfikatorPodmiotuAutora($identyfikatorPodmiotuAutora)
            ->setDataWystawienia($dataWystawienia);
    }
    /**
     * Get identyfikatorZbioruWersji value
     * @return \StructType\IdentyfikatorOIDMT|null
     */
    public function getIdentyfikatorZbioruWersji()
    {
        return $this->identyfikatorZbioruWersji;
    }
    /**
     * Set identyfikatorZbioruWersji value
     * @param \StructType\IdentyfikatorOIDMT $identyfikatorZbioruWersji
     * @return \StructType\WynikPobraniaListyWersjiHistorycznychPlanuOpiekiMedycznejMT
     */
    public function setIdentyfikatorZbioruWersji(\StructType\IdentyfikatorOIDMT $identyfikatorZbioruWersji = null)
    {
        $this->identyfikatorZbioruWersji = $identyfikatorZbioruWersji;
        return $this;
    }
    /**
     * Get numerWersji value
     * @return int|null
     */
    public function getNumerWersji()
    {
        return $this->numerWersji;
    }
    /**
     * Set numerWersji value
     * @param int $numerWersji
     * @return \StructType\WynikPobraniaListyWersjiHistorycznychPlanuOpiekiMedycznejMT
     */
    public function setNumerWersji($numerWersji = null)
    {
        // validation for constraint: int
        if (!is_null($numerWersji) && !(is_int($numerWersji) || ctype_digit($numerWersji))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numerWersji, true), gettype($numerWersji)), __LINE__);
        }
        $this->numerWersji = $numerWersji;
        return $this;
    }
    /**
     * Get identyfikatorAutora value
     * @return \StructType\IdentyfikatorOIDMT|null
     */
    public function getIdentyfikatorAutora()
    {
        return $this->identyfikatorAutora;
    }
    /**
     * Set identyfikatorAutora value
     * @param \StructType\IdentyfikatorOIDMT $identyfikatorAutora
     * @return \StructType\WynikPobraniaListyWersjiHistorycznychPlanuOpiekiMedycznejMT
     */
    public function setIdentyfikatorAutora(\StructType\IdentyfikatorOIDMT $identyfikatorAutora = null)
    {
        $this->identyfikatorAutora = $identyfikatorAutora;
        return $this;
    }
    /**
     * Get nazwaAutora value
     * @return string|null
     */
    public function getNazwaAutora()
    {
        return $this->nazwaAutora;
    }
    /**
     * Set nazwaAutora value
     * @param string $nazwaAutora
     * @return \StructType\WynikPobraniaListyWersjiHistorycznychPlanuOpiekiMedycznejMT
     */
    public function setNazwaAutora($nazwaAutora = null)
    {
        // validation for constraint: string
        if (!is_null($nazwaAutora) && !is_string($nazwaAutora)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nazwaAutora, true), gettype($nazwaAutora)), __LINE__);
        }
        $this->nazwaAutora = $nazwaAutora;
        return $this;
    }
    /**
     * Get identyfikatorPodmiotuAutora value
     * @return \StructType\IdentyfikatorOIDMT|null
     */
    public function getIdentyfikatorPodmiotuAutora()
    {
        return $this->identyfikatorPodmiotuAutora;
    }
    /**
     * Set identyfikatorPodmiotuAutora value
     * @param \StructType\IdentyfikatorOIDMT $identyfikatorPodmiotuAutora
     * @return \StructType\WynikPobraniaListyWersjiHistorycznychPlanuOpiekiMedycznejMT
     */
    public function setIdentyfikatorPodmiotuAutora(\StructType\IdentyfikatorOIDMT $identyfikatorPodmiotuAutora = null)
    {
        $this->identyfikatorPodmiotuAutora = $identyfikatorPodmiotuAutora;
        return $this;
    }
    /**
     * Get dataWystawienia value
     * @return string|null
     */
    public function getDataWystawienia()
    {
        return $this->dataWystawienia;
    }
    /**
     * Set dataWystawienia value
     * @param string $dataWystawienia
     * @return \StructType\WynikPobraniaListyWersjiHistorycznychPlanuOpiekiMedycznejMT
     */
    public function setDataWystawienia($dataWystawienia = null)
    {
        // validation for constraint: string
        if (!is_null($dataWystawienia) && !is_string($dataWystawienia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataWystawienia, true), gettype($dataWystawienia)), __LINE__);
        }
        $this->dataWystawienia = $dataWystawienia;
        return $this;
    }
}
