<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OdczytPlanuOpiekiMedycznejResponse StructType
 * Meta information extracted from the WSDL
 * - type: ns:OdczytPlanuOpiekiMedycznejResponse
 * @subpackage Structs
 */
class OdczytPlanuOpiekiMedycznejResponse extends AbstractStructBase
{
    /**
     * The wynik
     * Meta information extracted from the WSDL
     * - documentation: Wynik operacji odczytu dokumentu indywidualnego planu opieki medycznej.
     * @var \StructType\WynikMT
     */
    public $wynik;
    /**
     * The trescDokumentu
     * Meta information extracted from the WSDL
     * - documentation: Treść dokumentu indywidualnego planu opieki medycznej.
     * - minOccurs: 0
     * @var string
     */
    public $trescDokumentu;
    /**
     * The statusDokumentu
     * Meta information extracted from the WSDL
     * - documentation: Status dokumentu planu opieki medycznej.
     * - minOccurs: 0
     * @var string
     */
    public $statusDokumentu;
    /**
     * Constructor method for OdczytPlanuOpiekiMedycznejResponse
     * @uses OdczytPlanuOpiekiMedycznejResponse::setWynik()
     * @uses OdczytPlanuOpiekiMedycznejResponse::setTrescDokumentu()
     * @uses OdczytPlanuOpiekiMedycznejResponse::setStatusDokumentu()
     * @param \StructType\WynikMT $wynik
     * @param string $trescDokumentu
     * @param string $statusDokumentu
     */
    public function __construct(\StructType\WynikMT $wynik = null, $trescDokumentu = null, $statusDokumentu = null)
    {
        $this
            ->setWynik($wynik)
            ->setTrescDokumentu($trescDokumentu)
            ->setStatusDokumentu($statusDokumentu);
    }
    /**
     * Get wynik value
     * @return \StructType\WynikMT|null
     */
    public function getWynik()
    {
        return $this->wynik;
    }
    /**
     * Set wynik value
     * @param \StructType\WynikMT $wynik
     * @return \StructType\OdczytPlanuOpiekiMedycznejResponse
     */
    public function setWynik(\StructType\WynikMT $wynik = null)
    {
        $this->wynik = $wynik;
        return $this;
    }
    /**
     * Get trescDokumentu value
     * @return string|null
     */
    public function getTrescDokumentu()
    {
        return $this->trescDokumentu;
    }
    /**
     * Set trescDokumentu value
     * @param string $trescDokumentu
     * @return \StructType\OdczytPlanuOpiekiMedycznejResponse
     */
    public function setTrescDokumentu($trescDokumentu = null)
    {
        // validation for constraint: string
        if (!is_null($trescDokumentu) && !is_string($trescDokumentu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trescDokumentu, true), gettype($trescDokumentu)), __LINE__);
        }
        $this->trescDokumentu = $trescDokumentu;
        return $this;
    }
    /**
     * Get statusDokumentu value
     * @return string|null
     */
    public function getStatusDokumentu()
    {
        return $this->statusDokumentu;
    }
    /**
     * Set statusDokumentu value
     * @uses \EnumType\StatusDokumentuPlanuOpiekiMedycznejEnumMT::valueIsValid()
     * @uses \EnumType\StatusDokumentuPlanuOpiekiMedycznejEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $statusDokumentu
     * @return \StructType\OdczytPlanuOpiekiMedycznejResponse
     */
    public function setStatusDokumentu($statusDokumentu = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StatusDokumentuPlanuOpiekiMedycznejEnumMT::valueIsValid($statusDokumentu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\StatusDokumentuPlanuOpiekiMedycznejEnumMT', is_array($statusDokumentu) ? implode(', ', $statusDokumentu) : var_export($statusDokumentu, true), implode(', ', \EnumType\StatusDokumentuPlanuOpiekiMedycznejEnumMT::getValidValues())), __LINE__);
        }
        $this->statusDokumentu = $statusDokumentu;
        return $this;
    }
}
