<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WlasciwosciWyszukiwaniaMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Dodatkowe parametry wyszukiwania.
 * @subpackage Structs
 */
class WlasciwosciWyszukiwaniaMT extends AbstractStructBase
{
    /**
     * The numerStrony
     * Meta information extracted from the WSDL
     * - documentation: Określa numer pobieranej strony. Numeracja stron od 0.
     * @var int
     */
    public $numerStrony;
    /**
     * The liczbaWynikowNaStronie
     * Meta information extracted from the WSDL
     * - documentation: Określa liczbę rekordów dla pełnej porcji danych. Maksymalna wartość będzie ograniczona parametrem systemowym.
     * - base: xs:unsignedShort
     * - minInclusive: 1
     * - minOccurs: 0
     * @var int
     */
    public $liczbaWynikowNaStronie;
    /**
     * The kierunekSortowania
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $kierunekSortowania;
    /**
     * The poleSortowania
     * Meta information extracted from the WSDL
     * - documentation: Definiuje pole na podstawie którego ma się odbyć sortowanie wyników wyszukiwania.
     * - minOccurs: 0
     * @var string
     */
    public $poleSortowania;
    /**
     * Constructor method for WlasciwosciWyszukiwaniaMT
     * @uses WlasciwosciWyszukiwaniaMT::setNumerStrony()
     * @uses WlasciwosciWyszukiwaniaMT::setLiczbaWynikowNaStronie()
     * @uses WlasciwosciWyszukiwaniaMT::setKierunekSortowania()
     * @uses WlasciwosciWyszukiwaniaMT::setPoleSortowania()
     * @param int $numerStrony
     * @param int $liczbaWynikowNaStronie
     * @param string $kierunekSortowania
     * @param string $poleSortowania
     */
    public function __construct($numerStrony = null, $liczbaWynikowNaStronie = null, $kierunekSortowania = null, $poleSortowania = null)
    {
        $this
            ->setNumerStrony($numerStrony)
            ->setLiczbaWynikowNaStronie($liczbaWynikowNaStronie)
            ->setKierunekSortowania($kierunekSortowania)
            ->setPoleSortowania($poleSortowania);
    }
    /**
     * Get numerStrony value
     * @return int|null
     */
    public function getNumerStrony()
    {
        return $this->numerStrony;
    }
    /**
     * Set numerStrony value
     * @param int $numerStrony
     * @return \StructType\WlasciwosciWyszukiwaniaMT
     */
    public function setNumerStrony($numerStrony = null)
    {
        // validation for constraint: int
        if (!is_null($numerStrony) && !(is_int($numerStrony) || ctype_digit($numerStrony))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numerStrony, true), gettype($numerStrony)), __LINE__);
        }
        $this->numerStrony = $numerStrony;
        return $this;
    }
    /**
     * Get liczbaWynikowNaStronie value
     * @return int|null
     */
    public function getLiczbaWynikowNaStronie()
    {
        return $this->liczbaWynikowNaStronie;
    }
    /**
     * Set liczbaWynikowNaStronie value
     * @param int $liczbaWynikowNaStronie
     * @return \StructType\WlasciwosciWyszukiwaniaMT
     */
    public function setLiczbaWynikowNaStronie($liczbaWynikowNaStronie = null)
    {
        // validation for constraint: int
        if (!is_null($liczbaWynikowNaStronie) && !(is_int($liczbaWynikowNaStronie) || ctype_digit($liczbaWynikowNaStronie))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($liczbaWynikowNaStronie, true), gettype($liczbaWynikowNaStronie)), __LINE__);
        }
        // validation for constraint: minInclusive(1)
        if (!is_null($liczbaWynikowNaStronie) && $liczbaWynikowNaStronie < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 1', var_export($liczbaWynikowNaStronie, true)), __LINE__);
        }
        $this->liczbaWynikowNaStronie = $liczbaWynikowNaStronie;
        return $this;
    }
    /**
     * Get kierunekSortowania value
     * @return string|null
     */
    public function getKierunekSortowania()
    {
        return $this->kierunekSortowania;
    }
    /**
     * Set kierunekSortowania value
     * @uses \EnumType\KierunekSortowaniaEnumMT::valueIsValid()
     * @uses \EnumType\KierunekSortowaniaEnumMT::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $kierunekSortowania
     * @return \StructType\WlasciwosciWyszukiwaniaMT
     */
    public function setKierunekSortowania($kierunekSortowania = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\KierunekSortowaniaEnumMT::valueIsValid($kierunekSortowania)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\KierunekSortowaniaEnumMT', is_array($kierunekSortowania) ? implode(', ', $kierunekSortowania) : var_export($kierunekSortowania, true), implode(', ', \EnumType\KierunekSortowaniaEnumMT::getValidValues())), __LINE__);
        }
        $this->kierunekSortowania = $kierunekSortowania;
        return $this;
    }
    /**
     * Get poleSortowania value
     * @return string|null
     */
    public function getPoleSortowania()
    {
        return $this->poleSortowania;
    }
    /**
     * Set poleSortowania value
     * @param string $poleSortowania
     * @return \StructType\WlasciwosciWyszukiwaniaMT
     */
    public function setPoleSortowania($poleSortowania = null)
    {
        // validation for constraint: string
        if (!is_null($poleSortowania) && !is_string($poleSortowania)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poleSortowania, true), gettype($poleSortowania)), __LINE__);
        }
        $this->poleSortowania = $poleSortowania;
        return $this;
    }
}
