<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Zapis ServiceType
 * @subpackage Services
 */
class Zapis extends AbstractSoapClientBase
{
    /**
     * Sets the KontekstWywolania SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\KontekstMT $kontekstWywolania
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderKontekstWywolania(\StructType\KontekstMT $kontekstWywolania, $nameSpace = 'http://csioz.gov.pl/p1/kontekst/mt/v20180509', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'kontekstWywolania', $kontekstWywolania, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named zapisPlanuOpiekiMedycznej
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20180509
     * - SOAPHeaderTypes: \StructType\KontekstMT
     * - SOAPHeaders: required
     * - documentation: Operacja zapisu dokumentu indywidualnego planu opieki medycznej.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ZapisPlanuOpiekiMedycznejRequest $zapisPlanuOpiekiMedycznejRequest
     * @return \StructType\ZapisPlanuOpiekiMedycznejResponse|bool
     */
    public function zapisPlanuOpiekiMedycznej(\StructType\ZapisPlanuOpiekiMedycznejRequest $zapisPlanuOpiekiMedycznejRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->zapisPlanuOpiekiMedycznej($zapisPlanuOpiekiMedycznejRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * zapisHarmonogramuPlanuOpiekiMedycznej
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20180509
     * - SOAPHeaderTypes: \StructType\KontekstMT
     * - SOAPHeaders: required
     * - documentation: Operacja zapisu aktualnego dokumentu harmonogramu planu opieki medycznej.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ZapisHarmonogramuPlanuOpiekiMedycznejRequest $zapisHarmonogramuPlanuOpiekiMedycznejRequest
     * @return \StructType\ZapisHarmonogramuPlanuOpiekiMedycznejResponse|bool
     */
    public function zapisHarmonogramuPlanuOpiekiMedycznej(\StructType\ZapisHarmonogramuPlanuOpiekiMedycznejRequest $zapisHarmonogramuPlanuOpiekiMedycznejRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->zapisHarmonogramuPlanuOpiekiMedycznej($zapisHarmonogramuPlanuOpiekiMedycznejRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * zapisAnulowaniaPlanuOpiekiMedycznej
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20180509
     * - SOAPHeaderTypes: \StructType\KontekstMT
     * - SOAPHeaders: required
     * - documentation: Operacja zapisu dokumentu anulowania planu opieki medycznej.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ZapisAnulowaniaPlanuOpiekiMedycznejRequest $zapisAnulowaniaPlanuOpiekiMedycznejRequest
     * @return \StructType\ZapisAnulowaniaPlanuOpiekiMedycznejResponse|bool
     */
    public function zapisAnulowaniaPlanuOpiekiMedycznej(\StructType\ZapisAnulowaniaPlanuOpiekiMedycznejRequest $zapisAnulowaniaPlanuOpiekiMedycznejRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->zapisAnulowaniaPlanuOpiekiMedycznej($zapisAnulowaniaPlanuOpiekiMedycznejRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * zapisAnulowaniaHarmonogramuPlanuOpiekiMedycznej
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20180509
     * - SOAPHeaderTypes: \StructType\KontekstMT
     * - SOAPHeaders: required
     * - documentation: Operacja zapisu dokumentu anulowania harmonogramu planu opieki medycznej.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ZapisAnulowaniaHarmonogramuPlanuOpiekiMedycznejRequest $zapisAnulowaniaHarmonogramuPlanuOpiekiMedycznejRequest
     * @return \StructType\ZapisAnulowaniaHarmonogramuPlanuOpiekiMedycznejResponse|bool
     */
    public function zapisAnulowaniaHarmonogramuPlanuOpiekiMedycznej(\StructType\ZapisAnulowaniaHarmonogramuPlanuOpiekiMedycznejRequest $zapisAnulowaniaHarmonogramuPlanuOpiekiMedycznejRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->zapisAnulowaniaHarmonogramuPlanuOpiekiMedycznej($zapisAnulowaniaHarmonogramuPlanuOpiekiMedycznejRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ZapisAnulowaniaHarmonogramuPlanuOpiekiMedycznejResponse|\StructType\ZapisAnulowaniaPlanuOpiekiMedycznejResponse|\StructType\ZapisHarmonogramuPlanuOpiekiMedycznejResponse|\StructType\ZapisPlanuOpiekiMedycznejResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
