<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Pobranie ServiceType
 * @subpackage Services
 */
class Pobranie extends AbstractSoapClientBase
{
    /**
     * Sets the KontekstWywolania SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\KontekstMT $kontekstWywolania
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderKontekstWywolania(\StructType\KontekstMT $kontekstWywolania, $nameSpace = 'http://csioz.gov.pl/p1/kontekst/mt/v20180509', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'kontekstWywolania', $kontekstWywolania, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named
     * pobranieListyWersjiHistorycznychPlanuOpiekiMedycznej
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20180509
     * - SOAPHeaderTypes: \StructType\KontekstMT
     * - SOAPHeaders: required
     * - documentation: Operacja pobrania listy wersji historycznych planu opieki medycznej.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PobranieListyWersjiHistorycznychPlanuOpiekiMedycznejRequest $pobranieListyWersjiHistorycznychPlanuOpiekiMedycznejRequest
     * @return \StructType\PobranieListyWersjiHistorycznychPlanuOpiekiMedycznejResponse|bool
     */
    public function pobranieListyWersjiHistorycznychPlanuOpiekiMedycznej(\StructType\PobranieListyWersjiHistorycznychPlanuOpiekiMedycznejRequest $pobranieListyWersjiHistorycznychPlanuOpiekiMedycznejRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->pobranieListyWersjiHistorycznychPlanuOpiekiMedycznej($pobranieListyWersjiHistorycznychPlanuOpiekiMedycznejRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * pobranieListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznej
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: kontekstWywolania
     * - SOAPHeaderNamespaces: http://csioz.gov.pl/p1/kontekst/mt/v20180509
     * - SOAPHeaderTypes: \StructType\KontekstMT
     * - SOAPHeaders: required
     * - documentation: Operacja pobrania listy wersji historycznych harmonogramu planu opieki medycznej.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PobranieListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznejRequest $pobranieListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznejRequest
     * @return \StructType\PobranieListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznejResponse|bool
     */
    public function pobranieListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznej(\StructType\PobranieListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznejRequest $pobranieListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznejRequest)
    {
        try {
            $this->setResult($this->getSoapClient()->pobranieListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznej($pobranieListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznejRequest));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PobranieListyWersjiHistorycznychHarmonogramuPlanuOpiekiMedycznejResponse|\StructType\PobranieListyWersjiHistorycznychPlanuOpiekiMedycznejResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
