<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://app.cobmais.com.br/services/webservice.svc?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://app.cobmais.com.br/services/webservice.svc?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Envia ServiceType
 */
$envia = new \ServiceType\Envia($options);
/**
 * Sample call for EnviaBoletoCobChat operation/method
 */
if ($envia->EnviaBoletoCobChat(new \StructType\EnviaBoletoCobChat()) !== false) {
    print_r($envia->getResult());
} else {
    print_r($envia->getLastError());
}
/**
 * Sample call for EnviaCheckoutUra operation/method
 */
if ($envia->EnviaCheckoutUra(new \StructType\EnviaCheckoutUra()) !== false) {
    print_r($envia->getResult());
} else {
    print_r($envia->getLastError());
}
/**
 * Sample call for EnviaBoletoUra operation/method
 */
if ($envia->EnviaBoletoUra(new \StructType\EnviaBoletoUra()) !== false) {
    print_r($envia->getResult());
} else {
    print_r($envia->getLastError());
}
/**
 * Sample call for EnviaBoletoTermoUra operation/method
 */
if ($envia->EnviaBoletoTermoUra(new \StructType\EnviaBoletoTermoUra()) !== false) {
    print_r($envia->getResult());
} else {
    print_r($envia->getLastError());
}
/**
 * Sample call for EnviaCodigoAcessoCobchat operation/method
 */
if ($envia->EnviaCodigoAcessoCobchat(new \StructType\EnviaCodigoAcessoCobchat()) !== false) {
    print_r($envia->getResult());
} else {
    print_r($envia->getLastError());
}
/**
 * Sample call for EnviaCheckoutCobChat operation/method
 */
if ($envia->EnviaCheckoutCobChat(new \StructType\EnviaCheckoutCobChat()) !== false) {
    print_r($envia->getResult());
} else {
    print_r($envia->getLastError());
}
/**
 * Sample call for EnviaPixCobChat operation/method
 */
if ($envia->EnviaPixCobChat(new \StructType\EnviaPixCobChat()) !== false) {
    print_r($envia->getResult());
} else {
    print_r($envia->getLastError());
}
/**
 * Sample call for EnviaBoleto operation/method
 */
if ($envia->EnviaBoleto(new \StructType\EnviaBoleto()) !== false) {
    print_r($envia->getResult());
} else {
    print_r($envia->getLastError());
}
/**
 * Sample call for EnviaCodigoViaSMS operation/method
 */
if ($envia->EnviaCodigoViaSMS(new \StructType\EnviaCodigoViaSMS()) !== false) {
    print_r($envia->getResult());
} else {
    print_r($envia->getLastError());
}
/**
 * Sample call for EnviaCodigoViaEmail operation/method
 */
if ($envia->EnviaCodigoViaEmail(new \StructType\EnviaCodigoViaEmail()) !== false) {
    print_r($envia->getResult());
} else {
    print_r($envia->getLastError());
}
/**
 * Samples for Gerar ServiceType
 */
$gerar = new \ServiceType\Gerar($options);
/**
 * Sample call for GerarAcordoCobChat operation/method
 */
if ($gerar->GerarAcordoCobChat(new \StructType\GerarAcordoCobChat()) !== false) {
    print_r($gerar->getResult());
} else {
    print_r($gerar->getLastError());
}
/**
 * Sample call for GerarAcordoUra operation/method
 */
if ($gerar->GerarAcordoUra(new \StructType\GerarAcordoUra()) !== false) {
    print_r($gerar->getResult());
} else {
    print_r($gerar->getLastError());
}
/**
 * Sample call for GerarAcordoPortal operation/method
 */
if ($gerar->GerarAcordoPortal(new \StructType\GerarAcordoPortal()) !== false) {
    print_r($gerar->getResult());
} else {
    print_r($gerar->getLastError());
}
/**
 * Samples for Consultar ServiceType
 */
$consultar = new \ServiceType\Consultar($options);
/**
 * Sample call for ConsultarContratosSemNumeroPasta operation/method
 */
if ($consultar->ConsultarContratosSemNumeroPasta(new \StructType\ConsultarContratosSemNumeroPasta()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarClientePorCPFCNPJUra operation/method
 */
if ($consultar->ConsultarClientePorCPFCNPJUra(new \StructType\ConsultarClientePorCPFCNPJUra()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarCredoresDoClienteUra operation/method
 */
if ($consultar->ConsultarCredoresDoClienteUra(new \StructType\ConsultarCredoresDoClienteUra()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarContratoClienteUra operation/method
 */
if ($consultar->ConsultarContratoClienteUra(new \StructType\ConsultarContratoClienteUra()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarFormaPagamentoUra operation/method
 */
if ($consultar->ConsultarFormaPagamentoUra(new \StructType\ConsultarFormaPagamentoUra()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarDadosClienteCobChat operation/method
 */
if ($consultar->ConsultarDadosClienteCobChat(new \StructType\ConsultarDadosClienteCobChat()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarAssessoriaPorURL operation/method
 */
if ($consultar->ConsultarAssessoriaPorURL(new \StructType\ConsultarAssessoriaPorURL()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarDadosPix operation/method
 */
if ($consultar->ConsultarDadosPix(new \StructType\ConsultarDadosPix()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarAssessoriaPorURLCheckout operation/method
 */
if ($consultar->ConsultarAssessoriaPorURLCheckout(new \StructType\ConsultarAssessoriaPorURLCheckout()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarAssessoriaPorAcordo operation/method
 */
if ($consultar->ConsultarAssessoriaPorAcordo(new \StructType\ConsultarAssessoriaPorAcordo()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarAssessoriaPorPixCheckout operation/method
 */
if ($consultar->ConsultarAssessoriaPorPixCheckout(new \StructType\ConsultarAssessoriaPorPixCheckout()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarPortalIntegracao operation/method
 */
if ($consultar->ConsultarPortalIntegracao(new \StructType\ConsultarPortalIntegracao()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarPortalParametro operation/method
 */
if ($consultar->ConsultarPortalParametro(new \StructType\ConsultarPortalParametro()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarCredoresDoCliente operation/method
 */
if ($consultar->ConsultarCredoresDoCliente(new \StructType\ConsultarCredoresDoCliente()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarContratoCliente operation/method
 */
if ($consultar->ConsultarContratoCliente(new \StructType\ConsultarContratoCliente()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarContratoCampoPortal operation/method
 */
if ($consultar->ConsultarContratoCampoPortal(new \StructType\ConsultarContratoCampoPortal()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarAcordosEmAndamentoPorCliente operation/method
 */
if ($consultar->ConsultarAcordosEmAndamentoPorCliente(new \StructType\ConsultarAcordosEmAndamentoPorCliente()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarAcordosEmAndamentoPorClientePortal operation/method
 */
if ($consultar->ConsultarAcordosEmAndamentoPorClientePortal(new \StructType\ConsultarAcordosEmAndamentoPorClientePortal()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarAcordosFinalizadosPorCliente operation/method
 */
if ($consultar->ConsultarAcordosFinalizadosPorCliente(new \StructType\ConsultarAcordosFinalizadosPorCliente()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarAcordosFinalizadosPorClientePortal operation/method
 */
if ($consultar->ConsultarAcordosFinalizadosPorClientePortal(new \StructType\ConsultarAcordosFinalizadosPorClientePortal()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarAcordosEmAndamentoPorCPFCNPJ operation/method
 */
if ($consultar->ConsultarAcordosEmAndamentoPorCPFCNPJ(new \StructType\ConsultarAcordosEmAndamentoPorCPFCNPJ()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarAcordosFinalizadosPorCPFCNPJ operation/method
 */
if ($consultar->ConsultarAcordosFinalizadosPorCPFCNPJ(new \StructType\ConsultarAcordosFinalizadosPorCPFCNPJ()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarTodosAcordosPorClientePortal operation/method
 */
if ($consultar->ConsultarTodosAcordosPorClientePortal(new \StructType\ConsultarTodosAcordosPorClientePortal()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarClientePortalPorCPFCNPJ operation/method
 */
if ($consultar->ConsultarClientePortalPorCPFCNPJ(new \StructType\ConsultarClientePortalPorCPFCNPJ()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarClientePorCPFCNPJ operation/method
 */
if ($consultar->ConsultarClientePorCPFCNPJ(new \StructType\ConsultarClientePorCPFCNPJ()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarClientePorTelefone operation/method
 */
if ($consultar->ConsultarClientePorTelefone(new \StructType\ConsultarClientePorTelefone()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarClienteDiscador operation/method
 */
if ($consultar->ConsultarClienteDiscador(new \StructType\ConsultarClienteDiscador()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarCliente operation/method
 */
if ($consultar->ConsultarCliente(new \StructType\ConsultarCliente()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarClientes operation/method
 */
if ($consultar->ConsultarClientes(new \StructType\ConsultarClientes()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarContratos operation/method
 */
if ($consultar->ConsultarContratos(new \StructType\ConsultarContratos()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarAcordos operation/method
 */
if ($consultar->ConsultarAcordos(new \StructType\ConsultarAcordos()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarAcordosPorDataAlteracao operation/method
 */
if ($consultar->ConsultarAcordosPorDataAlteracao(new \StructType\ConsultarAcordosPorDataAlteracao()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarEventos operation/method
 */
if ($consultar->ConsultarEventos(new \StructType\ConsultarEventos()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarPagamentos operation/method
 */
if ($consultar->ConsultarPagamentos(new \StructType\ConsultarPagamentos()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarPagamentosOperador operation/method
 */
if ($consultar->ConsultarPagamentosOperador(new \StructType\ConsultarPagamentosOperador()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarPagamentosRenegociacao operation/method
 */
if ($consultar->ConsultarPagamentosRenegociacao(new \StructType\ConsultarPagamentosRenegociacao()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarBoletos operation/method
 */
if ($consultar->ConsultarBoletos(new \StructType\ConsultarBoletos()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarQuebraAcordos operation/method
 */
if ($consultar->ConsultarQuebraAcordos(new \StructType\ConsultarQuebraAcordos()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarNossoNumero operation/method
 */
if ($consultar->ConsultarNossoNumero(new \StructType\ConsultarNossoNumero()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarAtualizacaoCadastral operation/method
 */
if ($consultar->ConsultarAtualizacaoCadastral(new \StructType\ConsultarAtualizacaoCadastral()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarIntegracaoGateway operation/method
 */
if ($consultar->ConsultarIntegracaoGateway(new \StructType\ConsultarIntegracaoGateway()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarFormaPagamentoCobChat operation/method
 */
if ($consultar->ConsultarFormaPagamentoCobChat(new \StructType\ConsultarFormaPagamentoCobChat()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarFiliaisKrotonPortal operation/method
 */
if ($consultar->ConsultarFiliaisKrotonPortal(new \StructType\ConsultarFiliaisKrotonPortal()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarFilialKrotonDoContratoPortal operation/method
 */
if ($consultar->ConsultarFilialKrotonDoContratoPortal(new \StructType\ConsultarFilialKrotonDoContratoPortal()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarIntegracaoCobChat operation/method
 */
if ($consultar->ConsultarIntegracaoCobChat(new \StructType\ConsultarIntegracaoCobChat()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarTodosAcordosPorClienteCobChat operation/method
 */
if ($consultar->ConsultarTodosAcordosPorClienteCobChat(new \StructType\ConsultarTodosAcordosPorClienteCobChat()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarAcordosEmAndamentoPorClienteCobChat operation/method
 */
if ($consultar->ConsultarAcordosEmAndamentoPorClienteCobChat(new \StructType\ConsultarAcordosEmAndamentoPorClienteCobChat()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarContratoClienteCobChat operation/method
 */
if ($consultar->ConsultarContratoClienteCobChat(new \StructType\ConsultarContratoClienteCobChat()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarCredoresDoClienteCobChat operation/method
 */
if ($consultar->ConsultarCredoresDoClienteCobChat(new \StructType\ConsultarCredoresDoClienteCobChat()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Sample call for ConsultarClientePorCPFCNPJCobChat operation/method
 */
if ($consultar->ConsultarClientePorCPFCNPJCobChat(new \StructType\ConsultarClientePorCPFCNPJCobChat()) !== false) {
    print_r($consultar->getResult());
} else {
    print_r($consultar->getLastError());
}
/**
 * Samples for Quebrar ServiceType
 */
$quebrar = new \ServiceType\Quebrar($options);
/**
 * Sample call for QuebrarAcordoCobChat operation/method
 */
if ($quebrar->QuebrarAcordoCobChat(new \StructType\QuebrarAcordoCobChat()) !== false) {
    print_r($quebrar->getResult());
} else {
    print_r($quebrar->getLastError());
}
/**
 * Sample call for QuebrarAcordo operation/method
 */
if ($quebrar->QuebrarAcordo(new \StructType\QuebrarAcordo()) !== false) {
    print_r($quebrar->getResult());
} else {
    print_r($quebrar->getLastError());
}
/**
 * Samples for Calculo ServiceType
 */
$calculo = new \ServiceType\Calculo($options);
/**
 * Sample call for CalculoUra operation/method
 */
if ($calculo->CalculoUra(new \StructType\CalculoUra()) !== false) {
    print_r($calculo->getResult());
} else {
    print_r($calculo->getLastError());
}
/**
 * Sample call for CalculoPortal operation/method
 */
if ($calculo->CalculoPortal(new \StructType\CalculoPortal()) !== false) {
    print_r($calculo->getResult());
} else {
    print_r($calculo->getLastError());
}
/**
 * Sample call for CalculoCobChat operation/method
 */
if ($calculo->CalculoCobChat(new \StructType\CalculoCobChat()) !== false) {
    print_r($calculo->getResult());
} else {
    print_r($calculo->getLastError());
}
/**
 * Samples for Imprime ServiceType
 */
$imprime = new \ServiceType\Imprime($options);
/**
 * Sample call for ImprimeTermoAcordoKrotonUra operation/method
 */
if ($imprime->ImprimeTermoAcordoKrotonUra(new \StructType\ImprimeTermoAcordoKrotonUra()) !== false) {
    print_r($imprime->getResult());
} else {
    print_r($imprime->getLastError());
}
/**
 * Sample call for ImprimeTermoAcordo operation/method
 */
if ($imprime->ImprimeTermoAcordo(new \StructType\ImprimeTermoAcordo()) !== false) {
    print_r($imprime->getResult());
} else {
    print_r($imprime->getLastError());
}
/**
 * Sample call for ImprimeTermoAcordoKrotonPortal operation/method
 */
if ($imprime->ImprimeTermoAcordoKrotonPortal(new \StructType\ImprimeTermoAcordoKrotonPortal()) !== false) {
    print_r($imprime->getResult());
} else {
    print_r($imprime->getLastError());
}
/**
 * Sample call for ImprimeCertificadoDeAceiteKrotonPortal operation/method
 */
if ($imprime->ImprimeCertificadoDeAceiteKrotonPortal(new \StructType\ImprimeCertificadoDeAceiteKrotonPortal()) !== false) {
    print_r($imprime->getResult());
} else {
    print_r($imprime->getLastError());
}
/**
 * Samples for Emitir ServiceType
 */
$emitir = new \ServiceType\Emitir($options);
/**
 * Sample call for EmitirBoletoUra operation/method
 */
if ($emitir->EmitirBoletoUra(new \StructType\EmitirBoletoUra()) !== false) {
    print_r($emitir->getResult());
} else {
    print_r($emitir->getLastError());
}
/**
 * Sample call for EmitirBoleto operation/method
 */
if ($emitir->EmitirBoleto(new \StructType\EmitirBoleto()) !== false) {
    print_r($emitir->getResult());
} else {
    print_r($emitir->getLastError());
}
/**
 * Sample call for EmitirBoletoCobChat operation/method
 */
if ($emitir->EmitirBoletoCobChat(new \StructType\EmitirBoletoCobChat()) !== false) {
    print_r($emitir->getResult());
} else {
    print_r($emitir->getLastError());
}
/**
 * Sample call for EmitirBoletoPortal operation/method
 */
if ($emitir->EmitirBoletoPortal(new \StructType\EmitirBoletoPortal()) !== false) {
    print_r($emitir->getResult());
} else {
    print_r($emitir->getLastError());
}
/**
 * Sample call for EmitirBoletoPortalV2 operation/method
 */
if ($emitir->EmitirBoletoPortalV2(new \StructType\EmitirBoletoPortalV2()) !== false) {
    print_r($emitir->getResult());
} else {
    print_r($emitir->getLastError());
}
/**
 * Sample call for EmitirBoletoApi operation/method
 */
if ($emitir->EmitirBoletoApi(new \StructType\EmitirBoletoApi()) !== false) {
    print_r($emitir->getResult());
} else {
    print_r($emitir->getLastError());
}
/**
 * Sample call for EmitirBoleto2ViaApi operation/method
 */
if ($emitir->EmitirBoleto2ViaApi(new \StructType\EmitirBoleto2ViaApi()) !== false) {
    print_r($emitir->getResult());
} else {
    print_r($emitir->getLastError());
}
/**
 * Samples for Health ServiceType
 */
$health = new \ServiceType\Health($options);
/**
 * Sample call for HealthCheckRoute operation/method
 */
if ($health->HealthCheckRoute(new \StructType\HealthCheckRoute()) !== false) {
    print_r($health->getResult());
} else {
    print_r($health->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetToken operation/method
 */
if ($get->GetToken(new \StructType\GetToken()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCartaoParametrosIntegracao operation/method
 */
if ($get->GetCartaoParametrosIntegracao(new \StructType\GetCartaoParametrosIntegracao()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCartaoParametrosIntegracaoPorId operation/method
 */
if ($get->GetCartaoParametrosIntegracaoPorId(new \StructType\GetCartaoParametrosIntegracaoPorId()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetConfigCredor operation/method
 */
if ($get->GetConfigCredor(new \StructType\GetConfigCredor()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Consulta ServiceType
 */
$consulta = new \ServiceType\Consulta($options);
/**
 * Sample call for ConsultaDadosCheckout operation/method
 */
if ($consulta->ConsultaDadosCheckout(new \StructType\ConsultaDadosCheckout()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaURLCheckout operation/method
 */
if ($consulta->ConsultaURLCheckout(new \StructType\ConsultaURLCheckout()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaURLCheckoutCobChat operation/method
 */
if ($consulta->ConsultaURLCheckoutCobChat(new \StructType\ConsultaURLCheckoutCobChat()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaPixCobChat operation/method
 */
if ($consulta->ConsultaPixCobChat(new \StructType\ConsultaPixCobChat()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaParcelasAbertas30dias operation/method
 */
if ($consulta->ConsultaParcelasAbertas30dias(new \StructType\ConsultaParcelasAbertas30dias()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaParcelasAbertasPortal operation/method
 */
if ($consulta->ConsultaParcelasAbertasPortal(new \StructType\ConsultaParcelasAbertasPortal()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaContratosMarcador operation/method
 */
if ($consulta->ConsultaContratosMarcador(new \StructType\ConsultaContratosMarcador()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaBoletosOriginais operation/method
 */
if ($consulta->ConsultaBoletosOriginais(new \StructType\ConsultaBoletosOriginais()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Sample call for ConsultaParcelasAbertasCobChat operation/method
 */
if ($consulta->ConsultaParcelasAbertasCobChat(new \StructType\ConsultaParcelasAbertasCobChat()) !== false) {
    print_r($consulta->getResult());
} else {
    print_r($consulta->getLastError());
}
/**
 * Samples for Incluir ServiceType
 */
$incluir = new \ServiceType\Incluir($options);
/**
 * Sample call for IncluirConversa operation/method
 */
if ($incluir->IncluirConversa(new \StructType\IncluirConversa()) !== false) {
    print_r($incluir->getResult());
} else {
    print_r($incluir->getLastError());
}
/**
 * Sample call for IncluirEventoChekout operation/method
 */
if ($incluir->IncluirEventoChekout(new \StructType\IncluirEventoChekout()) !== false) {
    print_r($incluir->getResult());
} else {
    print_r($incluir->getLastError());
}
/**
 * Sample call for IncluirBoletos operation/method
 */
if ($incluir->IncluirBoletos(new \StructType\IncluirBoletos()) !== false) {
    print_r($incluir->getResult());
} else {
    print_r($incluir->getLastError());
}
/**
 * Sample call for IncluirSPC operation/method
 */
if ($incluir->IncluirSPC(new \StructType\IncluirSPC()) !== false) {
    print_r($incluir->getResult());
} else {
    print_r($incluir->getLastError());
}
/**
 * Sample call for IncluirEvento operation/method
 */
if ($incluir->IncluirEvento(new \StructType\IncluirEvento()) !== false) {
    print_r($incluir->getResult());
} else {
    print_r($incluir->getLastError());
}
/**
 * Sample call for IncluirCanaisdeAtendimentoPorCPFCNPJ operation/method
 */
if ($incluir->IncluirCanaisdeAtendimentoPorCPFCNPJ(new \StructType\IncluirCanaisdeAtendimentoPorCPFCNPJ()) !== false) {
    print_r($incluir->getResult());
} else {
    print_r($incluir->getLastError());
}
/**
 * Sample call for IncluirAcordo operation/method
 */
if ($incluir->IncluirAcordo(new \StructType\IncluirAcordo()) !== false) {
    print_r($incluir->getResult());
} else {
    print_r($incluir->getLastError());
}
/**
 * Sample call for IncluirContrato operation/method
 */
if ($incluir->IncluirContrato(new \StructType\IncluirContrato()) !== false) {
    print_r($incluir->getResult());
} else {
    print_r($incluir->getLastError());
}
/**
 * Sample call for IncluirEmail operation/method
 */
if ($incluir->IncluirEmail(new \StructType\IncluirEmail()) !== false) {
    print_r($incluir->getResult());
} else {
    print_r($incluir->getLastError());
}
/**
 * Sample call for IncluirTelefone operation/method
 */
if ($incluir->IncluirTelefone(new \StructType\IncluirTelefone()) !== false) {
    print_r($incluir->getResult());
} else {
    print_r($incluir->getLastError());
}
/**
 * Sample call for IncluirEndereco operation/method
 */
if ($incluir->IncluirEndereco(new \StructType\IncluirEndereco()) !== false) {
    print_r($incluir->getResult());
} else {
    print_r($incluir->getLastError());
}
/**
 * Samples for Salvar ServiceType
 */
$salvar = new \ServiceType\Salvar($options);
/**
 * Sample call for SalvarPagamentoCheckout operation/method
 */
if ($salvar->SalvarPagamentoCheckout(new \StructType\SalvarPagamentoCheckout()) !== false) {
    print_r($salvar->getResult());
} else {
    print_r($salvar->getLastError());
}
/**
 * Sample call for SalvarPagamentoPreTransacao operation/method
 */
if ($salvar->SalvarPagamentoPreTransacao(new \StructType\SalvarPagamentoPreTransacao()) !== false) {
    print_r($salvar->getResult());
} else {
    print_r($salvar->getLastError());
}
/**
 * Sample call for SalvarEventoRecusadoCheckout operation/method
 */
if ($salvar->SalvarEventoRecusadoCheckout(new \StructType\SalvarEventoRecusadoCheckout()) !== false) {
    print_r($salvar->getResult());
} else {
    print_r($salvar->getLastError());
}
/**
 * Sample call for SalvarCliente operation/method
 */
if ($salvar->SalvarCliente(new \StructType\SalvarCliente()) !== false) {
    print_r($salvar->getResult());
} else {
    print_r($salvar->getLastError());
}
/**
 * Sample call for SalvarAcordo operation/method
 */
if ($salvar->SalvarAcordo(new \StructType\SalvarAcordo()) !== false) {
    print_r($salvar->getResult());
} else {
    print_r($salvar->getLastError());
}
/**
 * Samples for Alterar ServiceType
 */
$alterar = new \ServiceType\Alterar($options);
/**
 * Sample call for AlterarSituacaoCheckout operation/method
 */
if ($alterar->AlterarSituacaoCheckout(new \StructType\AlterarSituacaoCheckout()) !== false) {
    print_r($alterar->getResult());
} else {
    print_r($alterar->getLastError());
}
/**
 * Sample call for AlterarNumeroAcordo operation/method
 */
if ($alterar->AlterarNumeroAcordo(new \StructType\AlterarNumeroAcordo()) !== false) {
    print_r($alterar->getResult());
} else {
    print_r($alterar->getLastError());
}
/**
 * Sample call for AlterarNumeroContratoAcordo operation/method
 */
if ($alterar->AlterarNumeroContratoAcordo(new \StructType\AlterarNumeroContratoAcordo()) !== false) {
    print_r($alterar->getResult());
} else {
    print_r($alterar->getLastError());
}
/**
 * Sample call for AlterarNumeroParcelaAcordo operation/method
 */
if ($alterar->AlterarNumeroParcelaAcordo(new \StructType\AlterarNumeroParcelaAcordo()) !== false) {
    print_r($alterar->getResult());
} else {
    print_r($alterar->getLastError());
}
/**
 * Samples for Concluir ServiceType
 */
$concluir = new \ServiceType\Concluir($options);
/**
 * Sample call for ConcluirCheckoutPosTransacao operation/method
 */
if ($concluir->ConcluirCheckoutPosTransacao(new \StructType\ConcluirCheckoutPosTransacao()) !== false) {
    print_r($concluir->getResult());
} else {
    print_r($concluir->getLastError());
}
/**
 * Sample call for ConcluirCheckout operation/method
 */
if ($concluir->ConcluirCheckout(new \StructType\ConcluirCheckout()) !== false) {
    print_r($concluir->getResult());
} else {
    print_r($concluir->getLastError());
}
/**
 * Samples for Estornar ServiceType
 */
$estornar = new \ServiceType\Estornar($options);
/**
 * Sample call for EstornarPagamentoCheckout operation/method
 */
if ($estornar->EstornarPagamentoCheckout(new \StructType\EstornarPagamentoCheckout()) !== false) {
    print_r($estornar->getResult());
} else {
    print_r($estornar->getLastError());
}
/**
 * Sample call for EstornarPagamento operation/method
 */
if ($estornar->EstornarPagamento(new \StructType\EstornarPagamento()) !== false) {
    print_r($estornar->getResult());
} else {
    print_r($estornar->getLastError());
}
/**
 * Samples for Evento ServiceType
 */
$evento = new \ServiceType\Evento($options);
/**
 * Sample call for EventoEmailAlertaErroCheckout operation/method
 */
if ($evento->EventoEmailAlertaErroCheckout(new \StructType\EventoEmailAlertaErroCheckout()) !== false) {
    print_r($evento->getResult());
} else {
    print_r($evento->getLastError());
}
/**
 * Samples for Login ServiceType
 */
$login = new \ServiceType\Login($options);
/**
 * Sample call for LoginPortal operation/method
 */
if ($login->LoginPortal(new \StructType\LoginPortal()) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Sample call for LoginRedirect operation/method
 */
if ($login->LoginRedirect(new \StructType\LoginRedirect()) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Sample call for LoginCobChat operation/method
 */
if ($login->LoginCobChat(new \StructType\LoginCobChat()) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for Listar ServiceType
 */
$listar = new \ServiceType\Listar($options);
/**
 * Sample call for ListarEstados operation/method
 */
if ($listar->ListarEstados(new \StructType\ListarEstados()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Sample call for ListarCidades operation/method
 */
if ($listar->ListarCidades(new \StructType\ListarCidades()) !== false) {
    print_r($listar->getResult());
} else {
    print_r($listar->getLastError());
}
/**
 * Samples for Solicita ServiceType
 */
$solicita = new \ServiceType\Solicita($options);
/**
 * Sample call for SolicitaContato operation/method
 */
if ($solicita->SolicitaContato(new \StructType\SolicitaContato()) !== false) {
    print_r($solicita->getResult());
} else {
    print_r($solicita->getLastError());
}
/**
 * Samples for Cadastra ServiceType
 */
$cadastra = new \ServiceType\Cadastra($options);
/**
 * Sample call for CadastraProposta operation/method
 */
if ($cadastra->CadastraProposta(new \StructType\CadastraProposta()) !== false) {
    print_r($cadastra->getResult());
} else {
    print_r($cadastra->getLastError());
}
/**
 * Samples for Recuperar ServiceType
 */
$recuperar = new \ServiceType\Recuperar($options);
/**
 * Sample call for RecuperarPlanosPortal operation/method
 */
if ($recuperar->RecuperarPlanosPortal(new \StructType\RecuperarPlanosPortal()) !== false) {
    print_r($recuperar->getResult());
} else {
    print_r($recuperar->getLastError());
}
/**
 * Sample call for RecuperarBinsElo operation/method
 */
if ($recuperar->RecuperarBinsElo(new \StructType\RecuperarBinsElo()) !== false) {
    print_r($recuperar->getResult());
} else {
    print_r($recuperar->getLastError());
}
/**
 * Samples for Grava ServiceType
 */
$grava = new \ServiceType\Grava($options);
/**
 * Sample call for GravaLogPortal operation/method
 */
if ($grava->GravaLogPortal(new \StructType\GravaLogPortal()) !== false) {
    print_r($grava->getResult());
} else {
    print_r($grava->getLastError());
}
/**
 * Samples for Valida ServiceType
 */
$valida = new \ServiceType\Valida($options);
/**
 * Sample call for ValidaToken operation/method
 */
if ($valida->ValidaToken(new \StructType\ValidaToken()) !== false) {
    print_r($valida->getResult());
} else {
    print_r($valida->getLastError());
}
/**
 * Samples for Atualizar ServiceType
 */
$atualizar = new \ServiceType\Atualizar($options);
/**
 * Sample call for AtualizarDadosCadastrais operation/method
 */
if ($atualizar->AtualizarDadosCadastrais(new \StructType\AtualizarDadosCadastrais()) !== false) {
    print_r($atualizar->getResult());
} else {
    print_r($atualizar->getLastError());
}
/**
 * Samples for Contratos ServiceType
 */
$contratos = new \ServiceType\Contratos($options);
/**
 * Sample call for ContratosDistribuidos operation/method
 */
if ($contratos->ContratosDistribuidos(new \StructType\ContratosDistribuidos()) !== false) {
    print_r($contratos->getResult());
} else {
    print_r($contratos->getLastError());
}
/**
 * Sample call for ContratosDistribuidosPorData operation/method
 */
if ($contratos->ContratosDistribuidosPorData(new \StructType\ContratosDistribuidosPorData()) !== false) {
    print_r($contratos->getResult());
} else {
    print_r($contratos->getLastError());
}
/**
 * Samples for Devolver ServiceType
 */
$devolver = new \ServiceType\Devolver($options);
/**
 * Sample call for DevolverContratoPorPagamentos operation/method
 */
if ($devolver->DevolverContratoPorPagamentos(new \StructType\DevolverContratoPorPagamentos()) !== false) {
    print_r($devolver->getResult());
} else {
    print_r($devolver->getLastError());
}
/**
 * Sample call for DevolverContratoPorPagamentoDireto operation/method
 */
if ($devolver->DevolverContratoPorPagamentoDireto(new \StructType\DevolverContratoPorPagamentoDireto()) !== false) {
    print_r($devolver->getResult());
} else {
    print_r($devolver->getLastError());
}
/**
 * Sample call for DevolverContrato operation/method
 */
if ($devolver->DevolverContrato(new \StructType\DevolverContrato()) !== false) {
    print_r($devolver->getResult());
} else {
    print_r($devolver->getLastError());
}
/**
 * Sample call for DevolverContratoMotivo operation/method
 */
if ($devolver->DevolverContratoMotivo(new \StructType\DevolverContratoMotivo()) !== false) {
    print_r($devolver->getResult());
} else {
    print_r($devolver->getLastError());
}
/**
 * Sample call for DevolverContratoPorDevolucoesParciais operation/method
 */
if ($devolver->DevolverContratoPorDevolucoesParciais(new \StructType\DevolverContratoPorDevolucoesParciais()) !== false) {
    print_r($devolver->getResult());
} else {
    print_r($devolver->getLastError());
}
/**
 * Samples for Pagar ServiceType
 */
$pagar = new \ServiceType\Pagar($options);
/**
 * Sample call for PagarAcordoPorParcela operation/method
 */
if ($pagar->PagarAcordoPorParcela(new \StructType\PagarAcordoPorParcela()) !== false) {
    print_r($pagar->getResult());
} else {
    print_r($pagar->getLastError());
}
/**
 * Sample call for PagarAcordo operation/method
 */
if ($pagar->PagarAcordo(new \StructType\PagarAcordo()) !== false) {
    print_r($pagar->getResult());
} else {
    print_r($pagar->getLastError());
}
/**
 * Samples for Remover ServiceType
 */
$remover = new \ServiceType\Remover($options);
/**
 * Sample call for RemoverSPC operation/method
 */
if ($remover->RemoverSPC(new \StructType\RemoverSPC()) !== false) {
    print_r($remover->getResult());
} else {
    print_r($remover->getLastError());
}
/**
 * Samples for Suspender ServiceType
 */
$suspender = new \ServiceType\Suspender($options);
/**
 * Sample call for SuspenderCobranca operation/method
 */
if ($suspender->SuspenderCobranca(new \StructType\SuspenderCobranca()) !== false) {
    print_r($suspender->getResult());
} else {
    print_r($suspender->getLastError());
}
/**
 * Samples for Reativar ServiceType
 */
$reativar = new \ServiceType\Reativar($options);
/**
 * Sample call for ReativarCobranca operation/method
 */
if ($reativar->ReativarCobranca(new \StructType\ReativarCobranca()) !== false) {
    print_r($reativar->getResult());
} else {
    print_r($reativar->getLastError());
}
/**
 * Samples for Reabrir ServiceType
 */
$reabrir = new \ServiceType\Reabrir($options);
/**
 * Sample call for ReabrirContrato operation/method
 */
if ($reabrir->ReabrirContrato(new \StructType\ReabrirContrato()) !== false) {
    print_r($reabrir->getResult());
} else {
    print_r($reabrir->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
/**
 * Sample call for CheckOutLog operation/method
 */
if ($check->CheckOutLog(new \StructType\CheckOutLog()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Verificar ServiceType
 */
$verificar = new \ServiceType\Verificar($options);
/**
 * Sample call for VerificarAprovacaoAcordosPortal operation/method
 */
if ($verificar->VerificarAprovacaoAcordosPortal(new \StructType\VerificarAprovacaoAcordosPortal()) !== false) {
    print_r($verificar->getResult());
} else {
    print_r($verificar->getLastError());
}
/**
 * Sample call for VerificarBloqueioImpressaoBoletoConfigPortal operation/method
 */
if ($verificar->VerificarBloqueioImpressaoBoletoConfigPortal(new \StructType\VerificarBloqueioImpressaoBoletoConfigPortal()) !== false) {
    print_r($verificar->getResult());
} else {
    print_r($verificar->getLastError());
}
