<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerificarBloqueioImpressaoBoletoConfigPortal StructType
 * @subpackage Structs
 */
class VerificarBloqueioImpressaoBoletoConfigPortal extends AbstractStructBase
{
    /**
     * The parcela
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $parcela;
    /**
     * The IdAcordoCriptografado
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdAcordoCriptografado;
    /**
     * The IdCredor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdCredor;
    /**
     * The IdPortalAcesso
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdPortalAcesso;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * Constructor method for VerificarBloqueioImpressaoBoletoConfigPortal
     * @uses VerificarBloqueioImpressaoBoletoConfigPortal::setParcela()
     * @uses VerificarBloqueioImpressaoBoletoConfigPortal::setIdAcordoCriptografado()
     * @uses VerificarBloqueioImpressaoBoletoConfigPortal::setIdCredor()
     * @uses VerificarBloqueioImpressaoBoletoConfigPortal::setIdPortalAcesso()
     * @uses VerificarBloqueioImpressaoBoletoConfigPortal::setToken()
     * @param string $parcela
     * @param string $idAcordoCriptografado
     * @param int $idCredor
     * @param int $idPortalAcesso
     * @param string $token
     */
    public function __construct($parcela = null, $idAcordoCriptografado = null, $idCredor = null, $idPortalAcesso = null, $token = null)
    {
        $this
            ->setParcela($parcela)
            ->setIdAcordoCriptografado($idAcordoCriptografado)
            ->setIdCredor($idCredor)
            ->setIdPortalAcesso($idPortalAcesso)
            ->setToken($token);
    }
    /**
     * Get parcela value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParcela()
    {
        return isset($this->parcela) ? $this->parcela : null;
    }
    /**
     * Set parcela value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parcela
     * @return \StructType\VerificarBloqueioImpressaoBoletoConfigPortal
     */
    public function setParcela($parcela = null)
    {
        // validation for constraint: string
        if (!is_null($parcela) && !is_string($parcela)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parcela, true), gettype($parcela)), __LINE__);
        }
        if (is_null($parcela) || (is_array($parcela) && empty($parcela))) {
            unset($this->parcela);
        } else {
            $this->parcela = $parcela;
        }
        return $this;
    }
    /**
     * Get IdAcordoCriptografado value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdAcordoCriptografado()
    {
        return isset($this->IdAcordoCriptografado) ? $this->IdAcordoCriptografado : null;
    }
    /**
     * Set IdAcordoCriptografado value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idAcordoCriptografado
     * @return \StructType\VerificarBloqueioImpressaoBoletoConfigPortal
     */
    public function setIdAcordoCriptografado($idAcordoCriptografado = null)
    {
        // validation for constraint: string
        if (!is_null($idAcordoCriptografado) && !is_string($idAcordoCriptografado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idAcordoCriptografado, true), gettype($idAcordoCriptografado)), __LINE__);
        }
        if (is_null($idAcordoCriptografado) || (is_array($idAcordoCriptografado) && empty($idAcordoCriptografado))) {
            unset($this->IdAcordoCriptografado);
        } else {
            $this->IdAcordoCriptografado = $idAcordoCriptografado;
        }
        return $this;
    }
    /**
     * Get IdCredor value
     * @return int|null
     */
    public function getIdCredor()
    {
        return $this->IdCredor;
    }
    /**
     * Set IdCredor value
     * @param int $idCredor
     * @return \StructType\VerificarBloqueioImpressaoBoletoConfigPortal
     */
    public function setIdCredor($idCredor = null)
    {
        // validation for constraint: int
        if (!is_null($idCredor) && !(is_int($idCredor) || ctype_digit($idCredor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idCredor, true), gettype($idCredor)), __LINE__);
        }
        $this->IdCredor = $idCredor;
        return $this;
    }
    /**
     * Get IdPortalAcesso value
     * @return int|null
     */
    public function getIdPortalAcesso()
    {
        return $this->IdPortalAcesso;
    }
    /**
     * Set IdPortalAcesso value
     * @param int $idPortalAcesso
     * @return \StructType\VerificarBloqueioImpressaoBoletoConfigPortal
     */
    public function setIdPortalAcesso($idPortalAcesso = null)
    {
        // validation for constraint: int
        if (!is_null($idPortalAcesso) && !(is_int($idPortalAcesso) || ctype_digit($idPortalAcesso))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idPortalAcesso, true), gettype($idPortalAcesso)), __LINE__);
        }
        $this->IdPortalAcesso = $idPortalAcesso;
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \StructType\VerificarBloqueioImpressaoBoletoConfigPortal
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
}
