<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SuspenderCobranca StructType
 * @subpackage Structs
 */
class SuspenderCobranca extends AbstractStructBase
{
    /**
     * The ChaveCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChaveCliente;
    /**
     * The Contrato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Contrato;
    /**
     * The MotivoSuspensao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MotivoSuspensao;
    /**
     * The Observacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Observacao;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * Constructor method for SuspenderCobranca
     * @uses SuspenderCobranca::setChaveCliente()
     * @uses SuspenderCobranca::setContrato()
     * @uses SuspenderCobranca::setMotivoSuspensao()
     * @uses SuspenderCobranca::setObservacao()
     * @uses SuspenderCobranca::setToken()
     * @param string $chaveCliente
     * @param string $contrato
     * @param string $motivoSuspensao
     * @param string $observacao
     * @param string $token
     */
    public function __construct($chaveCliente = null, $contrato = null, $motivoSuspensao = null, $observacao = null, $token = null)
    {
        $this
            ->setChaveCliente($chaveCliente)
            ->setContrato($contrato)
            ->setMotivoSuspensao($motivoSuspensao)
            ->setObservacao($observacao)
            ->setToken($token);
    }
    /**
     * Get ChaveCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChaveCliente()
    {
        return isset($this->ChaveCliente) ? $this->ChaveCliente : null;
    }
    /**
     * Set ChaveCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chaveCliente
     * @return \StructType\SuspenderCobranca
     */
    public function setChaveCliente($chaveCliente = null)
    {
        // validation for constraint: string
        if (!is_null($chaveCliente) && !is_string($chaveCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chaveCliente, true), gettype($chaveCliente)), __LINE__);
        }
        if (is_null($chaveCliente) || (is_array($chaveCliente) && empty($chaveCliente))) {
            unset($this->ChaveCliente);
        } else {
            $this->ChaveCliente = $chaveCliente;
        }
        return $this;
    }
    /**
     * Get Contrato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContrato()
    {
        return isset($this->Contrato) ? $this->Contrato : null;
    }
    /**
     * Set Contrato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contrato
     * @return \StructType\SuspenderCobranca
     */
    public function setContrato($contrato = null)
    {
        // validation for constraint: string
        if (!is_null($contrato) && !is_string($contrato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contrato, true), gettype($contrato)), __LINE__);
        }
        if (is_null($contrato) || (is_array($contrato) && empty($contrato))) {
            unset($this->Contrato);
        } else {
            $this->Contrato = $contrato;
        }
        return $this;
    }
    /**
     * Get MotivoSuspensao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMotivoSuspensao()
    {
        return isset($this->MotivoSuspensao) ? $this->MotivoSuspensao : null;
    }
    /**
     * Set MotivoSuspensao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $motivoSuspensao
     * @return \StructType\SuspenderCobranca
     */
    public function setMotivoSuspensao($motivoSuspensao = null)
    {
        // validation for constraint: string
        if (!is_null($motivoSuspensao) && !is_string($motivoSuspensao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($motivoSuspensao, true), gettype($motivoSuspensao)), __LINE__);
        }
        if (is_null($motivoSuspensao) || (is_array($motivoSuspensao) && empty($motivoSuspensao))) {
            unset($this->MotivoSuspensao);
        } else {
            $this->MotivoSuspensao = $motivoSuspensao;
        }
        return $this;
    }
    /**
     * Get Observacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObservacao()
    {
        return isset($this->Observacao) ? $this->Observacao : null;
    }
    /**
     * Set Observacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $observacao
     * @return \StructType\SuspenderCobranca
     */
    public function setObservacao($observacao = null)
    {
        // validation for constraint: string
        if (!is_null($observacao) && !is_string($observacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($observacao, true), gettype($observacao)), __LINE__);
        }
        if (is_null($observacao) || (is_array($observacao) && empty($observacao))) {
            unset($this->Observacao);
        } else {
            $this->Observacao = $observacao;
        }
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \StructType\SuspenderCobranca
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
}
