<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalvarAcordoType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SalvarAcordoType
 * @subpackage Structs
 */
class SalvarAcordoType extends AbstractStructBase
{
    /**
     * The ChaveCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChaveCliente;
    /**
     * The DataEmissao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataEmissao;
    /**
     * The Despesas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDespesaRequest
     */
    public $Despesas;
    /**
     * The NumeroAcordo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumeroAcordo;
    /**
     * The ParcelasAcordo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfParcelaNovaAcordoRequest
     */
    public $ParcelasAcordo;
    /**
     * The ParcelasOriginais
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfParcelaOriginalAcordoRequest
     */
    public $ParcelasOriginais;
    /**
     * The TaxaParcelamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TaxaParcelamento;
    /**
     * The ValorEntrada
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorEntrada;
    /**
     * Constructor method for SalvarAcordoType
     * @uses SalvarAcordoType::setChaveCliente()
     * @uses SalvarAcordoType::setDataEmissao()
     * @uses SalvarAcordoType::setDespesas()
     * @uses SalvarAcordoType::setNumeroAcordo()
     * @uses SalvarAcordoType::setParcelasAcordo()
     * @uses SalvarAcordoType::setParcelasOriginais()
     * @uses SalvarAcordoType::setTaxaParcelamento()
     * @uses SalvarAcordoType::setValorEntrada()
     * @param string $chaveCliente
     * @param string $dataEmissao
     * @param \ArrayType\ArrayOfDespesaRequest $despesas
     * @param int $numeroAcordo
     * @param \ArrayType\ArrayOfParcelaNovaAcordoRequest $parcelasAcordo
     * @param \ArrayType\ArrayOfParcelaOriginalAcordoRequest $parcelasOriginais
     * @param float $taxaParcelamento
     * @param float $valorEntrada
     */
    public function __construct($chaveCliente = null, $dataEmissao = null, \ArrayType\ArrayOfDespesaRequest $despesas = null, $numeroAcordo = null, \ArrayType\ArrayOfParcelaNovaAcordoRequest $parcelasAcordo = null, \ArrayType\ArrayOfParcelaOriginalAcordoRequest $parcelasOriginais = null, $taxaParcelamento = null, $valorEntrada = null)
    {
        $this
            ->setChaveCliente($chaveCliente)
            ->setDataEmissao($dataEmissao)
            ->setDespesas($despesas)
            ->setNumeroAcordo($numeroAcordo)
            ->setParcelasAcordo($parcelasAcordo)
            ->setParcelasOriginais($parcelasOriginais)
            ->setTaxaParcelamento($taxaParcelamento)
            ->setValorEntrada($valorEntrada);
    }
    /**
     * Get ChaveCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChaveCliente()
    {
        return isset($this->ChaveCliente) ? $this->ChaveCliente : null;
    }
    /**
     * Set ChaveCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chaveCliente
     * @return \StructType\SalvarAcordoType
     */
    public function setChaveCliente($chaveCliente = null)
    {
        // validation for constraint: string
        if (!is_null($chaveCliente) && !is_string($chaveCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chaveCliente, true), gettype($chaveCliente)), __LINE__);
        }
        if (is_null($chaveCliente) || (is_array($chaveCliente) && empty($chaveCliente))) {
            unset($this->ChaveCliente);
        } else {
            $this->ChaveCliente = $chaveCliente;
        }
        return $this;
    }
    /**
     * Get DataEmissao value
     * @return string|null
     */
    public function getDataEmissao()
    {
        return $this->DataEmissao;
    }
    /**
     * Set DataEmissao value
     * @param string $dataEmissao
     * @return \StructType\SalvarAcordoType
     */
    public function setDataEmissao($dataEmissao = null)
    {
        // validation for constraint: string
        if (!is_null($dataEmissao) && !is_string($dataEmissao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataEmissao, true), gettype($dataEmissao)), __LINE__);
        }
        $this->DataEmissao = $dataEmissao;
        return $this;
    }
    /**
     * Get Despesas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDespesaRequest|null
     */
    public function getDespesas()
    {
        return isset($this->Despesas) ? $this->Despesas : null;
    }
    /**
     * Set Despesas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDespesaRequest $despesas
     * @return \StructType\SalvarAcordoType
     */
    public function setDespesas(\ArrayType\ArrayOfDespesaRequest $despesas = null)
    {
        if (is_null($despesas) || (is_array($despesas) && empty($despesas))) {
            unset($this->Despesas);
        } else {
            $this->Despesas = $despesas;
        }
        return $this;
    }
    /**
     * Get NumeroAcordo value
     * @return int|null
     */
    public function getNumeroAcordo()
    {
        return $this->NumeroAcordo;
    }
    /**
     * Set NumeroAcordo value
     * @param int $numeroAcordo
     * @return \StructType\SalvarAcordoType
     */
    public function setNumeroAcordo($numeroAcordo = null)
    {
        // validation for constraint: int
        if (!is_null($numeroAcordo) && !(is_int($numeroAcordo) || ctype_digit($numeroAcordo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroAcordo, true), gettype($numeroAcordo)), __LINE__);
        }
        $this->NumeroAcordo = $numeroAcordo;
        return $this;
    }
    /**
     * Get ParcelasAcordo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfParcelaNovaAcordoRequest|null
     */
    public function getParcelasAcordo()
    {
        return isset($this->ParcelasAcordo) ? $this->ParcelasAcordo : null;
    }
    /**
     * Set ParcelasAcordo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfParcelaNovaAcordoRequest $parcelasAcordo
     * @return \StructType\SalvarAcordoType
     */
    public function setParcelasAcordo(\ArrayType\ArrayOfParcelaNovaAcordoRequest $parcelasAcordo = null)
    {
        if (is_null($parcelasAcordo) || (is_array($parcelasAcordo) && empty($parcelasAcordo))) {
            unset($this->ParcelasAcordo);
        } else {
            $this->ParcelasAcordo = $parcelasAcordo;
        }
        return $this;
    }
    /**
     * Get ParcelasOriginais value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfParcelaOriginalAcordoRequest|null
     */
    public function getParcelasOriginais()
    {
        return isset($this->ParcelasOriginais) ? $this->ParcelasOriginais : null;
    }
    /**
     * Set ParcelasOriginais value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfParcelaOriginalAcordoRequest $parcelasOriginais
     * @return \StructType\SalvarAcordoType
     */
    public function setParcelasOriginais(\ArrayType\ArrayOfParcelaOriginalAcordoRequest $parcelasOriginais = null)
    {
        if (is_null($parcelasOriginais) || (is_array($parcelasOriginais) && empty($parcelasOriginais))) {
            unset($this->ParcelasOriginais);
        } else {
            $this->ParcelasOriginais = $parcelasOriginais;
        }
        return $this;
    }
    /**
     * Get TaxaParcelamento value
     * @return float|null
     */
    public function getTaxaParcelamento()
    {
        return $this->TaxaParcelamento;
    }
    /**
     * Set TaxaParcelamento value
     * @param float $taxaParcelamento
     * @return \StructType\SalvarAcordoType
     */
    public function setTaxaParcelamento($taxaParcelamento = null)
    {
        // validation for constraint: float
        if (!is_null($taxaParcelamento) && !(is_float($taxaParcelamento) || is_numeric($taxaParcelamento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($taxaParcelamento, true), gettype($taxaParcelamento)), __LINE__);
        }
        $this->TaxaParcelamento = $taxaParcelamento;
        return $this;
    }
    /**
     * Get ValorEntrada value
     * @return float|null
     */
    public function getValorEntrada()
    {
        return $this->ValorEntrada;
    }
    /**
     * Set ValorEntrada value
     * @param float $valorEntrada
     * @return \StructType\SalvarAcordoType
     */
    public function setValorEntrada($valorEntrada = null)
    {
        // validation for constraint: float
        if (!is_null($valorEntrada) && !(is_float($valorEntrada) || is_numeric($valorEntrada))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorEntrada, true), gettype($valorEntrada)), __LINE__);
        }
        $this->ValorEntrada = $valorEntrada;
        return $this;
    }
}
