<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PropostaType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PropostaType
 * @subpackage Structs
 */
class PropostaType extends AbstractStructBase
{
    /**
     * The DataCalculo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataCalculo;
    /**
     * The NumeroParcelas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumeroParcelas;
    /**
     * The Observacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Observacao;
    /**
     * The ParcelasOriginais
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfParcelaCalculoType
     */
    public $ParcelasOriginais;
    /**
     * The ValorEntrada
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorEntrada;
    /**
     * The ValorFinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorFinal;
    /**
     * Constructor method for PropostaType
     * @uses PropostaType::setDataCalculo()
     * @uses PropostaType::setNumeroParcelas()
     * @uses PropostaType::setObservacao()
     * @uses PropostaType::setParcelasOriginais()
     * @uses PropostaType::setValorEntrada()
     * @uses PropostaType::setValorFinal()
     * @param string $dataCalculo
     * @param int $numeroParcelas
     * @param string $observacao
     * @param \ArrayType\ArrayOfParcelaCalculoType $parcelasOriginais
     * @param float $valorEntrada
     * @param float $valorFinal
     */
    public function __construct($dataCalculo = null, $numeroParcelas = null, $observacao = null, \ArrayType\ArrayOfParcelaCalculoType $parcelasOriginais = null, $valorEntrada = null, $valorFinal = null)
    {
        $this
            ->setDataCalculo($dataCalculo)
            ->setNumeroParcelas($numeroParcelas)
            ->setObservacao($observacao)
            ->setParcelasOriginais($parcelasOriginais)
            ->setValorEntrada($valorEntrada)
            ->setValorFinal($valorFinal);
    }
    /**
     * Get DataCalculo value
     * @return string|null
     */
    public function getDataCalculo()
    {
        return $this->DataCalculo;
    }
    /**
     * Set DataCalculo value
     * @param string $dataCalculo
     * @return \StructType\PropostaType
     */
    public function setDataCalculo($dataCalculo = null)
    {
        // validation for constraint: string
        if (!is_null($dataCalculo) && !is_string($dataCalculo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataCalculo, true), gettype($dataCalculo)), __LINE__);
        }
        $this->DataCalculo = $dataCalculo;
        return $this;
    }
    /**
     * Get NumeroParcelas value
     * @return int|null
     */
    public function getNumeroParcelas()
    {
        return $this->NumeroParcelas;
    }
    /**
     * Set NumeroParcelas value
     * @param int $numeroParcelas
     * @return \StructType\PropostaType
     */
    public function setNumeroParcelas($numeroParcelas = null)
    {
        // validation for constraint: int
        if (!is_null($numeroParcelas) && !(is_int($numeroParcelas) || ctype_digit($numeroParcelas))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroParcelas, true), gettype($numeroParcelas)), __LINE__);
        }
        $this->NumeroParcelas = $numeroParcelas;
        return $this;
    }
    /**
     * Get Observacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObservacao()
    {
        return isset($this->Observacao) ? $this->Observacao : null;
    }
    /**
     * Set Observacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $observacao
     * @return \StructType\PropostaType
     */
    public function setObservacao($observacao = null)
    {
        // validation for constraint: string
        if (!is_null($observacao) && !is_string($observacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($observacao, true), gettype($observacao)), __LINE__);
        }
        if (is_null($observacao) || (is_array($observacao) && empty($observacao))) {
            unset($this->Observacao);
        } else {
            $this->Observacao = $observacao;
        }
        return $this;
    }
    /**
     * Get ParcelasOriginais value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfParcelaCalculoType|null
     */
    public function getParcelasOriginais()
    {
        return isset($this->ParcelasOriginais) ? $this->ParcelasOriginais : null;
    }
    /**
     * Set ParcelasOriginais value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfParcelaCalculoType $parcelasOriginais
     * @return \StructType\PropostaType
     */
    public function setParcelasOriginais(\ArrayType\ArrayOfParcelaCalculoType $parcelasOriginais = null)
    {
        if (is_null($parcelasOriginais) || (is_array($parcelasOriginais) && empty($parcelasOriginais))) {
            unset($this->ParcelasOriginais);
        } else {
            $this->ParcelasOriginais = $parcelasOriginais;
        }
        return $this;
    }
    /**
     * Get ValorEntrada value
     * @return float|null
     */
    public function getValorEntrada()
    {
        return $this->ValorEntrada;
    }
    /**
     * Set ValorEntrada value
     * @param float $valorEntrada
     * @return \StructType\PropostaType
     */
    public function setValorEntrada($valorEntrada = null)
    {
        // validation for constraint: float
        if (!is_null($valorEntrada) && !(is_float($valorEntrada) || is_numeric($valorEntrada))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorEntrada, true), gettype($valorEntrada)), __LINE__);
        }
        $this->ValorEntrada = $valorEntrada;
        return $this;
    }
    /**
     * Get ValorFinal value
     * @return float|null
     */
    public function getValorFinal()
    {
        return $this->ValorFinal;
    }
    /**
     * Set ValorFinal value
     * @param float $valorFinal
     * @return \StructType\PropostaType
     */
    public function setValorFinal($valorFinal = null)
    {
        // validation for constraint: float
        if (!is_null($valorFinal) && !(is_float($valorFinal) || is_numeric($valorFinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorFinal, true), gettype($valorFinal)), __LINE__);
        }
        $this->ValorFinal = $valorFinal;
        return $this;
    }
}
