<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParcelaOriginalAcordoType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ParcelaOriginalAcordoType
 * @subpackage Structs
 */
class ParcelaOriginalAcordoType extends AbstractStructBase
{
    /**
     * The Honorarios
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Honorarios;
    /**
     * The Juros
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Juros;
    /**
     * The Multa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Multa;
    /**
     * The Numero
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Numero;
    /**
     * The NumeroContrato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumeroContrato;
    /**
     * The ValorOriginal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorOriginal;
    /**
     * The ValorPrincipal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorPrincipal;
    /**
     * The Vencimento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Vencimento;
    /**
     * Constructor method for ParcelaOriginalAcordoType
     * @uses ParcelaOriginalAcordoType::setHonorarios()
     * @uses ParcelaOriginalAcordoType::setJuros()
     * @uses ParcelaOriginalAcordoType::setMulta()
     * @uses ParcelaOriginalAcordoType::setNumero()
     * @uses ParcelaOriginalAcordoType::setNumeroContrato()
     * @uses ParcelaOriginalAcordoType::setValorOriginal()
     * @uses ParcelaOriginalAcordoType::setValorPrincipal()
     * @uses ParcelaOriginalAcordoType::setVencimento()
     * @param float $honorarios
     * @param float $juros
     * @param float $multa
     * @param string $numero
     * @param string $numeroContrato
     * @param float $valorOriginal
     * @param float $valorPrincipal
     * @param string $vencimento
     */
    public function __construct($honorarios = null, $juros = null, $multa = null, $numero = null, $numeroContrato = null, $valorOriginal = null, $valorPrincipal = null, $vencimento = null)
    {
        $this
            ->setHonorarios($honorarios)
            ->setJuros($juros)
            ->setMulta($multa)
            ->setNumero($numero)
            ->setNumeroContrato($numeroContrato)
            ->setValorOriginal($valorOriginal)
            ->setValorPrincipal($valorPrincipal)
            ->setVencimento($vencimento);
    }
    /**
     * Get Honorarios value
     * @return float|null
     */
    public function getHonorarios()
    {
        return $this->Honorarios;
    }
    /**
     * Set Honorarios value
     * @param float $honorarios
     * @return \StructType\ParcelaOriginalAcordoType
     */
    public function setHonorarios($honorarios = null)
    {
        // validation for constraint: float
        if (!is_null($honorarios) && !(is_float($honorarios) || is_numeric($honorarios))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($honorarios, true), gettype($honorarios)), __LINE__);
        }
        $this->Honorarios = $honorarios;
        return $this;
    }
    /**
     * Get Juros value
     * @return float|null
     */
    public function getJuros()
    {
        return $this->Juros;
    }
    /**
     * Set Juros value
     * @param float $juros
     * @return \StructType\ParcelaOriginalAcordoType
     */
    public function setJuros($juros = null)
    {
        // validation for constraint: float
        if (!is_null($juros) && !(is_float($juros) || is_numeric($juros))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($juros, true), gettype($juros)), __LINE__);
        }
        $this->Juros = $juros;
        return $this;
    }
    /**
     * Get Multa value
     * @return float|null
     */
    public function getMulta()
    {
        return $this->Multa;
    }
    /**
     * Set Multa value
     * @param float $multa
     * @return \StructType\ParcelaOriginalAcordoType
     */
    public function setMulta($multa = null)
    {
        // validation for constraint: float
        if (!is_null($multa) && !(is_float($multa) || is_numeric($multa))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($multa, true), gettype($multa)), __LINE__);
        }
        $this->Multa = $multa;
        return $this;
    }
    /**
     * Get Numero value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumero()
    {
        return isset($this->Numero) ? $this->Numero : null;
    }
    /**
     * Set Numero value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numero
     * @return \StructType\ParcelaOriginalAcordoType
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: string
        if (!is_null($numero) && !is_string($numero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        if (is_null($numero) || (is_array($numero) && empty($numero))) {
            unset($this->Numero);
        } else {
            $this->Numero = $numero;
        }
        return $this;
    }
    /**
     * Get NumeroContrato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumeroContrato()
    {
        return isset($this->NumeroContrato) ? $this->NumeroContrato : null;
    }
    /**
     * Set NumeroContrato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numeroContrato
     * @return \StructType\ParcelaOriginalAcordoType
     */
    public function setNumeroContrato($numeroContrato = null)
    {
        // validation for constraint: string
        if (!is_null($numeroContrato) && !is_string($numeroContrato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroContrato, true), gettype($numeroContrato)), __LINE__);
        }
        if (is_null($numeroContrato) || (is_array($numeroContrato) && empty($numeroContrato))) {
            unset($this->NumeroContrato);
        } else {
            $this->NumeroContrato = $numeroContrato;
        }
        return $this;
    }
    /**
     * Get ValorOriginal value
     * @return float|null
     */
    public function getValorOriginal()
    {
        return $this->ValorOriginal;
    }
    /**
     * Set ValorOriginal value
     * @param float $valorOriginal
     * @return \StructType\ParcelaOriginalAcordoType
     */
    public function setValorOriginal($valorOriginal = null)
    {
        // validation for constraint: float
        if (!is_null($valorOriginal) && !(is_float($valorOriginal) || is_numeric($valorOriginal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorOriginal, true), gettype($valorOriginal)), __LINE__);
        }
        $this->ValorOriginal = $valorOriginal;
        return $this;
    }
    /**
     * Get ValorPrincipal value
     * @return float|null
     */
    public function getValorPrincipal()
    {
        return $this->ValorPrincipal;
    }
    /**
     * Set ValorPrincipal value
     * @param float $valorPrincipal
     * @return \StructType\ParcelaOriginalAcordoType
     */
    public function setValorPrincipal($valorPrincipal = null)
    {
        // validation for constraint: float
        if (!is_null($valorPrincipal) && !(is_float($valorPrincipal) || is_numeric($valorPrincipal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorPrincipal, true), gettype($valorPrincipal)), __LINE__);
        }
        $this->ValorPrincipal = $valorPrincipal;
        return $this;
    }
    /**
     * Get Vencimento value
     * @return string|null
     */
    public function getVencimento()
    {
        return $this->Vencimento;
    }
    /**
     * Set Vencimento value
     * @param string $vencimento
     * @return \StructType\ParcelaOriginalAcordoType
     */
    public function setVencimento($vencimento = null)
    {
        // validation for constraint: string
        if (!is_null($vencimento) && !is_string($vencimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vencimento, true), gettype($vencimento)), __LINE__);
        }
        $this->Vencimento = $vencimento;
        return $this;
    }
}
