<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ParcelaCalculoResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ParcelaCalculoResponse
 * @subpackage Structs
 */
class ParcelaCalculoResponse extends AbstractStructBase
{
    /**
     * The CET
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CET
     */
    public $CET;
    /**
     * The Desconto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Desconto;
    /**
     * The DescontoDesagio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DescontoDesagio;
    /**
     * The Entrada
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Entrada;
    /**
     * The ParcelasAcordo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfParcelaAcordoType
     */
    public $ParcelasAcordo;
    /**
     * The PorcentagemDesconto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PorcentagemDesconto;
    /**
     * The QtdeParcelas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $QtdeParcelas;
    /**
     * The UltimoVencimento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $UltimoVencimento;
    /**
     * The ValorParcela
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorParcela;
    /**
     * The ValorTaxaParcelamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorTaxaParcelamento;
    /**
     * The ValorTotalComDesconto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorTotalComDesconto;
    /**
     * The ValorTotalProposta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorTotalProposta;
    /**
     * The ValorTotalSemDesconto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorTotalSemDesconto;
    /**
     * Constructor method for ParcelaCalculoResponse
     * @uses ParcelaCalculoResponse::setCET()
     * @uses ParcelaCalculoResponse::setDesconto()
     * @uses ParcelaCalculoResponse::setDescontoDesagio()
     * @uses ParcelaCalculoResponse::setEntrada()
     * @uses ParcelaCalculoResponse::setParcelasAcordo()
     * @uses ParcelaCalculoResponse::setPorcentagemDesconto()
     * @uses ParcelaCalculoResponse::setQtdeParcelas()
     * @uses ParcelaCalculoResponse::setUltimoVencimento()
     * @uses ParcelaCalculoResponse::setValorParcela()
     * @uses ParcelaCalculoResponse::setValorTaxaParcelamento()
     * @uses ParcelaCalculoResponse::setValorTotalComDesconto()
     * @uses ParcelaCalculoResponse::setValorTotalProposta()
     * @uses ParcelaCalculoResponse::setValorTotalSemDesconto()
     * @param \StructType\CET $cET
     * @param float $desconto
     * @param float $descontoDesagio
     * @param float $entrada
     * @param \ArrayType\ArrayOfParcelaAcordoType $parcelasAcordo
     * @param int $porcentagemDesconto
     * @param int $qtdeParcelas
     * @param string $ultimoVencimento
     * @param float $valorParcela
     * @param float $valorTaxaParcelamento
     * @param float $valorTotalComDesconto
     * @param float $valorTotalProposta
     * @param float $valorTotalSemDesconto
     */
    public function __construct(\StructType\CET $cET = null, $desconto = null, $descontoDesagio = null, $entrada = null, \ArrayType\ArrayOfParcelaAcordoType $parcelasAcordo = null, $porcentagemDesconto = null, $qtdeParcelas = null, $ultimoVencimento = null, $valorParcela = null, $valorTaxaParcelamento = null, $valorTotalComDesconto = null, $valorTotalProposta = null, $valorTotalSemDesconto = null)
    {
        $this
            ->setCET($cET)
            ->setDesconto($desconto)
            ->setDescontoDesagio($descontoDesagio)
            ->setEntrada($entrada)
            ->setParcelasAcordo($parcelasAcordo)
            ->setPorcentagemDesconto($porcentagemDesconto)
            ->setQtdeParcelas($qtdeParcelas)
            ->setUltimoVencimento($ultimoVencimento)
            ->setValorParcela($valorParcela)
            ->setValorTaxaParcelamento($valorTaxaParcelamento)
            ->setValorTotalComDesconto($valorTotalComDesconto)
            ->setValorTotalProposta($valorTotalProposta)
            ->setValorTotalSemDesconto($valorTotalSemDesconto);
    }
    /**
     * Get CET value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CET|null
     */
    public function getCET()
    {
        return isset($this->CET) ? $this->CET : null;
    }
    /**
     * Set CET value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CET $cET
     * @return \StructType\ParcelaCalculoResponse
     */
    public function setCET(\StructType\CET $cET = null)
    {
        if (is_null($cET) || (is_array($cET) && empty($cET))) {
            unset($this->CET);
        } else {
            $this->CET = $cET;
        }
        return $this;
    }
    /**
     * Get Desconto value
     * @return float|null
     */
    public function getDesconto()
    {
        return $this->Desconto;
    }
    /**
     * Set Desconto value
     * @param float $desconto
     * @return \StructType\ParcelaCalculoResponse
     */
    public function setDesconto($desconto = null)
    {
        // validation for constraint: float
        if (!is_null($desconto) && !(is_float($desconto) || is_numeric($desconto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($desconto, true), gettype($desconto)), __LINE__);
        }
        $this->Desconto = $desconto;
        return $this;
    }
    /**
     * Get DescontoDesagio value
     * @return float|null
     */
    public function getDescontoDesagio()
    {
        return $this->DescontoDesagio;
    }
    /**
     * Set DescontoDesagio value
     * @param float $descontoDesagio
     * @return \StructType\ParcelaCalculoResponse
     */
    public function setDescontoDesagio($descontoDesagio = null)
    {
        // validation for constraint: float
        if (!is_null($descontoDesagio) && !(is_float($descontoDesagio) || is_numeric($descontoDesagio))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($descontoDesagio, true), gettype($descontoDesagio)), __LINE__);
        }
        $this->DescontoDesagio = $descontoDesagio;
        return $this;
    }
    /**
     * Get Entrada value
     * @return float|null
     */
    public function getEntrada()
    {
        return $this->Entrada;
    }
    /**
     * Set Entrada value
     * @param float $entrada
     * @return \StructType\ParcelaCalculoResponse
     */
    public function setEntrada($entrada = null)
    {
        // validation for constraint: float
        if (!is_null($entrada) && !(is_float($entrada) || is_numeric($entrada))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($entrada, true), gettype($entrada)), __LINE__);
        }
        $this->Entrada = $entrada;
        return $this;
    }
    /**
     * Get ParcelasAcordo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfParcelaAcordoType|null
     */
    public function getParcelasAcordo()
    {
        return isset($this->ParcelasAcordo) ? $this->ParcelasAcordo : null;
    }
    /**
     * Set ParcelasAcordo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfParcelaAcordoType $parcelasAcordo
     * @return \StructType\ParcelaCalculoResponse
     */
    public function setParcelasAcordo(\ArrayType\ArrayOfParcelaAcordoType $parcelasAcordo = null)
    {
        if (is_null($parcelasAcordo) || (is_array($parcelasAcordo) && empty($parcelasAcordo))) {
            unset($this->ParcelasAcordo);
        } else {
            $this->ParcelasAcordo = $parcelasAcordo;
        }
        return $this;
    }
    /**
     * Get PorcentagemDesconto value
     * @return int|null
     */
    public function getPorcentagemDesconto()
    {
        return $this->PorcentagemDesconto;
    }
    /**
     * Set PorcentagemDesconto value
     * @param int $porcentagemDesconto
     * @return \StructType\ParcelaCalculoResponse
     */
    public function setPorcentagemDesconto($porcentagemDesconto = null)
    {
        // validation for constraint: int
        if (!is_null($porcentagemDesconto) && !(is_int($porcentagemDesconto) || ctype_digit($porcentagemDesconto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($porcentagemDesconto, true), gettype($porcentagemDesconto)), __LINE__);
        }
        $this->PorcentagemDesconto = $porcentagemDesconto;
        return $this;
    }
    /**
     * Get QtdeParcelas value
     * @return int|null
     */
    public function getQtdeParcelas()
    {
        return $this->QtdeParcelas;
    }
    /**
     * Set QtdeParcelas value
     * @param int $qtdeParcelas
     * @return \StructType\ParcelaCalculoResponse
     */
    public function setQtdeParcelas($qtdeParcelas = null)
    {
        // validation for constraint: int
        if (!is_null($qtdeParcelas) && !(is_int($qtdeParcelas) || ctype_digit($qtdeParcelas))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($qtdeParcelas, true), gettype($qtdeParcelas)), __LINE__);
        }
        $this->QtdeParcelas = $qtdeParcelas;
        return $this;
    }
    /**
     * Get UltimoVencimento value
     * @return string|null
     */
    public function getUltimoVencimento()
    {
        return $this->UltimoVencimento;
    }
    /**
     * Set UltimoVencimento value
     * @param string $ultimoVencimento
     * @return \StructType\ParcelaCalculoResponse
     */
    public function setUltimoVencimento($ultimoVencimento = null)
    {
        // validation for constraint: string
        if (!is_null($ultimoVencimento) && !is_string($ultimoVencimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ultimoVencimento, true), gettype($ultimoVencimento)), __LINE__);
        }
        $this->UltimoVencimento = $ultimoVencimento;
        return $this;
    }
    /**
     * Get ValorParcela value
     * @return float|null
     */
    public function getValorParcela()
    {
        return $this->ValorParcela;
    }
    /**
     * Set ValorParcela value
     * @param float $valorParcela
     * @return \StructType\ParcelaCalculoResponse
     */
    public function setValorParcela($valorParcela = null)
    {
        // validation for constraint: float
        if (!is_null($valorParcela) && !(is_float($valorParcela) || is_numeric($valorParcela))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorParcela, true), gettype($valorParcela)), __LINE__);
        }
        $this->ValorParcela = $valorParcela;
        return $this;
    }
    /**
     * Get ValorTaxaParcelamento value
     * @return float|null
     */
    public function getValorTaxaParcelamento()
    {
        return $this->ValorTaxaParcelamento;
    }
    /**
     * Set ValorTaxaParcelamento value
     * @param float $valorTaxaParcelamento
     * @return \StructType\ParcelaCalculoResponse
     */
    public function setValorTaxaParcelamento($valorTaxaParcelamento = null)
    {
        // validation for constraint: float
        if (!is_null($valorTaxaParcelamento) && !(is_float($valorTaxaParcelamento) || is_numeric($valorTaxaParcelamento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorTaxaParcelamento, true), gettype($valorTaxaParcelamento)), __LINE__);
        }
        $this->ValorTaxaParcelamento = $valorTaxaParcelamento;
        return $this;
    }
    /**
     * Get ValorTotalComDesconto value
     * @return float|null
     */
    public function getValorTotalComDesconto()
    {
        return $this->ValorTotalComDesconto;
    }
    /**
     * Set ValorTotalComDesconto value
     * @param float $valorTotalComDesconto
     * @return \StructType\ParcelaCalculoResponse
     */
    public function setValorTotalComDesconto($valorTotalComDesconto = null)
    {
        // validation for constraint: float
        if (!is_null($valorTotalComDesconto) && !(is_float($valorTotalComDesconto) || is_numeric($valorTotalComDesconto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorTotalComDesconto, true), gettype($valorTotalComDesconto)), __LINE__);
        }
        $this->ValorTotalComDesconto = $valorTotalComDesconto;
        return $this;
    }
    /**
     * Get ValorTotalProposta value
     * @return float|null
     */
    public function getValorTotalProposta()
    {
        return $this->ValorTotalProposta;
    }
    /**
     * Set ValorTotalProposta value
     * @param float $valorTotalProposta
     * @return \StructType\ParcelaCalculoResponse
     */
    public function setValorTotalProposta($valorTotalProposta = null)
    {
        // validation for constraint: float
        if (!is_null($valorTotalProposta) && !(is_float($valorTotalProposta) || is_numeric($valorTotalProposta))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorTotalProposta, true), gettype($valorTotalProposta)), __LINE__);
        }
        $this->ValorTotalProposta = $valorTotalProposta;
        return $this;
    }
    /**
     * Get ValorTotalSemDesconto value
     * @return float|null
     */
    public function getValorTotalSemDesconto()
    {
        return $this->ValorTotalSemDesconto;
    }
    /**
     * Set ValorTotalSemDesconto value
     * @param float $valorTotalSemDesconto
     * @return \StructType\ParcelaCalculoResponse
     */
    public function setValorTotalSemDesconto($valorTotalSemDesconto = null)
    {
        // validation for constraint: float
        if (!is_null($valorTotalSemDesconto) && !(is_float($valorTotalSemDesconto) || is_numeric($valorTotalSemDesconto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorTotalSemDesconto, true), gettype($valorTotalSemDesconto)), __LINE__);
        }
        $this->ValorTotalSemDesconto = $valorTotalSemDesconto;
        return $this;
    }
}
