<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PagarAcordo StructType
 * @subpackage Structs
 */
class PagarAcordo extends AbstractStructBase
{
    /**
     * The ChaveCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChaveCliente;
    /**
     * The Contrato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Contrato;
    /**
     * The FormaPagamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $FormaPagamento;
    /**
     * The Parcela
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Parcela;
    /**
     * The DataVencimento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataVencimento;
    /**
     * The ValorParcela
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorParcela;
    /**
     * The DataPagamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataPagamento;
    /**
     * The ValorPagamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorPagamento;
    /**
     * The NumeroAcordo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumeroAcordo;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * Constructor method for PagarAcordo
     * @uses PagarAcordo::setChaveCliente()
     * @uses PagarAcordo::setContrato()
     * @uses PagarAcordo::setFormaPagamento()
     * @uses PagarAcordo::setParcela()
     * @uses PagarAcordo::setDataVencimento()
     * @uses PagarAcordo::setValorParcela()
     * @uses PagarAcordo::setDataPagamento()
     * @uses PagarAcordo::setValorPagamento()
     * @uses PagarAcordo::setNumeroAcordo()
     * @uses PagarAcordo::setToken()
     * @param string $chaveCliente
     * @param string $contrato
     * @param string $formaPagamento
     * @param string $parcela
     * @param string $dataVencimento
     * @param float $valorParcela
     * @param string $dataPagamento
     * @param float $valorPagamento
     * @param string $numeroAcordo
     * @param string $token
     */
    public function __construct($chaveCliente = null, $contrato = null, $formaPagamento = null, $parcela = null, $dataVencimento = null, $valorParcela = null, $dataPagamento = null, $valorPagamento = null, $numeroAcordo = null, $token = null)
    {
        $this
            ->setChaveCliente($chaveCliente)
            ->setContrato($contrato)
            ->setFormaPagamento($formaPagamento)
            ->setParcela($parcela)
            ->setDataVencimento($dataVencimento)
            ->setValorParcela($valorParcela)
            ->setDataPagamento($dataPagamento)
            ->setValorPagamento($valorPagamento)
            ->setNumeroAcordo($numeroAcordo)
            ->setToken($token);
    }
    /**
     * Get ChaveCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChaveCliente()
    {
        return isset($this->ChaveCliente) ? $this->ChaveCliente : null;
    }
    /**
     * Set ChaveCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chaveCliente
     * @return \StructType\PagarAcordo
     */
    public function setChaveCliente($chaveCliente = null)
    {
        // validation for constraint: string
        if (!is_null($chaveCliente) && !is_string($chaveCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chaveCliente, true), gettype($chaveCliente)), __LINE__);
        }
        if (is_null($chaveCliente) || (is_array($chaveCliente) && empty($chaveCliente))) {
            unset($this->ChaveCliente);
        } else {
            $this->ChaveCliente = $chaveCliente;
        }
        return $this;
    }
    /**
     * Get Contrato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContrato()
    {
        return isset($this->Contrato) ? $this->Contrato : null;
    }
    /**
     * Set Contrato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contrato
     * @return \StructType\PagarAcordo
     */
    public function setContrato($contrato = null)
    {
        // validation for constraint: string
        if (!is_null($contrato) && !is_string($contrato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contrato, true), gettype($contrato)), __LINE__);
        }
        if (is_null($contrato) || (is_array($contrato) && empty($contrato))) {
            unset($this->Contrato);
        } else {
            $this->Contrato = $contrato;
        }
        return $this;
    }
    /**
     * Get FormaPagamento value
     * @return string|null
     */
    public function getFormaPagamento()
    {
        return $this->FormaPagamento;
    }
    /**
     * Set FormaPagamento value
     * @uses \EnumType\EnumFormaPagamento::valueIsValid()
     * @uses \EnumType\EnumFormaPagamento::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $formaPagamento
     * @return \StructType\PagarAcordo
     */
    public function setFormaPagamento($formaPagamento = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumFormaPagamento::valueIsValid($formaPagamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumFormaPagamento', is_array($formaPagamento) ? implode(', ', $formaPagamento) : var_export($formaPagamento, true), implode(', ', \EnumType\EnumFormaPagamento::getValidValues())), __LINE__);
        }
        $this->FormaPagamento = $formaPagamento;
        return $this;
    }
    /**
     * Get Parcela value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParcela()
    {
        return isset($this->Parcela) ? $this->Parcela : null;
    }
    /**
     * Set Parcela value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parcela
     * @return \StructType\PagarAcordo
     */
    public function setParcela($parcela = null)
    {
        // validation for constraint: string
        if (!is_null($parcela) && !is_string($parcela)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parcela, true), gettype($parcela)), __LINE__);
        }
        if (is_null($parcela) || (is_array($parcela) && empty($parcela))) {
            unset($this->Parcela);
        } else {
            $this->Parcela = $parcela;
        }
        return $this;
    }
    /**
     * Get DataVencimento value
     * @return string|null
     */
    public function getDataVencimento()
    {
        return $this->DataVencimento;
    }
    /**
     * Set DataVencimento value
     * @param string $dataVencimento
     * @return \StructType\PagarAcordo
     */
    public function setDataVencimento($dataVencimento = null)
    {
        // validation for constraint: string
        if (!is_null($dataVencimento) && !is_string($dataVencimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataVencimento, true), gettype($dataVencimento)), __LINE__);
        }
        $this->DataVencimento = $dataVencimento;
        return $this;
    }
    /**
     * Get ValorParcela value
     * @return float|null
     */
    public function getValorParcela()
    {
        return $this->ValorParcela;
    }
    /**
     * Set ValorParcela value
     * @param float $valorParcela
     * @return \StructType\PagarAcordo
     */
    public function setValorParcela($valorParcela = null)
    {
        // validation for constraint: float
        if (!is_null($valorParcela) && !(is_float($valorParcela) || is_numeric($valorParcela))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorParcela, true), gettype($valorParcela)), __LINE__);
        }
        $this->ValorParcela = $valorParcela;
        return $this;
    }
    /**
     * Get DataPagamento value
     * @return string|null
     */
    public function getDataPagamento()
    {
        return $this->DataPagamento;
    }
    /**
     * Set DataPagamento value
     * @param string $dataPagamento
     * @return \StructType\PagarAcordo
     */
    public function setDataPagamento($dataPagamento = null)
    {
        // validation for constraint: string
        if (!is_null($dataPagamento) && !is_string($dataPagamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataPagamento, true), gettype($dataPagamento)), __LINE__);
        }
        $this->DataPagamento = $dataPagamento;
        return $this;
    }
    /**
     * Get ValorPagamento value
     * @return float|null
     */
    public function getValorPagamento()
    {
        return $this->ValorPagamento;
    }
    /**
     * Set ValorPagamento value
     * @param float $valorPagamento
     * @return \StructType\PagarAcordo
     */
    public function setValorPagamento($valorPagamento = null)
    {
        // validation for constraint: float
        if (!is_null($valorPagamento) && !(is_float($valorPagamento) || is_numeric($valorPagamento))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorPagamento, true), gettype($valorPagamento)), __LINE__);
        }
        $this->ValorPagamento = $valorPagamento;
        return $this;
    }
    /**
     * Get NumeroAcordo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumeroAcordo()
    {
        return isset($this->NumeroAcordo) ? $this->NumeroAcordo : null;
    }
    /**
     * Set NumeroAcordo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numeroAcordo
     * @return \StructType\PagarAcordo
     */
    public function setNumeroAcordo($numeroAcordo = null)
    {
        // validation for constraint: string
        if (!is_null($numeroAcordo) && !is_string($numeroAcordo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroAcordo, true), gettype($numeroAcordo)), __LINE__);
        }
        if (is_null($numeroAcordo) || (is_array($numeroAcordo) && empty($numeroAcordo))) {
            unset($this->NumeroAcordo);
        } else {
            $this->NumeroAcordo = $numeroAcordo;
        }
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \StructType\PagarAcordo
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
}
