<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpcesParcelamentoType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OpcesParcelamentoType
 * @subpackage Structs
 */
class OpcesParcelamentoType extends AbstractStructBase
{
    /**
     * The ParcelaInicial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ParcelaInicial;
    /**
     * The ParcelaFinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ParcelaFinal;
    /**
     * The CampanhaDesconto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CampanhaDesconto
     */
    public $CampanhaDesconto;
    /**
     * Constructor method for OpcesParcelamentoType
     * @uses OpcesParcelamentoType::setParcelaInicial()
     * @uses OpcesParcelamentoType::setParcelaFinal()
     * @uses OpcesParcelamentoType::setCampanhaDesconto()
     * @param int $parcelaInicial
     * @param int $parcelaFinal
     * @param \StructType\CampanhaDesconto $campanhaDesconto
     */
    public function __construct($parcelaInicial = null, $parcelaFinal = null, \StructType\CampanhaDesconto $campanhaDesconto = null)
    {
        $this
            ->setParcelaInicial($parcelaInicial)
            ->setParcelaFinal($parcelaFinal)
            ->setCampanhaDesconto($campanhaDesconto);
    }
    /**
     * Get ParcelaInicial value
     * @return int|null
     */
    public function getParcelaInicial()
    {
        return $this->ParcelaInicial;
    }
    /**
     * Set ParcelaInicial value
     * @param int $parcelaInicial
     * @return \StructType\OpcesParcelamentoType
     */
    public function setParcelaInicial($parcelaInicial = null)
    {
        // validation for constraint: int
        if (!is_null($parcelaInicial) && !(is_int($parcelaInicial) || ctype_digit($parcelaInicial))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parcelaInicial, true), gettype($parcelaInicial)), __LINE__);
        }
        $this->ParcelaInicial = $parcelaInicial;
        return $this;
    }
    /**
     * Get ParcelaFinal value
     * @return int|null
     */
    public function getParcelaFinal()
    {
        return $this->ParcelaFinal;
    }
    /**
     * Set ParcelaFinal value
     * @param int $parcelaFinal
     * @return \StructType\OpcesParcelamentoType
     */
    public function setParcelaFinal($parcelaFinal = null)
    {
        // validation for constraint: int
        if (!is_null($parcelaFinal) && !(is_int($parcelaFinal) || ctype_digit($parcelaFinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($parcelaFinal, true), gettype($parcelaFinal)), __LINE__);
        }
        $this->ParcelaFinal = $parcelaFinal;
        return $this;
    }
    /**
     * Get CampanhaDesconto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CampanhaDesconto|null
     */
    public function getCampanhaDesconto()
    {
        return isset($this->CampanhaDesconto) ? $this->CampanhaDesconto : null;
    }
    /**
     * Set CampanhaDesconto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CampanhaDesconto $campanhaDesconto
     * @return \StructType\OpcesParcelamentoType
     */
    public function setCampanhaDesconto(\StructType\CampanhaDesconto $campanhaDesconto = null)
    {
        if (is_null($campanhaDesconto) || (is_array($campanhaDesconto) && empty($campanhaDesconto))) {
            unset($this->CampanhaDesconto);
        } else {
            $this->CampanhaDesconto = $campanhaDesconto;
        }
        return $this;
    }
}
