<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IncluirContrato StructType
 * @subpackage Structs
 */
class IncluirContrato extends AbstractStructBase
{
    /**
     * The ChaveCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChaveCliente;
    /**
     * The ContratosOriginais
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $ContratosOriginais;
    /**
     * The Contrato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ContratoRequest
     */
    public $Contrato;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * Constructor method for IncluirContrato
     * @uses IncluirContrato::setChaveCliente()
     * @uses IncluirContrato::setContratosOriginais()
     * @uses IncluirContrato::setContrato()
     * @uses IncluirContrato::setToken()
     * @param string $chaveCliente
     * @param \ArrayType\ArrayOfstring $contratosOriginais
     * @param \StructType\ContratoRequest $contrato
     * @param string $token
     */
    public function __construct($chaveCliente = null, \ArrayType\ArrayOfstring $contratosOriginais = null, \StructType\ContratoRequest $contrato = null, $token = null)
    {
        $this
            ->setChaveCliente($chaveCliente)
            ->setContratosOriginais($contratosOriginais)
            ->setContrato($contrato)
            ->setToken($token);
    }
    /**
     * Get ChaveCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChaveCliente()
    {
        return isset($this->ChaveCliente) ? $this->ChaveCliente : null;
    }
    /**
     * Set ChaveCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chaveCliente
     * @return \StructType\IncluirContrato
     */
    public function setChaveCliente($chaveCliente = null)
    {
        // validation for constraint: string
        if (!is_null($chaveCliente) && !is_string($chaveCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chaveCliente, true), gettype($chaveCliente)), __LINE__);
        }
        if (is_null($chaveCliente) || (is_array($chaveCliente) && empty($chaveCliente))) {
            unset($this->ChaveCliente);
        } else {
            $this->ChaveCliente = $chaveCliente;
        }
        return $this;
    }
    /**
     * Get ContratosOriginais value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getContratosOriginais()
    {
        return isset($this->ContratosOriginais) ? $this->ContratosOriginais : null;
    }
    /**
     * Set ContratosOriginais value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $contratosOriginais
     * @return \StructType\IncluirContrato
     */
    public function setContratosOriginais(\ArrayType\ArrayOfstring $contratosOriginais = null)
    {
        if (is_null($contratosOriginais) || (is_array($contratosOriginais) && empty($contratosOriginais))) {
            unset($this->ContratosOriginais);
        } else {
            $this->ContratosOriginais = $contratosOriginais;
        }
        return $this;
    }
    /**
     * Get Contrato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ContratoRequest|null
     */
    public function getContrato()
    {
        return isset($this->Contrato) ? $this->Contrato : null;
    }
    /**
     * Set Contrato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ContratoRequest $contrato
     * @return \StructType\IncluirContrato
     */
    public function setContrato(\StructType\ContratoRequest $contrato = null)
    {
        if (is_null($contrato) || (is_array($contrato) && empty($contrato))) {
            unset($this->Contrato);
        } else {
            $this->Contrato = $contrato;
        }
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \StructType\IncluirContrato
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
}
