<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IncluirBoletos StructType
 * @subpackage Structs
 */
class IncluirBoletos extends AbstractStructBase
{
    /**
     * The Banco
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Banco;
    /**
     * The Carteira
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Carteira;
    /**
     * The CodigoCedente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodigoCedente;
    /**
     * The Agencia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Agencia;
    /**
     * The ContaCorrente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContaCorrente;
    /**
     * The Boletos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBoletoRequest
     */
    public $Boletos;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * Constructor method for IncluirBoletos
     * @uses IncluirBoletos::setBanco()
     * @uses IncluirBoletos::setCarteira()
     * @uses IncluirBoletos::setCodigoCedente()
     * @uses IncluirBoletos::setAgencia()
     * @uses IncluirBoletos::setContaCorrente()
     * @uses IncluirBoletos::setBoletos()
     * @uses IncluirBoletos::setToken()
     * @param string $banco
     * @param string $carteira
     * @param string $codigoCedente
     * @param string $agencia
     * @param string $contaCorrente
     * @param \ArrayType\ArrayOfBoletoRequest $boletos
     * @param string $token
     */
    public function __construct($banco = null, $carteira = null, $codigoCedente = null, $agencia = null, $contaCorrente = null, \ArrayType\ArrayOfBoletoRequest $boletos = null, $token = null)
    {
        $this
            ->setBanco($banco)
            ->setCarteira($carteira)
            ->setCodigoCedente($codigoCedente)
            ->setAgencia($agencia)
            ->setContaCorrente($contaCorrente)
            ->setBoletos($boletos)
            ->setToken($token);
    }
    /**
     * Get Banco value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBanco()
    {
        return isset($this->Banco) ? $this->Banco : null;
    }
    /**
     * Set Banco value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $banco
     * @return \StructType\IncluirBoletos
     */
    public function setBanco($banco = null)
    {
        // validation for constraint: string
        if (!is_null($banco) && !is_string($banco)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($banco, true), gettype($banco)), __LINE__);
        }
        if (is_null($banco) || (is_array($banco) && empty($banco))) {
            unset($this->Banco);
        } else {
            $this->Banco = $banco;
        }
        return $this;
    }
    /**
     * Get Carteira value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCarteira()
    {
        return isset($this->Carteira) ? $this->Carteira : null;
    }
    /**
     * Set Carteira value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $carteira
     * @return \StructType\IncluirBoletos
     */
    public function setCarteira($carteira = null)
    {
        // validation for constraint: string
        if (!is_null($carteira) && !is_string($carteira)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($carteira, true), gettype($carteira)), __LINE__);
        }
        if (is_null($carteira) || (is_array($carteira) && empty($carteira))) {
            unset($this->Carteira);
        } else {
            $this->Carteira = $carteira;
        }
        return $this;
    }
    /**
     * Get CodigoCedente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodigoCedente()
    {
        return isset($this->CodigoCedente) ? $this->CodigoCedente : null;
    }
    /**
     * Set CodigoCedente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codigoCedente
     * @return \StructType\IncluirBoletos
     */
    public function setCodigoCedente($codigoCedente = null)
    {
        // validation for constraint: string
        if (!is_null($codigoCedente) && !is_string($codigoCedente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoCedente, true), gettype($codigoCedente)), __LINE__);
        }
        if (is_null($codigoCedente) || (is_array($codigoCedente) && empty($codigoCedente))) {
            unset($this->CodigoCedente);
        } else {
            $this->CodigoCedente = $codigoCedente;
        }
        return $this;
    }
    /**
     * Get Agencia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgencia()
    {
        return isset($this->Agencia) ? $this->Agencia : null;
    }
    /**
     * Set Agencia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agencia
     * @return \StructType\IncluirBoletos
     */
    public function setAgencia($agencia = null)
    {
        // validation for constraint: string
        if (!is_null($agencia) && !is_string($agencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencia, true), gettype($agencia)), __LINE__);
        }
        if (is_null($agencia) || (is_array($agencia) && empty($agencia))) {
            unset($this->Agencia);
        } else {
            $this->Agencia = $agencia;
        }
        return $this;
    }
    /**
     * Get ContaCorrente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContaCorrente()
    {
        return isset($this->ContaCorrente) ? $this->ContaCorrente : null;
    }
    /**
     * Set ContaCorrente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contaCorrente
     * @return \StructType\IncluirBoletos
     */
    public function setContaCorrente($contaCorrente = null)
    {
        // validation for constraint: string
        if (!is_null($contaCorrente) && !is_string($contaCorrente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contaCorrente, true), gettype($contaCorrente)), __LINE__);
        }
        if (is_null($contaCorrente) || (is_array($contaCorrente) && empty($contaCorrente))) {
            unset($this->ContaCorrente);
        } else {
            $this->ContaCorrente = $contaCorrente;
        }
        return $this;
    }
    /**
     * Get Boletos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBoletoRequest|null
     */
    public function getBoletos()
    {
        return isset($this->Boletos) ? $this->Boletos : null;
    }
    /**
     * Set Boletos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBoletoRequest $boletos
     * @return \StructType\IncluirBoletos
     */
    public function setBoletos(\ArrayType\ArrayOfBoletoRequest $boletos = null)
    {
        if (is_null($boletos) || (is_array($boletos) && empty($boletos))) {
            unset($this->Boletos);
        } else {
            $this->Boletos = $boletos;
        }
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \StructType\IncluirBoletos
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
}
