<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventoType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EventoType
 * @subpackage Structs
 */
class EventoType extends AbstractStructBase
{
    /**
     * The DataInclusao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataInclusao;
    /**
     * The Descricao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descricao;
    /**
     * The Operador
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Operador;
    /**
     * The TipoEvento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoEvento;
    /**
     * Constructor method for EventoType
     * @uses EventoType::setDataInclusao()
     * @uses EventoType::setDescricao()
     * @uses EventoType::setOperador()
     * @uses EventoType::setTipoEvento()
     * @param string $dataInclusao
     * @param string $descricao
     * @param string $operador
     * @param string $tipoEvento
     */
    public function __construct($dataInclusao = null, $descricao = null, $operador = null, $tipoEvento = null)
    {
        $this
            ->setDataInclusao($dataInclusao)
            ->setDescricao($descricao)
            ->setOperador($operador)
            ->setTipoEvento($tipoEvento);
    }
    /**
     * Get DataInclusao value
     * @return string|null
     */
    public function getDataInclusao()
    {
        return $this->DataInclusao;
    }
    /**
     * Set DataInclusao value
     * @param string $dataInclusao
     * @return \StructType\EventoType
     */
    public function setDataInclusao($dataInclusao = null)
    {
        // validation for constraint: string
        if (!is_null($dataInclusao) && !is_string($dataInclusao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataInclusao, true), gettype($dataInclusao)), __LINE__);
        }
        $this->DataInclusao = $dataInclusao;
        return $this;
    }
    /**
     * Get Descricao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescricao()
    {
        return isset($this->Descricao) ? $this->Descricao : null;
    }
    /**
     * Set Descricao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descricao
     * @return \StructType\EventoType
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricao, true), gettype($descricao)), __LINE__);
        }
        if (is_null($descricao) || (is_array($descricao) && empty($descricao))) {
            unset($this->Descricao);
        } else {
            $this->Descricao = $descricao;
        }
        return $this;
    }
    /**
     * Get Operador value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperador()
    {
        return isset($this->Operador) ? $this->Operador : null;
    }
    /**
     * Set Operador value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operador
     * @return \StructType\EventoType
     */
    public function setOperador($operador = null)
    {
        // validation for constraint: string
        if (!is_null($operador) && !is_string($operador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operador, true), gettype($operador)), __LINE__);
        }
        if (is_null($operador) || (is_array($operador) && empty($operador))) {
            unset($this->Operador);
        } else {
            $this->Operador = $operador;
        }
        return $this;
    }
    /**
     * Get TipoEvento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoEvento()
    {
        return isset($this->TipoEvento) ? $this->TipoEvento : null;
    }
    /**
     * Set TipoEvento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoEvento
     * @return \StructType\EventoType
     */
    public function setTipoEvento($tipoEvento = null)
    {
        // validation for constraint: string
        if (!is_null($tipoEvento) && !is_string($tipoEvento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoEvento, true), gettype($tipoEvento)), __LINE__);
        }
        if (is_null($tipoEvento) || (is_array($tipoEvento) && empty($tipoEvento))) {
            unset($this->TipoEvento);
        } else {
            $this->TipoEvento = $tipoEvento;
        }
        return $this;
    }
}
