<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmitirBoleto2ViaApi StructType
 * @subpackage Structs
 */
class EmitirBoleto2ViaApi extends AbstractStructBase
{
    /**
     * The IdBoleto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdBoleto;
    /**
     * The IdOperador
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdOperador;
    /**
     * The IdAssessoria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdAssessoria;
    /**
     * The IdCredor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdCredor;
    /**
     * The novoVenc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $novoVenc;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * Constructor method for EmitirBoleto2ViaApi
     * @uses EmitirBoleto2ViaApi::setIdBoleto()
     * @uses EmitirBoleto2ViaApi::setIdOperador()
     * @uses EmitirBoleto2ViaApi::setIdAssessoria()
     * @uses EmitirBoleto2ViaApi::setIdCredor()
     * @uses EmitirBoleto2ViaApi::setNovoVenc()
     * @uses EmitirBoleto2ViaApi::setToken()
     * @param int $idBoleto
     * @param int $idOperador
     * @param int $idAssessoria
     * @param int $idCredor
     * @param string $novoVenc
     * @param string $token
     */
    public function __construct($idBoleto = null, $idOperador = null, $idAssessoria = null, $idCredor = null, $novoVenc = null, $token = null)
    {
        $this
            ->setIdBoleto($idBoleto)
            ->setIdOperador($idOperador)
            ->setIdAssessoria($idAssessoria)
            ->setIdCredor($idCredor)
            ->setNovoVenc($novoVenc)
            ->setToken($token);
    }
    /**
     * Get IdBoleto value
     * @return int|null
     */
    public function getIdBoleto()
    {
        return $this->IdBoleto;
    }
    /**
     * Set IdBoleto value
     * @param int $idBoleto
     * @return \StructType\EmitirBoleto2ViaApi
     */
    public function setIdBoleto($idBoleto = null)
    {
        // validation for constraint: int
        if (!is_null($idBoleto) && !(is_int($idBoleto) || ctype_digit($idBoleto))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idBoleto, true), gettype($idBoleto)), __LINE__);
        }
        $this->IdBoleto = $idBoleto;
        return $this;
    }
    /**
     * Get IdOperador value
     * @return int|null
     */
    public function getIdOperador()
    {
        return $this->IdOperador;
    }
    /**
     * Set IdOperador value
     * @param int $idOperador
     * @return \StructType\EmitirBoleto2ViaApi
     */
    public function setIdOperador($idOperador = null)
    {
        // validation for constraint: int
        if (!is_null($idOperador) && !(is_int($idOperador) || ctype_digit($idOperador))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idOperador, true), gettype($idOperador)), __LINE__);
        }
        $this->IdOperador = $idOperador;
        return $this;
    }
    /**
     * Get IdAssessoria value
     * @return int|null
     */
    public function getIdAssessoria()
    {
        return $this->IdAssessoria;
    }
    /**
     * Set IdAssessoria value
     * @param int $idAssessoria
     * @return \StructType\EmitirBoleto2ViaApi
     */
    public function setIdAssessoria($idAssessoria = null)
    {
        // validation for constraint: int
        if (!is_null($idAssessoria) && !(is_int($idAssessoria) || ctype_digit($idAssessoria))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idAssessoria, true), gettype($idAssessoria)), __LINE__);
        }
        $this->IdAssessoria = $idAssessoria;
        return $this;
    }
    /**
     * Get IdCredor value
     * @return int|null
     */
    public function getIdCredor()
    {
        return $this->IdCredor;
    }
    /**
     * Set IdCredor value
     * @param int $idCredor
     * @return \StructType\EmitirBoleto2ViaApi
     */
    public function setIdCredor($idCredor = null)
    {
        // validation for constraint: int
        if (!is_null($idCredor) && !(is_int($idCredor) || ctype_digit($idCredor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idCredor, true), gettype($idCredor)), __LINE__);
        }
        $this->IdCredor = $idCredor;
        return $this;
    }
    /**
     * Get novoVenc value
     * @return string|null
     */
    public function getNovoVenc()
    {
        return $this->novoVenc;
    }
    /**
     * Set novoVenc value
     * @param string $novoVenc
     * @return \StructType\EmitirBoleto2ViaApi
     */
    public function setNovoVenc($novoVenc = null)
    {
        // validation for constraint: string
        if (!is_null($novoVenc) && !is_string($novoVenc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($novoVenc, true), gettype($novoVenc)), __LINE__);
        }
        $this->novoVenc = $novoVenc;
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \StructType\EmitirBoleto2ViaApi
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
}
