<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmissaoBoletoTypeUra StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EmissaoBoletoTypeUra
 * @subpackage Structs
 */
class EmissaoBoletoTypeUra extends AbstractStructBase
{
    /**
     * The RedirectUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RedirectUrl;
    /**
     * The UrlPdf
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UrlPdf;
    /**
     * The UrlPdfBase64
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UrlPdfBase64;
    /**
     * Constructor method for EmissaoBoletoTypeUra
     * @uses EmissaoBoletoTypeUra::setRedirectUrl()
     * @uses EmissaoBoletoTypeUra::setUrlPdf()
     * @uses EmissaoBoletoTypeUra::setUrlPdfBase64()
     * @param bool $redirectUrl
     * @param string $urlPdf
     * @param string $urlPdfBase64
     */
    public function __construct($redirectUrl = null, $urlPdf = null, $urlPdfBase64 = null)
    {
        $this
            ->setRedirectUrl($redirectUrl)
            ->setUrlPdf($urlPdf)
            ->setUrlPdfBase64($urlPdfBase64);
    }
    /**
     * Get RedirectUrl value
     * @return bool|null
     */
    public function getRedirectUrl()
    {
        return $this->RedirectUrl;
    }
    /**
     * Set RedirectUrl value
     * @param bool $redirectUrl
     * @return \StructType\EmissaoBoletoTypeUra
     */
    public function setRedirectUrl($redirectUrl = null)
    {
        // validation for constraint: boolean
        if (!is_null($redirectUrl) && !is_bool($redirectUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($redirectUrl, true), gettype($redirectUrl)), __LINE__);
        }
        $this->RedirectUrl = $redirectUrl;
        return $this;
    }
    /**
     * Get UrlPdf value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrlPdf()
    {
        return isset($this->UrlPdf) ? $this->UrlPdf : null;
    }
    /**
     * Set UrlPdf value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $urlPdf
     * @return \StructType\EmissaoBoletoTypeUra
     */
    public function setUrlPdf($urlPdf = null)
    {
        // validation for constraint: string
        if (!is_null($urlPdf) && !is_string($urlPdf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlPdf, true), gettype($urlPdf)), __LINE__);
        }
        if (is_null($urlPdf) || (is_array($urlPdf) && empty($urlPdf))) {
            unset($this->UrlPdf);
        } else {
            $this->UrlPdf = $urlPdf;
        }
        return $this;
    }
    /**
     * Get UrlPdfBase64 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrlPdfBase64()
    {
        return isset($this->UrlPdfBase64) ? $this->UrlPdfBase64 : null;
    }
    /**
     * Set UrlPdfBase64 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $urlPdfBase64
     * @return \StructType\EmissaoBoletoTypeUra
     */
    public function setUrlPdfBase64($urlPdfBase64 = null)
    {
        // validation for constraint: string
        if (!is_null($urlPdfBase64) && !is_string($urlPdfBase64)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlPdfBase64, true), gettype($urlPdfBase64)), __LINE__);
        }
        if (is_null($urlPdfBase64) || (is_array($urlPdfBase64) && empty($urlPdfBase64))) {
            unset($this->UrlPdfBase64);
        } else {
            $this->UrlPdfBase64 = $urlPdfBase64;
        }
        return $this;
    }
}
