<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DevolverContratoMotivo StructType
 * @subpackage Structs
 */
class DevolverContratoMotivo extends AbstractStructBase
{
    /**
     * The ChaveCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChaveCliente;
    /**
     * The Contrato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Contrato;
    /**
     * The DescricaoMotivo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DescricaoMotivo;
    /**
     * The Parcelas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfParcelaRequest
     */
    public $Parcelas;
    /**
     * The Observacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Observacao;
    /**
     * The DataDevolucao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataDevolucao;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * Constructor method for DevolverContratoMotivo
     * @uses DevolverContratoMotivo::setChaveCliente()
     * @uses DevolverContratoMotivo::setContrato()
     * @uses DevolverContratoMotivo::setDescricaoMotivo()
     * @uses DevolverContratoMotivo::setParcelas()
     * @uses DevolverContratoMotivo::setObservacao()
     * @uses DevolverContratoMotivo::setDataDevolucao()
     * @uses DevolverContratoMotivo::setToken()
     * @param string $chaveCliente
     * @param string $contrato
     * @param string $descricaoMotivo
     * @param \ArrayType\ArrayOfParcelaRequest $parcelas
     * @param string $observacao
     * @param string $dataDevolucao
     * @param string $token
     */
    public function __construct($chaveCliente = null, $contrato = null, $descricaoMotivo = null, \ArrayType\ArrayOfParcelaRequest $parcelas = null, $observacao = null, $dataDevolucao = null, $token = null)
    {
        $this
            ->setChaveCliente($chaveCliente)
            ->setContrato($contrato)
            ->setDescricaoMotivo($descricaoMotivo)
            ->setParcelas($parcelas)
            ->setObservacao($observacao)
            ->setDataDevolucao($dataDevolucao)
            ->setToken($token);
    }
    /**
     * Get ChaveCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChaveCliente()
    {
        return isset($this->ChaveCliente) ? $this->ChaveCliente : null;
    }
    /**
     * Set ChaveCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chaveCliente
     * @return \StructType\DevolverContratoMotivo
     */
    public function setChaveCliente($chaveCliente = null)
    {
        // validation for constraint: string
        if (!is_null($chaveCliente) && !is_string($chaveCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chaveCliente, true), gettype($chaveCliente)), __LINE__);
        }
        if (is_null($chaveCliente) || (is_array($chaveCliente) && empty($chaveCliente))) {
            unset($this->ChaveCliente);
        } else {
            $this->ChaveCliente = $chaveCliente;
        }
        return $this;
    }
    /**
     * Get Contrato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContrato()
    {
        return isset($this->Contrato) ? $this->Contrato : null;
    }
    /**
     * Set Contrato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contrato
     * @return \StructType\DevolverContratoMotivo
     */
    public function setContrato($contrato = null)
    {
        // validation for constraint: string
        if (!is_null($contrato) && !is_string($contrato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contrato, true), gettype($contrato)), __LINE__);
        }
        if (is_null($contrato) || (is_array($contrato) && empty($contrato))) {
            unset($this->Contrato);
        } else {
            $this->Contrato = $contrato;
        }
        return $this;
    }
    /**
     * Get DescricaoMotivo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescricaoMotivo()
    {
        return isset($this->DescricaoMotivo) ? $this->DescricaoMotivo : null;
    }
    /**
     * Set DescricaoMotivo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descricaoMotivo
     * @return \StructType\DevolverContratoMotivo
     */
    public function setDescricaoMotivo($descricaoMotivo = null)
    {
        // validation for constraint: string
        if (!is_null($descricaoMotivo) && !is_string($descricaoMotivo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricaoMotivo, true), gettype($descricaoMotivo)), __LINE__);
        }
        if (is_null($descricaoMotivo) || (is_array($descricaoMotivo) && empty($descricaoMotivo))) {
            unset($this->DescricaoMotivo);
        } else {
            $this->DescricaoMotivo = $descricaoMotivo;
        }
        return $this;
    }
    /**
     * Get Parcelas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfParcelaRequest|null
     */
    public function getParcelas()
    {
        return isset($this->Parcelas) ? $this->Parcelas : null;
    }
    /**
     * Set Parcelas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfParcelaRequest $parcelas
     * @return \StructType\DevolverContratoMotivo
     */
    public function setParcelas(\ArrayType\ArrayOfParcelaRequest $parcelas = null)
    {
        if (is_null($parcelas) || (is_array($parcelas) && empty($parcelas))) {
            unset($this->Parcelas);
        } else {
            $this->Parcelas = $parcelas;
        }
        return $this;
    }
    /**
     * Get Observacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObservacao()
    {
        return isset($this->Observacao) ? $this->Observacao : null;
    }
    /**
     * Set Observacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $observacao
     * @return \StructType\DevolverContratoMotivo
     */
    public function setObservacao($observacao = null)
    {
        // validation for constraint: string
        if (!is_null($observacao) && !is_string($observacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($observacao, true), gettype($observacao)), __LINE__);
        }
        if (is_null($observacao) || (is_array($observacao) && empty($observacao))) {
            unset($this->Observacao);
        } else {
            $this->Observacao = $observacao;
        }
        return $this;
    }
    /**
     * Get DataDevolucao value
     * @return string|null
     */
    public function getDataDevolucao()
    {
        return $this->DataDevolucao;
    }
    /**
     * Set DataDevolucao value
     * @param string $dataDevolucao
     * @return \StructType\DevolverContratoMotivo
     */
    public function setDataDevolucao($dataDevolucao = null)
    {
        // validation for constraint: string
        if (!is_null($dataDevolucao) && !is_string($dataDevolucao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataDevolucao, true), gettype($dataDevolucao)), __LINE__);
        }
        $this->DataDevolucao = $dataDevolucao;
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \StructType\DevolverContratoMotivo
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
}
