<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DadosPixTypePortal StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DadosPixTypePortal
 * @subpackage Structs
 */
class DadosPixTypePortal extends AbstractStructBase
{
    /**
     * The CPF
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CPF;
    /**
     * The Contratos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfContratoTypePix
     */
    public $Contratos;
    /**
     * The Despesas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Despesas;
    /**
     * The Endereco
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Endereco;
    /**
     * The Juros
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Juros;
    /**
     * The Multa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Multa;
    /**
     * The NomeCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NomeCliente;
    /**
     * The NumeroAcordo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumeroAcordo;
    /**
     * The PixConcluido
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $PixConcluido;
    /**
     * The Plano
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Plano;
    /**
     * The QrCodePix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QrCodePix;
    /**
     * The Recorrente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Recorrente;
    /**
     * The StatusAcordo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $StatusAcordo;
    /**
     * The Total
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Total;
    /**
     * The UrlPix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UrlPix;
    /**
     * The ValorPrimeiraParcela
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorPrimeiraParcela;
    /**
     * Constructor method for DadosPixTypePortal
     * @uses DadosPixTypePortal::setCPF()
     * @uses DadosPixTypePortal::setContratos()
     * @uses DadosPixTypePortal::setDespesas()
     * @uses DadosPixTypePortal::setEndereco()
     * @uses DadosPixTypePortal::setJuros()
     * @uses DadosPixTypePortal::setMulta()
     * @uses DadosPixTypePortal::setNomeCliente()
     * @uses DadosPixTypePortal::setNumeroAcordo()
     * @uses DadosPixTypePortal::setPixConcluido()
     * @uses DadosPixTypePortal::setPlano()
     * @uses DadosPixTypePortal::setQrCodePix()
     * @uses DadosPixTypePortal::setRecorrente()
     * @uses DadosPixTypePortal::setStatusAcordo()
     * @uses DadosPixTypePortal::setTotal()
     * @uses DadosPixTypePortal::setUrlPix()
     * @uses DadosPixTypePortal::setValorPrimeiraParcela()
     * @param string $cPF
     * @param \ArrayType\ArrayOfContratoTypePix $contratos
     * @param float $despesas
     * @param string $endereco
     * @param float $juros
     * @param float $multa
     * @param string $nomeCliente
     * @param string $numeroAcordo
     * @param bool $pixConcluido
     * @param int $plano
     * @param string $qrCodePix
     * @param bool $recorrente
     * @param int $statusAcordo
     * @param float $total
     * @param string $urlPix
     * @param float $valorPrimeiraParcela
     */
    public function __construct($cPF = null, \ArrayType\ArrayOfContratoTypePix $contratos = null, $despesas = null, $endereco = null, $juros = null, $multa = null, $nomeCliente = null, $numeroAcordo = null, $pixConcluido = null, $plano = null, $qrCodePix = null, $recorrente = null, $statusAcordo = null, $total = null, $urlPix = null, $valorPrimeiraParcela = null)
    {
        $this
            ->setCPF($cPF)
            ->setContratos($contratos)
            ->setDespesas($despesas)
            ->setEndereco($endereco)
            ->setJuros($juros)
            ->setMulta($multa)
            ->setNomeCliente($nomeCliente)
            ->setNumeroAcordo($numeroAcordo)
            ->setPixConcluido($pixConcluido)
            ->setPlano($plano)
            ->setQrCodePix($qrCodePix)
            ->setRecorrente($recorrente)
            ->setStatusAcordo($statusAcordo)
            ->setTotal($total)
            ->setUrlPix($urlPix)
            ->setValorPrimeiraParcela($valorPrimeiraParcela);
    }
    /**
     * Get CPF value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCPF()
    {
        return isset($this->CPF) ? $this->CPF : null;
    }
    /**
     * Set CPF value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cPF
     * @return \StructType\DadosPixTypePortal
     */
    public function setCPF($cPF = null)
    {
        // validation for constraint: string
        if (!is_null($cPF) && !is_string($cPF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cPF, true), gettype($cPF)), __LINE__);
        }
        if (is_null($cPF) || (is_array($cPF) && empty($cPF))) {
            unset($this->CPF);
        } else {
            $this->CPF = $cPF;
        }
        return $this;
    }
    /**
     * Get Contratos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfContratoTypePix|null
     */
    public function getContratos()
    {
        return isset($this->Contratos) ? $this->Contratos : null;
    }
    /**
     * Set Contratos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfContratoTypePix $contratos
     * @return \StructType\DadosPixTypePortal
     */
    public function setContratos(\ArrayType\ArrayOfContratoTypePix $contratos = null)
    {
        if (is_null($contratos) || (is_array($contratos) && empty($contratos))) {
            unset($this->Contratos);
        } else {
            $this->Contratos = $contratos;
        }
        return $this;
    }
    /**
     * Get Despesas value
     * @return float|null
     */
    public function getDespesas()
    {
        return $this->Despesas;
    }
    /**
     * Set Despesas value
     * @param float $despesas
     * @return \StructType\DadosPixTypePortal
     */
    public function setDespesas($despesas = null)
    {
        // validation for constraint: float
        if (!is_null($despesas) && !(is_float($despesas) || is_numeric($despesas))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($despesas, true), gettype($despesas)), __LINE__);
        }
        $this->Despesas = $despesas;
        return $this;
    }
    /**
     * Get Endereco value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndereco()
    {
        return isset($this->Endereco) ? $this->Endereco : null;
    }
    /**
     * Set Endereco value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endereco
     * @return \StructType\DadosPixTypePortal
     */
    public function setEndereco($endereco = null)
    {
        // validation for constraint: string
        if (!is_null($endereco) && !is_string($endereco)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endereco, true), gettype($endereco)), __LINE__);
        }
        if (is_null($endereco) || (is_array($endereco) && empty($endereco))) {
            unset($this->Endereco);
        } else {
            $this->Endereco = $endereco;
        }
        return $this;
    }
    /**
     * Get Juros value
     * @return float|null
     */
    public function getJuros()
    {
        return $this->Juros;
    }
    /**
     * Set Juros value
     * @param float $juros
     * @return \StructType\DadosPixTypePortal
     */
    public function setJuros($juros = null)
    {
        // validation for constraint: float
        if (!is_null($juros) && !(is_float($juros) || is_numeric($juros))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($juros, true), gettype($juros)), __LINE__);
        }
        $this->Juros = $juros;
        return $this;
    }
    /**
     * Get Multa value
     * @return float|null
     */
    public function getMulta()
    {
        return $this->Multa;
    }
    /**
     * Set Multa value
     * @param float $multa
     * @return \StructType\DadosPixTypePortal
     */
    public function setMulta($multa = null)
    {
        // validation for constraint: float
        if (!is_null($multa) && !(is_float($multa) || is_numeric($multa))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($multa, true), gettype($multa)), __LINE__);
        }
        $this->Multa = $multa;
        return $this;
    }
    /**
     * Get NomeCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNomeCliente()
    {
        return isset($this->NomeCliente) ? $this->NomeCliente : null;
    }
    /**
     * Set NomeCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nomeCliente
     * @return \StructType\DadosPixTypePortal
     */
    public function setNomeCliente($nomeCliente = null)
    {
        // validation for constraint: string
        if (!is_null($nomeCliente) && !is_string($nomeCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeCliente, true), gettype($nomeCliente)), __LINE__);
        }
        if (is_null($nomeCliente) || (is_array($nomeCliente) && empty($nomeCliente))) {
            unset($this->NomeCliente);
        } else {
            $this->NomeCliente = $nomeCliente;
        }
        return $this;
    }
    /**
     * Get NumeroAcordo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumeroAcordo()
    {
        return isset($this->NumeroAcordo) ? $this->NumeroAcordo : null;
    }
    /**
     * Set NumeroAcordo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numeroAcordo
     * @return \StructType\DadosPixTypePortal
     */
    public function setNumeroAcordo($numeroAcordo = null)
    {
        // validation for constraint: string
        if (!is_null($numeroAcordo) && !is_string($numeroAcordo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroAcordo, true), gettype($numeroAcordo)), __LINE__);
        }
        if (is_null($numeroAcordo) || (is_array($numeroAcordo) && empty($numeroAcordo))) {
            unset($this->NumeroAcordo);
        } else {
            $this->NumeroAcordo = $numeroAcordo;
        }
        return $this;
    }
    /**
     * Get PixConcluido value
     * @return bool|null
     */
    public function getPixConcluido()
    {
        return $this->PixConcluido;
    }
    /**
     * Set PixConcluido value
     * @param bool $pixConcluido
     * @return \StructType\DadosPixTypePortal
     */
    public function setPixConcluido($pixConcluido = null)
    {
        // validation for constraint: boolean
        if (!is_null($pixConcluido) && !is_bool($pixConcluido)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($pixConcluido, true), gettype($pixConcluido)), __LINE__);
        }
        $this->PixConcluido = $pixConcluido;
        return $this;
    }
    /**
     * Get Plano value
     * @return int|null
     */
    public function getPlano()
    {
        return $this->Plano;
    }
    /**
     * Set Plano value
     * @param int $plano
     * @return \StructType\DadosPixTypePortal
     */
    public function setPlano($plano = null)
    {
        // validation for constraint: int
        if (!is_null($plano) && !(is_int($plano) || ctype_digit($plano))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($plano, true), gettype($plano)), __LINE__);
        }
        $this->Plano = $plano;
        return $this;
    }
    /**
     * Get QrCodePix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQrCodePix()
    {
        return isset($this->QrCodePix) ? $this->QrCodePix : null;
    }
    /**
     * Set QrCodePix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $qrCodePix
     * @return \StructType\DadosPixTypePortal
     */
    public function setQrCodePix($qrCodePix = null)
    {
        // validation for constraint: string
        if (!is_null($qrCodePix) && !is_string($qrCodePix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qrCodePix, true), gettype($qrCodePix)), __LINE__);
        }
        if (is_null($qrCodePix) || (is_array($qrCodePix) && empty($qrCodePix))) {
            unset($this->QrCodePix);
        } else {
            $this->QrCodePix = $qrCodePix;
        }
        return $this;
    }
    /**
     * Get Recorrente value
     * @return bool|null
     */
    public function getRecorrente()
    {
        return $this->Recorrente;
    }
    /**
     * Set Recorrente value
     * @param bool $recorrente
     * @return \StructType\DadosPixTypePortal
     */
    public function setRecorrente($recorrente = null)
    {
        // validation for constraint: boolean
        if (!is_null($recorrente) && !is_bool($recorrente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($recorrente, true), gettype($recorrente)), __LINE__);
        }
        $this->Recorrente = $recorrente;
        return $this;
    }
    /**
     * Get StatusAcordo value
     * @return int|null
     */
    public function getStatusAcordo()
    {
        return $this->StatusAcordo;
    }
    /**
     * Set StatusAcordo value
     * @param int $statusAcordo
     * @return \StructType\DadosPixTypePortal
     */
    public function setStatusAcordo($statusAcordo = null)
    {
        // validation for constraint: int
        if (!is_null($statusAcordo) && !(is_int($statusAcordo) || ctype_digit($statusAcordo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($statusAcordo, true), gettype($statusAcordo)), __LINE__);
        }
        $this->StatusAcordo = $statusAcordo;
        return $this;
    }
    /**
     * Get Total value
     * @return float|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param float $total
     * @return \StructType\DadosPixTypePortal
     */
    public function setTotal($total = null)
    {
        // validation for constraint: float
        if (!is_null($total) && !(is_float($total) || is_numeric($total))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($total, true), gettype($total)), __LINE__);
        }
        $this->Total = $total;
        return $this;
    }
    /**
     * Get UrlPix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrlPix()
    {
        return isset($this->UrlPix) ? $this->UrlPix : null;
    }
    /**
     * Set UrlPix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $urlPix
     * @return \StructType\DadosPixTypePortal
     */
    public function setUrlPix($urlPix = null)
    {
        // validation for constraint: string
        if (!is_null($urlPix) && !is_string($urlPix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($urlPix, true), gettype($urlPix)), __LINE__);
        }
        if (is_null($urlPix) || (is_array($urlPix) && empty($urlPix))) {
            unset($this->UrlPix);
        } else {
            $this->UrlPix = $urlPix;
        }
        return $this;
    }
    /**
     * Get ValorPrimeiraParcela value
     * @return float|null
     */
    public function getValorPrimeiraParcela()
    {
        return $this->ValorPrimeiraParcela;
    }
    /**
     * Set ValorPrimeiraParcela value
     * @param float $valorPrimeiraParcela
     * @return \StructType\DadosPixTypePortal
     */
    public function setValorPrimeiraParcela($valorPrimeiraParcela = null)
    {
        // validation for constraint: float
        if (!is_null($valorPrimeiraParcela) && !(is_float($valorPrimeiraParcela) || is_numeric($valorPrimeiraParcela))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorPrimeiraParcela, true), gettype($valorPrimeiraParcela)), __LINE__);
        }
        $this->ValorPrimeiraParcela = $valorPrimeiraParcela;
        return $this;
    }
}
