<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DadosPixType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DadosPixType
 * @subpackage Structs
 */
class DadosPixType extends AbstractStructBase
{
    /**
     * The Ativo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Ativo;
    /**
     * The Mensagem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Mensagem;
    /**
     * The PixCopiaCola
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PixCopiaCola;
    /**
     * The QrCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $QrCode;
    /**
     * The Valor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Valor;
    /**
     * The Vencimento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Vencimento;
    /**
     * Constructor method for DadosPixType
     * @uses DadosPixType::setAtivo()
     * @uses DadosPixType::setMensagem()
     * @uses DadosPixType::setPixCopiaCola()
     * @uses DadosPixType::setQrCode()
     * @uses DadosPixType::setValor()
     * @uses DadosPixType::setVencimento()
     * @param bool $ativo
     * @param string $mensagem
     * @param string $pixCopiaCola
     * @param string $qrCode
     * @param float $valor
     * @param string $vencimento
     */
    public function __construct($ativo = null, $mensagem = null, $pixCopiaCola = null, $qrCode = null, $valor = null, $vencimento = null)
    {
        $this
            ->setAtivo($ativo)
            ->setMensagem($mensagem)
            ->setPixCopiaCola($pixCopiaCola)
            ->setQrCode($qrCode)
            ->setValor($valor)
            ->setVencimento($vencimento);
    }
    /**
     * Get Ativo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAtivo()
    {
        return isset($this->Ativo) ? $this->Ativo : null;
    }
    /**
     * Set Ativo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $ativo
     * @return \StructType\DadosPixType
     */
    public function setAtivo($ativo = null)
    {
        // validation for constraint: boolean
        if (!is_null($ativo) && !is_bool($ativo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($ativo, true), gettype($ativo)), __LINE__);
        }
        if (is_null($ativo) || (is_array($ativo) && empty($ativo))) {
            unset($this->Ativo);
        } else {
            $this->Ativo = $ativo;
        }
        return $this;
    }
    /**
     * Get Mensagem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMensagem()
    {
        return isset($this->Mensagem) ? $this->Mensagem : null;
    }
    /**
     * Set Mensagem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mensagem
     * @return \StructType\DadosPixType
     */
    public function setMensagem($mensagem = null)
    {
        // validation for constraint: string
        if (!is_null($mensagem) && !is_string($mensagem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mensagem, true), gettype($mensagem)), __LINE__);
        }
        if (is_null($mensagem) || (is_array($mensagem) && empty($mensagem))) {
            unset($this->Mensagem);
        } else {
            $this->Mensagem = $mensagem;
        }
        return $this;
    }
    /**
     * Get PixCopiaCola value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPixCopiaCola()
    {
        return isset($this->PixCopiaCola) ? $this->PixCopiaCola : null;
    }
    /**
     * Set PixCopiaCola value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pixCopiaCola
     * @return \StructType\DadosPixType
     */
    public function setPixCopiaCola($pixCopiaCola = null)
    {
        // validation for constraint: string
        if (!is_null($pixCopiaCola) && !is_string($pixCopiaCola)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pixCopiaCola, true), gettype($pixCopiaCola)), __LINE__);
        }
        if (is_null($pixCopiaCola) || (is_array($pixCopiaCola) && empty($pixCopiaCola))) {
            unset($this->PixCopiaCola);
        } else {
            $this->PixCopiaCola = $pixCopiaCola;
        }
        return $this;
    }
    /**
     * Get QrCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQrCode()
    {
        return isset($this->QrCode) ? $this->QrCode : null;
    }
    /**
     * Set QrCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $qrCode
     * @return \StructType\DadosPixType
     */
    public function setQrCode($qrCode = null)
    {
        // validation for constraint: string
        if (!is_null($qrCode) && !is_string($qrCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($qrCode, true), gettype($qrCode)), __LINE__);
        }
        if (is_null($qrCode) || (is_array($qrCode) && empty($qrCode))) {
            unset($this->QrCode);
        } else {
            $this->QrCode = $qrCode;
        }
        return $this;
    }
    /**
     * Get Valor value
     * @return float|null
     */
    public function getValor()
    {
        return $this->Valor;
    }
    /**
     * Set Valor value
     * @param float $valor
     * @return \StructType\DadosPixType
     */
    public function setValor($valor = null)
    {
        // validation for constraint: float
        if (!is_null($valor) && !(is_float($valor) || is_numeric($valor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->Valor = $valor;
        return $this;
    }
    /**
     * Get Vencimento value
     * @return string|null
     */
    public function getVencimento()
    {
        return $this->Vencimento;
    }
    /**
     * Set Vencimento value
     * @param string $vencimento
     * @return \StructType\DadosPixType
     */
    public function setVencimento($vencimento = null)
    {
        // validation for constraint: string
        if (!is_null($vencimento) && !is_string($vencimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vencimento, true), gettype($vencimento)), __LINE__);
        }
        $this->Vencimento = $vencimento;
        return $this;
    }
}
