<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DadosClienteResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:DadosClienteResponse
 * @subpackage Structs
 */
class DadosClienteResponse extends ClienteType
{
    /**
     * The CpfCnpj
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CpfCnpj;
    /**
     * The Credores
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCredorType
     */
    public $Credores;
    /**
     * The Emails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfEmailResponse
     */
    public $Emails;
    /**
     * The Enderecos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfEnderecoResponse
     */
    public $Enderecos;
    /**
     * The IdCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdCliente;
    /**
     * The IdProtocolo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdProtocolo;
    /**
     * The NomeCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NomeCliente;
    /**
     * The Protocolo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Protocolo;
    /**
     * The Telefones
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTelefoneResponse
     */
    public $Telefones;
    /**
     * The TipoPessoa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TipoPessoa;
    /**
     * Constructor method for DadosClienteResponse
     * @uses DadosClienteResponse::setCpfCnpj()
     * @uses DadosClienteResponse::setCredores()
     * @uses DadosClienteResponse::setEmails()
     * @uses DadosClienteResponse::setEnderecos()
     * @uses DadosClienteResponse::setIdCliente()
     * @uses DadosClienteResponse::setIdProtocolo()
     * @uses DadosClienteResponse::setNomeCliente()
     * @uses DadosClienteResponse::setProtocolo()
     * @uses DadosClienteResponse::setTelefones()
     * @uses DadosClienteResponse::setTipoPessoa()
     * @param string $cpfCnpj
     * @param \ArrayType\ArrayOfCredorType $credores
     * @param \ArrayType\ArrayOfEmailResponse $emails
     * @param \ArrayType\ArrayOfEnderecoResponse $enderecos
     * @param int $idCliente
     * @param int $idProtocolo
     * @param string $nomeCliente
     * @param string $protocolo
     * @param \ArrayType\ArrayOfTelefoneResponse $telefones
     * @param string $tipoPessoa
     */
    public function __construct($cpfCnpj = null, \ArrayType\ArrayOfCredorType $credores = null, \ArrayType\ArrayOfEmailResponse $emails = null, \ArrayType\ArrayOfEnderecoResponse $enderecos = null, $idCliente = null, $idProtocolo = null, $nomeCliente = null, $protocolo = null, \ArrayType\ArrayOfTelefoneResponse $telefones = null, $tipoPessoa = null)
    {
        $this
            ->setCpfCnpj($cpfCnpj)
            ->setCredores($credores)
            ->setEmails($emails)
            ->setEnderecos($enderecos)
            ->setIdCliente($idCliente)
            ->setIdProtocolo($idProtocolo)
            ->setNomeCliente($nomeCliente)
            ->setProtocolo($protocolo)
            ->setTelefones($telefones)
            ->setTipoPessoa($tipoPessoa);
    }
    /**
     * Get CpfCnpj value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpfCnpj()
    {
        return isset($this->CpfCnpj) ? $this->CpfCnpj : null;
    }
    /**
     * Set CpfCnpj value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpfCnpj
     * @return \StructType\DadosClienteResponse
     */
    public function setCpfCnpj($cpfCnpj = null)
    {
        // validation for constraint: string
        if (!is_null($cpfCnpj) && !is_string($cpfCnpj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpfCnpj, true), gettype($cpfCnpj)), __LINE__);
        }
        if (is_null($cpfCnpj) || (is_array($cpfCnpj) && empty($cpfCnpj))) {
            unset($this->CpfCnpj);
        } else {
            $this->CpfCnpj = $cpfCnpj;
        }
        return $this;
    }
    /**
     * Get Credores value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCredorType|null
     */
    public function getCredores()
    {
        return isset($this->Credores) ? $this->Credores : null;
    }
    /**
     * Set Credores value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCredorType $credores
     * @return \StructType\DadosClienteResponse
     */
    public function setCredores(\ArrayType\ArrayOfCredorType $credores = null)
    {
        if (is_null($credores) || (is_array($credores) && empty($credores))) {
            unset($this->Credores);
        } else {
            $this->Credores = $credores;
        }
        return $this;
    }
    /**
     * Get Emails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfEmailResponse|null
     */
    public function getEmails()
    {
        return isset($this->Emails) ? $this->Emails : null;
    }
    /**
     * Set Emails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfEmailResponse $emails
     * @return \StructType\DadosClienteResponse
     */
    public function setEmails(\ArrayType\ArrayOfEmailResponse $emails = null)
    {
        if (is_null($emails) || (is_array($emails) && empty($emails))) {
            unset($this->Emails);
        } else {
            $this->Emails = $emails;
        }
        return $this;
    }
    /**
     * Get Enderecos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfEnderecoResponse|null
     */
    public function getEnderecos()
    {
        return isset($this->Enderecos) ? $this->Enderecos : null;
    }
    /**
     * Set Enderecos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfEnderecoResponse $enderecos
     * @return \StructType\DadosClienteResponse
     */
    public function setEnderecos(\ArrayType\ArrayOfEnderecoResponse $enderecos = null)
    {
        if (is_null($enderecos) || (is_array($enderecos) && empty($enderecos))) {
            unset($this->Enderecos);
        } else {
            $this->Enderecos = $enderecos;
        }
        return $this;
    }
    /**
     * Get IdCliente value
     * @return int|null
     */
    public function getIdCliente()
    {
        return $this->IdCliente;
    }
    /**
     * Set IdCliente value
     * @param int $idCliente
     * @return \StructType\DadosClienteResponse
     */
    public function setIdCliente($idCliente = null)
    {
        // validation for constraint: int
        if (!is_null($idCliente) && !(is_int($idCliente) || ctype_digit($idCliente))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idCliente, true), gettype($idCliente)), __LINE__);
        }
        $this->IdCliente = $idCliente;
        return $this;
    }
    /**
     * Get IdProtocolo value
     * @return int|null
     */
    public function getIdProtocolo()
    {
        return $this->IdProtocolo;
    }
    /**
     * Set IdProtocolo value
     * @param int $idProtocolo
     * @return \StructType\DadosClienteResponse
     */
    public function setIdProtocolo($idProtocolo = null)
    {
        // validation for constraint: int
        if (!is_null($idProtocolo) && !(is_int($idProtocolo) || ctype_digit($idProtocolo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idProtocolo, true), gettype($idProtocolo)), __LINE__);
        }
        $this->IdProtocolo = $idProtocolo;
        return $this;
    }
    /**
     * Get NomeCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNomeCliente()
    {
        return isset($this->NomeCliente) ? $this->NomeCliente : null;
    }
    /**
     * Set NomeCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nomeCliente
     * @return \StructType\DadosClienteResponse
     */
    public function setNomeCliente($nomeCliente = null)
    {
        // validation for constraint: string
        if (!is_null($nomeCliente) && !is_string($nomeCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeCliente, true), gettype($nomeCliente)), __LINE__);
        }
        if (is_null($nomeCliente) || (is_array($nomeCliente) && empty($nomeCliente))) {
            unset($this->NomeCliente);
        } else {
            $this->NomeCliente = $nomeCliente;
        }
        return $this;
    }
    /**
     * Get Protocolo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProtocolo()
    {
        return isset($this->Protocolo) ? $this->Protocolo : null;
    }
    /**
     * Set Protocolo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $protocolo
     * @return \StructType\DadosClienteResponse
     */
    public function setProtocolo($protocolo = null)
    {
        // validation for constraint: string
        if (!is_null($protocolo) && !is_string($protocolo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($protocolo, true), gettype($protocolo)), __LINE__);
        }
        if (is_null($protocolo) || (is_array($protocolo) && empty($protocolo))) {
            unset($this->Protocolo);
        } else {
            $this->Protocolo = $protocolo;
        }
        return $this;
    }
    /**
     * Get Telefones value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTelefoneResponse|null
     */
    public function getTelefones()
    {
        return isset($this->Telefones) ? $this->Telefones : null;
    }
    /**
     * Set Telefones value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTelefoneResponse $telefones
     * @return \StructType\DadosClienteResponse
     */
    public function setTelefones(\ArrayType\ArrayOfTelefoneResponse $telefones = null)
    {
        if (is_null($telefones) || (is_array($telefones) && empty($telefones))) {
            unset($this->Telefones);
        } else {
            $this->Telefones = $telefones;
        }
        return $this;
    }
    /**
     * Get TipoPessoa value
     * @return string|null
     */
    public function getTipoPessoa()
    {
        return $this->TipoPessoa;
    }
    /**
     * Set TipoPessoa value
     * @uses \EnumType\EnumTipoPessoa::valueIsValid()
     * @uses \EnumType\EnumTipoPessoa::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoPessoa
     * @return \StructType\DadosClienteResponse
     */
    public function setTipoPessoa($tipoPessoa = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTipoPessoa::valueIsValid($tipoPessoa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumTipoPessoa', is_array($tipoPessoa) ? implode(', ', $tipoPessoa) : var_export($tipoPessoa, true), implode(', ', \EnumType\EnumTipoPessoa::getValidValues())), __LINE__);
        }
        $this->TipoPessoa = $tipoPessoa;
        return $this;
    }
}
