<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CredorContratoResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CredorContratoResponse
 * @subpackage Structs
 */
class CredorContratoResponse extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Id;
    /**
     * The Nome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Nome;
    /**
     * Constructor method for CredorContratoResponse
     * @uses CredorContratoResponse::setId()
     * @uses CredorContratoResponse::setNome()
     * @param int $id
     * @param string $nome
     */
    public function __construct($id = null, $nome = null)
    {
        $this
            ->setId($id)
            ->setNome($nome);
    }
    /**
     * Get Id value
     * @return int|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param int $id
     * @return \StructType\CredorContratoResponse
     */
    public function setId($id = null)
    {
        // validation for constraint: int
        if (!is_null($id) && !(is_int($id) || ctype_digit($id))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Nome value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNome()
    {
        return isset($this->Nome) ? $this->Nome : null;
    }
    /**
     * Set Nome value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nome
     * @return \StructType\CredorContratoResponse
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        if (is_null($nome) || (is_array($nome) && empty($nome))) {
            unset($this->Nome);
        } else {
            $this->Nome = $nome;
        }
        return $this;
    }
}
