<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContratosDistribuidosResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ContratosDistribuidosResponse
 * @subpackage Structs
 */
class ContratosDistribuidosResponse extends AbstractStructBase
{
    /**
     * The Assessoria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Assessoria;
    /**
     * The CPFCNPJ
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CPFCNPJ;
    /**
     * The Cliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Cliente;
    /**
     * The CodigoAssessoria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodigoAssessoria;
    /**
     * The Contrato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Contrato;
    /**
     * The ContratosDistribuidosResult
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfContratosDistribuidosResponse
     */
    public $ContratosDistribuidosResult;
    /**
     * Constructor method for ContratosDistribuidosResponse
     * @uses ContratosDistribuidosResponse::setAssessoria()
     * @uses ContratosDistribuidosResponse::setCPFCNPJ()
     * @uses ContratosDistribuidosResponse::setCliente()
     * @uses ContratosDistribuidosResponse::setCodigoAssessoria()
     * @uses ContratosDistribuidosResponse::setContrato()
     * @uses ContratosDistribuidosResponse::setContratosDistribuidosResult()
     * @param string $assessoria
     * @param string $cPFCNPJ
     * @param string $cliente
     * @param string $codigoAssessoria
     * @param string $contrato
     * @param \ArrayType\ArrayOfContratosDistribuidosResponse $contratosDistribuidosResult
     */
    public function __construct($assessoria = null, $cPFCNPJ = null, $cliente = null, $codigoAssessoria = null, $contrato = null, \ArrayType\ArrayOfContratosDistribuidosResponse $contratosDistribuidosResult = null)
    {
        $this
            ->setAssessoria($assessoria)
            ->setCPFCNPJ($cPFCNPJ)
            ->setCliente($cliente)
            ->setCodigoAssessoria($codigoAssessoria)
            ->setContrato($contrato)
            ->setContratosDistribuidosResult($contratosDistribuidosResult);
    }
    /**
     * Get Assessoria value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssessoria()
    {
        return isset($this->Assessoria) ? $this->Assessoria : null;
    }
    /**
     * Set Assessoria value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assessoria
     * @return \StructType\ContratosDistribuidosResponse
     */
    public function setAssessoria($assessoria = null)
    {
        // validation for constraint: string
        if (!is_null($assessoria) && !is_string($assessoria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assessoria, true), gettype($assessoria)), __LINE__);
        }
        if (is_null($assessoria) || (is_array($assessoria) && empty($assessoria))) {
            unset($this->Assessoria);
        } else {
            $this->Assessoria = $assessoria;
        }
        return $this;
    }
    /**
     * Get CPFCNPJ value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCPFCNPJ()
    {
        return isset($this->CPFCNPJ) ? $this->CPFCNPJ : null;
    }
    /**
     * Set CPFCNPJ value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cPFCNPJ
     * @return \StructType\ContratosDistribuidosResponse
     */
    public function setCPFCNPJ($cPFCNPJ = null)
    {
        // validation for constraint: string
        if (!is_null($cPFCNPJ) && !is_string($cPFCNPJ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cPFCNPJ, true), gettype($cPFCNPJ)), __LINE__);
        }
        if (is_null($cPFCNPJ) || (is_array($cPFCNPJ) && empty($cPFCNPJ))) {
            unset($this->CPFCNPJ);
        } else {
            $this->CPFCNPJ = $cPFCNPJ;
        }
        return $this;
    }
    /**
     * Get Cliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCliente()
    {
        return isset($this->Cliente) ? $this->Cliente : null;
    }
    /**
     * Set Cliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cliente
     * @return \StructType\ContratosDistribuidosResponse
     */
    public function setCliente($cliente = null)
    {
        // validation for constraint: string
        if (!is_null($cliente) && !is_string($cliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cliente, true), gettype($cliente)), __LINE__);
        }
        if (is_null($cliente) || (is_array($cliente) && empty($cliente))) {
            unset($this->Cliente);
        } else {
            $this->Cliente = $cliente;
        }
        return $this;
    }
    /**
     * Get CodigoAssessoria value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodigoAssessoria()
    {
        return isset($this->CodigoAssessoria) ? $this->CodigoAssessoria : null;
    }
    /**
     * Set CodigoAssessoria value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codigoAssessoria
     * @return \StructType\ContratosDistribuidosResponse
     */
    public function setCodigoAssessoria($codigoAssessoria = null)
    {
        // validation for constraint: string
        if (!is_null($codigoAssessoria) && !is_string($codigoAssessoria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoAssessoria, true), gettype($codigoAssessoria)), __LINE__);
        }
        if (is_null($codigoAssessoria) || (is_array($codigoAssessoria) && empty($codigoAssessoria))) {
            unset($this->CodigoAssessoria);
        } else {
            $this->CodigoAssessoria = $codigoAssessoria;
        }
        return $this;
    }
    /**
     * Get Contrato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContrato()
    {
        return isset($this->Contrato) ? $this->Contrato : null;
    }
    /**
     * Set Contrato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contrato
     * @return \StructType\ContratosDistribuidosResponse
     */
    public function setContrato($contrato = null)
    {
        // validation for constraint: string
        if (!is_null($contrato) && !is_string($contrato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contrato, true), gettype($contrato)), __LINE__);
        }
        if (is_null($contrato) || (is_array($contrato) && empty($contrato))) {
            unset($this->Contrato);
        } else {
            $this->Contrato = $contrato;
        }
        return $this;
    }
    /**
     * Get ContratosDistribuidosResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfContratosDistribuidosResponse|null
     */
    public function getContratosDistribuidosResult()
    {
        return isset($this->ContratosDistribuidosResult) ? $this->ContratosDistribuidosResult : null;
    }
    /**
     * Set ContratosDistribuidosResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfContratosDistribuidosResponse $contratosDistribuidosResult
     * @return \StructType\ContratosDistribuidosResponse
     */
    public function setContratosDistribuidosResult(\ArrayType\ArrayOfContratosDistribuidosResponse $contratosDistribuidosResult = null)
    {
        if (is_null($contratosDistribuidosResult) || (is_array($contratosDistribuidosResult) && empty($contratosDistribuidosResult))) {
            unset($this->ContratosDistribuidosResult);
        } else {
            $this->ContratosDistribuidosResult = $contratosDistribuidosResult;
        }
        return $this;
    }
}
