<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContratoResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ContratoResponse
 * @subpackage Structs
 */
class ContratoResponse extends ContratoType
{
    /**
     * The Acordos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAcordoResponse
     */
    public $Acordos;
    /**
     * The Assessoria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AssessoriaResponse
     */
    public $Assessoria;
    /**
     * The ChaveCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChaveCliente;
    /**
     * The Eventos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfEventoResponse
     */
    public $Eventos;
    /**
     * The NegociacaoAtiva
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NegociacaoAtiva;
    /**
     * The Parcelas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfParcelaResponse
     */
    public $Parcelas;
    /**
     * The Produtos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProdutoResponse
     */
    public $Produtos;
    /**
     * Constructor method for ContratoResponse
     * @uses ContratoResponse::setAcordos()
     * @uses ContratoResponse::setAssessoria()
     * @uses ContratoResponse::setChaveCliente()
     * @uses ContratoResponse::setEventos()
     * @uses ContratoResponse::setNegociacaoAtiva()
     * @uses ContratoResponse::setParcelas()
     * @uses ContratoResponse::setProdutos()
     * @param \ArrayType\ArrayOfAcordoResponse $acordos
     * @param \StructType\AssessoriaResponse $assessoria
     * @param string $chaveCliente
     * @param \ArrayType\ArrayOfEventoResponse $eventos
     * @param int $negociacaoAtiva
     * @param \ArrayType\ArrayOfParcelaResponse $parcelas
     * @param \ArrayType\ArrayOfProdutoResponse $produtos
     */
    public function __construct(\ArrayType\ArrayOfAcordoResponse $acordos = null, \StructType\AssessoriaResponse $assessoria = null, $chaveCliente = null, \ArrayType\ArrayOfEventoResponse $eventos = null, $negociacaoAtiva = null, \ArrayType\ArrayOfParcelaResponse $parcelas = null, \ArrayType\ArrayOfProdutoResponse $produtos = null)
    {
        $this
            ->setAcordos($acordos)
            ->setAssessoria($assessoria)
            ->setChaveCliente($chaveCliente)
            ->setEventos($eventos)
            ->setNegociacaoAtiva($negociacaoAtiva)
            ->setParcelas($parcelas)
            ->setProdutos($produtos);
    }
    /**
     * Get Acordos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAcordoResponse|null
     */
    public function getAcordos()
    {
        return isset($this->Acordos) ? $this->Acordos : null;
    }
    /**
     * Set Acordos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAcordoResponse $acordos
     * @return \StructType\ContratoResponse
     */
    public function setAcordos(\ArrayType\ArrayOfAcordoResponse $acordos = null)
    {
        if (is_null($acordos) || (is_array($acordos) && empty($acordos))) {
            unset($this->Acordos);
        } else {
            $this->Acordos = $acordos;
        }
        return $this;
    }
    /**
     * Get Assessoria value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AssessoriaResponse|null
     */
    public function getAssessoria()
    {
        return isset($this->Assessoria) ? $this->Assessoria : null;
    }
    /**
     * Set Assessoria value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AssessoriaResponse $assessoria
     * @return \StructType\ContratoResponse
     */
    public function setAssessoria(\StructType\AssessoriaResponse $assessoria = null)
    {
        if (is_null($assessoria) || (is_array($assessoria) && empty($assessoria))) {
            unset($this->Assessoria);
        } else {
            $this->Assessoria = $assessoria;
        }
        return $this;
    }
    /**
     * Get ChaveCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChaveCliente()
    {
        return isset($this->ChaveCliente) ? $this->ChaveCliente : null;
    }
    /**
     * Set ChaveCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chaveCliente
     * @return \StructType\ContratoResponse
     */
    public function setChaveCliente($chaveCliente = null)
    {
        // validation for constraint: string
        if (!is_null($chaveCliente) && !is_string($chaveCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chaveCliente, true), gettype($chaveCliente)), __LINE__);
        }
        if (is_null($chaveCliente) || (is_array($chaveCliente) && empty($chaveCliente))) {
            unset($this->ChaveCliente);
        } else {
            $this->ChaveCliente = $chaveCliente;
        }
        return $this;
    }
    /**
     * Get Eventos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfEventoResponse|null
     */
    public function getEventos()
    {
        return isset($this->Eventos) ? $this->Eventos : null;
    }
    /**
     * Set Eventos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfEventoResponse $eventos
     * @return \StructType\ContratoResponse
     */
    public function setEventos(\ArrayType\ArrayOfEventoResponse $eventos = null)
    {
        if (is_null($eventos) || (is_array($eventos) && empty($eventos))) {
            unset($this->Eventos);
        } else {
            $this->Eventos = $eventos;
        }
        return $this;
    }
    /**
     * Get NegociacaoAtiva value
     * @return int|null
     */
    public function getNegociacaoAtiva()
    {
        return $this->NegociacaoAtiva;
    }
    /**
     * Set NegociacaoAtiva value
     * @param int $negociacaoAtiva
     * @return \StructType\ContratoResponse
     */
    public function setNegociacaoAtiva($negociacaoAtiva = null)
    {
        // validation for constraint: int
        if (!is_null($negociacaoAtiva) && !(is_int($negociacaoAtiva) || ctype_digit($negociacaoAtiva))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($negociacaoAtiva, true), gettype($negociacaoAtiva)), __LINE__);
        }
        $this->NegociacaoAtiva = $negociacaoAtiva;
        return $this;
    }
    /**
     * Get Parcelas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfParcelaResponse|null
     */
    public function getParcelas()
    {
        return isset($this->Parcelas) ? $this->Parcelas : null;
    }
    /**
     * Set Parcelas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfParcelaResponse $parcelas
     * @return \StructType\ContratoResponse
     */
    public function setParcelas(\ArrayType\ArrayOfParcelaResponse $parcelas = null)
    {
        if (is_null($parcelas) || (is_array($parcelas) && empty($parcelas))) {
            unset($this->Parcelas);
        } else {
            $this->Parcelas = $parcelas;
        }
        return $this;
    }
    /**
     * Get Produtos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProdutoResponse|null
     */
    public function getProdutos()
    {
        return isset($this->Produtos) ? $this->Produtos : null;
    }
    /**
     * Set Produtos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProdutoResponse $produtos
     * @return \StructType\ContratoResponse
     */
    public function setProdutos(\ArrayType\ArrayOfProdutoResponse $produtos = null)
    {
        if (is_null($produtos) || (is_array($produtos) && empty($produtos))) {
            unset($this->Produtos);
        } else {
            $this->Produtos = $produtos;
        }
        return $this;
    }
}
