<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContratoRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ContratoRequest
 * @subpackage Structs
 */
class ContratoRequest extends ContratoType
{
    /**
     * The DadosAdicionaisContrato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DadosAdicionaisRequest
     */
    public $DadosAdicionaisContrato;
    /**
     * The DataInclusaoSPC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataInclusaoSPC;
    /**
     * The Parcelas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfParcelaRequest
     */
    public $Parcelas;
    /**
     * The Produtos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProdutoRequest
     */
    public $Produtos;
    /**
     * The TipoSPC
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TipoSPC;
    /**
     * Constructor method for ContratoRequest
     * @uses ContratoRequest::setDadosAdicionaisContrato()
     * @uses ContratoRequest::setDataInclusaoSPC()
     * @uses ContratoRequest::setParcelas()
     * @uses ContratoRequest::setProdutos()
     * @uses ContratoRequest::setTipoSPC()
     * @param \StructType\DadosAdicionaisRequest $dadosAdicionaisContrato
     * @param string $dataInclusaoSPC
     * @param \ArrayType\ArrayOfParcelaRequest $parcelas
     * @param \ArrayType\ArrayOfProdutoRequest $produtos
     * @param string $tipoSPC
     */
    public function __construct(\StructType\DadosAdicionaisRequest $dadosAdicionaisContrato = null, $dataInclusaoSPC = null, \ArrayType\ArrayOfParcelaRequest $parcelas = null, \ArrayType\ArrayOfProdutoRequest $produtos = null, $tipoSPC = null)
    {
        $this
            ->setDadosAdicionaisContrato($dadosAdicionaisContrato)
            ->setDataInclusaoSPC($dataInclusaoSPC)
            ->setParcelas($parcelas)
            ->setProdutos($produtos)
            ->setTipoSPC($tipoSPC);
    }
    /**
     * Get DadosAdicionaisContrato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DadosAdicionaisRequest|null
     */
    public function getDadosAdicionaisContrato()
    {
        return isset($this->DadosAdicionaisContrato) ? $this->DadosAdicionaisContrato : null;
    }
    /**
     * Set DadosAdicionaisContrato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DadosAdicionaisRequest $dadosAdicionaisContrato
     * @return \StructType\ContratoRequest
     */
    public function setDadosAdicionaisContrato(\StructType\DadosAdicionaisRequest $dadosAdicionaisContrato = null)
    {
        if (is_null($dadosAdicionaisContrato) || (is_array($dadosAdicionaisContrato) && empty($dadosAdicionaisContrato))) {
            unset($this->DadosAdicionaisContrato);
        } else {
            $this->DadosAdicionaisContrato = $dadosAdicionaisContrato;
        }
        return $this;
    }
    /**
     * Get DataInclusaoSPC value
     * @return string|null
     */
    public function getDataInclusaoSPC()
    {
        return $this->DataInclusaoSPC;
    }
    /**
     * Set DataInclusaoSPC value
     * @param string $dataInclusaoSPC
     * @return \StructType\ContratoRequest
     */
    public function setDataInclusaoSPC($dataInclusaoSPC = null)
    {
        // validation for constraint: string
        if (!is_null($dataInclusaoSPC) && !is_string($dataInclusaoSPC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataInclusaoSPC, true), gettype($dataInclusaoSPC)), __LINE__);
        }
        $this->DataInclusaoSPC = $dataInclusaoSPC;
        return $this;
    }
    /**
     * Get Parcelas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfParcelaRequest|null
     */
    public function getParcelas()
    {
        return isset($this->Parcelas) ? $this->Parcelas : null;
    }
    /**
     * Set Parcelas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfParcelaRequest $parcelas
     * @return \StructType\ContratoRequest
     */
    public function setParcelas(\ArrayType\ArrayOfParcelaRequest $parcelas = null)
    {
        if (is_null($parcelas) || (is_array($parcelas) && empty($parcelas))) {
            unset($this->Parcelas);
        } else {
            $this->Parcelas = $parcelas;
        }
        return $this;
    }
    /**
     * Get Produtos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProdutoRequest|null
     */
    public function getProdutos()
    {
        return isset($this->Produtos) ? $this->Produtos : null;
    }
    /**
     * Set Produtos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProdutoRequest $produtos
     * @return \StructType\ContratoRequest
     */
    public function setProdutos(\ArrayType\ArrayOfProdutoRequest $produtos = null)
    {
        if (is_null($produtos) || (is_array($produtos) && empty($produtos))) {
            unset($this->Produtos);
        } else {
            $this->Produtos = $produtos;
        }
        return $this;
    }
    /**
     * Get TipoSPC value
     * @return string|null
     */
    public function getTipoSPC()
    {
        return $this->TipoSPC;
    }
    /**
     * Set TipoSPC value
     * @uses \EnumType\EnumTipoSPC::valueIsValid()
     * @uses \EnumType\EnumTipoSPC::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoSPC
     * @return \StructType\ContratoRequest
     */
    public function setTipoSPC($tipoSPC = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTipoSPC::valueIsValid($tipoSPC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumTipoSPC', is_array($tipoSPC) ? implode(', ', $tipoSPC) : var_export($tipoSPC, true), implode(', ', \EnumType\EnumTipoSPC::getValidValues())), __LINE__);
        }
        $this->TipoSPC = $tipoSPC;
        return $this;
    }
}
