<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContratoClienteResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ContratoClienteResponse
 * @subpackage Structs
 */
class ContratoClienteResponse extends ContratoType
{
    /**
     * The Assessoria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AssessoriaResponse
     */
    public $Assessoria;
    /**
     * The CodigoCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodigoCliente;
    /**
     * The Credor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CredorContratoResponse
     */
    public $Credor;
    /**
     * The Parcelas
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfParcelaResponse
     */
    public $Parcelas;
    /**
     * The Produtos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProdutoResponse
     */
    public $Produtos;
    /**
     * Constructor method for ContratoClienteResponse
     * @uses ContratoClienteResponse::setAssessoria()
     * @uses ContratoClienteResponse::setCodigoCliente()
     * @uses ContratoClienteResponse::setCredor()
     * @uses ContratoClienteResponse::setParcelas()
     * @uses ContratoClienteResponse::setProdutos()
     * @param \StructType\AssessoriaResponse $assessoria
     * @param string $codigoCliente
     * @param \StructType\CredorContratoResponse $credor
     * @param \ArrayType\ArrayOfParcelaResponse $parcelas
     * @param \ArrayType\ArrayOfProdutoResponse $produtos
     */
    public function __construct(\StructType\AssessoriaResponse $assessoria = null, $codigoCliente = null, \StructType\CredorContratoResponse $credor = null, \ArrayType\ArrayOfParcelaResponse $parcelas = null, \ArrayType\ArrayOfProdutoResponse $produtos = null)
    {
        $this
            ->setAssessoria($assessoria)
            ->setCodigoCliente($codigoCliente)
            ->setCredor($credor)
            ->setParcelas($parcelas)
            ->setProdutos($produtos);
    }
    /**
     * Get Assessoria value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AssessoriaResponse|null
     */
    public function getAssessoria()
    {
        return isset($this->Assessoria) ? $this->Assessoria : null;
    }
    /**
     * Set Assessoria value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AssessoriaResponse $assessoria
     * @return \StructType\ContratoClienteResponse
     */
    public function setAssessoria(\StructType\AssessoriaResponse $assessoria = null)
    {
        if (is_null($assessoria) || (is_array($assessoria) && empty($assessoria))) {
            unset($this->Assessoria);
        } else {
            $this->Assessoria = $assessoria;
        }
        return $this;
    }
    /**
     * Get CodigoCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodigoCliente()
    {
        return isset($this->CodigoCliente) ? $this->CodigoCliente : null;
    }
    /**
     * Set CodigoCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codigoCliente
     * @return \StructType\ContratoClienteResponse
     */
    public function setCodigoCliente($codigoCliente = null)
    {
        // validation for constraint: string
        if (!is_null($codigoCliente) && !is_string($codigoCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoCliente, true), gettype($codigoCliente)), __LINE__);
        }
        if (is_null($codigoCliente) || (is_array($codigoCliente) && empty($codigoCliente))) {
            unset($this->CodigoCliente);
        } else {
            $this->CodigoCliente = $codigoCliente;
        }
        return $this;
    }
    /**
     * Get Credor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CredorContratoResponse|null
     */
    public function getCredor()
    {
        return isset($this->Credor) ? $this->Credor : null;
    }
    /**
     * Set Credor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CredorContratoResponse $credor
     * @return \StructType\ContratoClienteResponse
     */
    public function setCredor(\StructType\CredorContratoResponse $credor = null)
    {
        if (is_null($credor) || (is_array($credor) && empty($credor))) {
            unset($this->Credor);
        } else {
            $this->Credor = $credor;
        }
        return $this;
    }
    /**
     * Get Parcelas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfParcelaResponse|null
     */
    public function getParcelas()
    {
        return isset($this->Parcelas) ? $this->Parcelas : null;
    }
    /**
     * Set Parcelas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfParcelaResponse $parcelas
     * @return \StructType\ContratoClienteResponse
     */
    public function setParcelas(\ArrayType\ArrayOfParcelaResponse $parcelas = null)
    {
        if (is_null($parcelas) || (is_array($parcelas) && empty($parcelas))) {
            unset($this->Parcelas);
        } else {
            $this->Parcelas = $parcelas;
        }
        return $this;
    }
    /**
     * Get Produtos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProdutoResponse|null
     */
    public function getProdutos()
    {
        return isset($this->Produtos) ? $this->Produtos : null;
    }
    /**
     * Set Produtos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProdutoResponse $produtos
     * @return \StructType\ContratoClienteResponse
     */
    public function setProdutos(\ArrayType\ArrayOfProdutoResponse $produtos = null)
    {
        if (is_null($produtos) || (is_array($produtos) && empty($produtos))) {
            unset($this->Produtos);
        } else {
            $this->Produtos = $produtos;
        }
        return $this;
    }
}
