<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContratoClienteDiscadorResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ContratoClienteDiscadorResponse
 * @subpackage Structs
 */
class ContratoClienteDiscadorResponse extends AbstractStructBase
{
    /**
     * The IdAssessoria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdAssessoria;
    /**
     * The IdCredor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdCredor;
    /**
     * The IdNegociacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdNegociacao;
    /**
     * The Numero
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Numero;
    /**
     * Constructor method for ContratoClienteDiscadorResponse
     * @uses ContratoClienteDiscadorResponse::setIdAssessoria()
     * @uses ContratoClienteDiscadorResponse::setIdCredor()
     * @uses ContratoClienteDiscadorResponse::setIdNegociacao()
     * @uses ContratoClienteDiscadorResponse::setNumero()
     * @param int $idAssessoria
     * @param int $idCredor
     * @param int $idNegociacao
     * @param string $numero
     */
    public function __construct($idAssessoria = null, $idCredor = null, $idNegociacao = null, $numero = null)
    {
        $this
            ->setIdAssessoria($idAssessoria)
            ->setIdCredor($idCredor)
            ->setIdNegociacao($idNegociacao)
            ->setNumero($numero);
    }
    /**
     * Get IdAssessoria value
     * @return int|null
     */
    public function getIdAssessoria()
    {
        return $this->IdAssessoria;
    }
    /**
     * Set IdAssessoria value
     * @param int $idAssessoria
     * @return \StructType\ContratoClienteDiscadorResponse
     */
    public function setIdAssessoria($idAssessoria = null)
    {
        // validation for constraint: int
        if (!is_null($idAssessoria) && !(is_int($idAssessoria) || ctype_digit($idAssessoria))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idAssessoria, true), gettype($idAssessoria)), __LINE__);
        }
        $this->IdAssessoria = $idAssessoria;
        return $this;
    }
    /**
     * Get IdCredor value
     * @return int|null
     */
    public function getIdCredor()
    {
        return $this->IdCredor;
    }
    /**
     * Set IdCredor value
     * @param int $idCredor
     * @return \StructType\ContratoClienteDiscadorResponse
     */
    public function setIdCredor($idCredor = null)
    {
        // validation for constraint: int
        if (!is_null($idCredor) && !(is_int($idCredor) || ctype_digit($idCredor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idCredor, true), gettype($idCredor)), __LINE__);
        }
        $this->IdCredor = $idCredor;
        return $this;
    }
    /**
     * Get IdNegociacao value
     * @return int|null
     */
    public function getIdNegociacao()
    {
        return $this->IdNegociacao;
    }
    /**
     * Set IdNegociacao value
     * @param int $idNegociacao
     * @return \StructType\ContratoClienteDiscadorResponse
     */
    public function setIdNegociacao($idNegociacao = null)
    {
        // validation for constraint: int
        if (!is_null($idNegociacao) && !(is_int($idNegociacao) || ctype_digit($idNegociacao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idNegociacao, true), gettype($idNegociacao)), __LINE__);
        }
        $this->IdNegociacao = $idNegociacao;
        return $this;
    }
    /**
     * Get Numero value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumero()
    {
        return isset($this->Numero) ? $this->Numero : null;
    }
    /**
     * Set Numero value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numero
     * @return \StructType\ContratoClienteDiscadorResponse
     */
    public function setNumero($numero = null)
    {
        // validation for constraint: string
        if (!is_null($numero) && !is_string($numero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numero, true), gettype($numero)), __LINE__);
        }
        if (is_null($numero) || (is_array($numero) && empty($numero))) {
            unset($this->Numero);
        } else {
            $this->Numero = $numero;
        }
        return $this;
    }
}
