<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContratoBoletoResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ContratoBoletoResponse
 * @subpackage Structs
 */
class ContratoBoletoResponse extends AbstractStructBase
{
    /**
     * The Contrato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Contrato;
    /**
     * The DadosAdicionaisContrato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DadosAdicionaisResponse
     */
    public $DadosAdicionaisContrato;
    /**
     * The Filial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Filial;
    /**
     * The TipoContrato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoContrato;
    /**
     * Constructor method for ContratoBoletoResponse
     * @uses ContratoBoletoResponse::setContrato()
     * @uses ContratoBoletoResponse::setDadosAdicionaisContrato()
     * @uses ContratoBoletoResponse::setFilial()
     * @uses ContratoBoletoResponse::setTipoContrato()
     * @param string $contrato
     * @param \StructType\DadosAdicionaisResponse $dadosAdicionaisContrato
     * @param string $filial
     * @param string $tipoContrato
     */
    public function __construct($contrato = null, \StructType\DadosAdicionaisResponse $dadosAdicionaisContrato = null, $filial = null, $tipoContrato = null)
    {
        $this
            ->setContrato($contrato)
            ->setDadosAdicionaisContrato($dadosAdicionaisContrato)
            ->setFilial($filial)
            ->setTipoContrato($tipoContrato);
    }
    /**
     * Get Contrato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContrato()
    {
        return isset($this->Contrato) ? $this->Contrato : null;
    }
    /**
     * Set Contrato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contrato
     * @return \StructType\ContratoBoletoResponse
     */
    public function setContrato($contrato = null)
    {
        // validation for constraint: string
        if (!is_null($contrato) && !is_string($contrato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contrato, true), gettype($contrato)), __LINE__);
        }
        if (is_null($contrato) || (is_array($contrato) && empty($contrato))) {
            unset($this->Contrato);
        } else {
            $this->Contrato = $contrato;
        }
        return $this;
    }
    /**
     * Get DadosAdicionaisContrato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DadosAdicionaisResponse|null
     */
    public function getDadosAdicionaisContrato()
    {
        return isset($this->DadosAdicionaisContrato) ? $this->DadosAdicionaisContrato : null;
    }
    /**
     * Set DadosAdicionaisContrato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DadosAdicionaisResponse $dadosAdicionaisContrato
     * @return \StructType\ContratoBoletoResponse
     */
    public function setDadosAdicionaisContrato(\StructType\DadosAdicionaisResponse $dadosAdicionaisContrato = null)
    {
        if (is_null($dadosAdicionaisContrato) || (is_array($dadosAdicionaisContrato) && empty($dadosAdicionaisContrato))) {
            unset($this->DadosAdicionaisContrato);
        } else {
            $this->DadosAdicionaisContrato = $dadosAdicionaisContrato;
        }
        return $this;
    }
    /**
     * Get Filial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFilial()
    {
        return isset($this->Filial) ? $this->Filial : null;
    }
    /**
     * Set Filial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $filial
     * @return \StructType\ContratoBoletoResponse
     */
    public function setFilial($filial = null)
    {
        // validation for constraint: string
        if (!is_null($filial) && !is_string($filial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filial, true), gettype($filial)), __LINE__);
        }
        if (is_null($filial) || (is_array($filial) && empty($filial))) {
            unset($this->Filial);
        } else {
            $this->Filial = $filial;
        }
        return $this;
    }
    /**
     * Get TipoContrato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoContrato()
    {
        return isset($this->TipoContrato) ? $this->TipoContrato : null;
    }
    /**
     * Set TipoContrato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoContrato
     * @return \StructType\ContratoBoletoResponse
     */
    public function setTipoContrato($tipoContrato = null)
    {
        // validation for constraint: string
        if (!is_null($tipoContrato) && !is_string($tipoContrato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoContrato, true), gettype($tipoContrato)), __LINE__);
        }
        if (is_null($tipoContrato) || (is_array($tipoContrato) && empty($tipoContrato))) {
            unset($this->TipoContrato);
        } else {
            $this->TipoContrato = $tipoContrato;
        }
        return $this;
    }
}
