<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConsultarClienteDiscador StructType
 * @subpackage Structs
 */
class ConsultarClienteDiscador extends AbstractStructBase
{
    /**
     * The CPFCNPJ
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CPFCNPJ;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * Constructor method for ConsultarClienteDiscador
     * @uses ConsultarClienteDiscador::setCPFCNPJ()
     * @uses ConsultarClienteDiscador::setToken()
     * @param string $cPFCNPJ
     * @param string $token
     */
    public function __construct($cPFCNPJ = null, $token = null)
    {
        $this
            ->setCPFCNPJ($cPFCNPJ)
            ->setToken($token);
    }
    /**
     * Get CPFCNPJ value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCPFCNPJ()
    {
        return isset($this->CPFCNPJ) ? $this->CPFCNPJ : null;
    }
    /**
     * Set CPFCNPJ value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cPFCNPJ
     * @return \StructType\ConsultarClienteDiscador
     */
    public function setCPFCNPJ($cPFCNPJ = null)
    {
        // validation for constraint: string
        if (!is_null($cPFCNPJ) && !is_string($cPFCNPJ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cPFCNPJ, true), gettype($cPFCNPJ)), __LINE__);
        }
        if (is_null($cPFCNPJ) || (is_array($cPFCNPJ) && empty($cPFCNPJ))) {
            unset($this->CPFCNPJ);
        } else {
            $this->CPFCNPJ = $cPFCNPJ;
        }
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \StructType\ConsultarClienteDiscador
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
}
