<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConfigTypePortal StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ConfigTypePortal
 * @subpackage Structs
 */
class ConfigTypePortal extends AbstractStructBase
{
    /**
     * The IdConfiguracao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdConfiguracao;
    /**
     * The IdConfiguracaoParametro
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdConfiguracaoParametro;
    /**
     * The Valor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Valor;
    /**
     * Constructor method for ConfigTypePortal
     * @uses ConfigTypePortal::setIdConfiguracao()
     * @uses ConfigTypePortal::setIdConfiguracaoParametro()
     * @uses ConfigTypePortal::setValor()
     * @param int $idConfiguracao
     * @param int $idConfiguracaoParametro
     * @param string $valor
     */
    public function __construct($idConfiguracao = null, $idConfiguracaoParametro = null, $valor = null)
    {
        $this
            ->setIdConfiguracao($idConfiguracao)
            ->setIdConfiguracaoParametro($idConfiguracaoParametro)
            ->setValor($valor);
    }
    /**
     * Get IdConfiguracao value
     * @return int|null
     */
    public function getIdConfiguracao()
    {
        return $this->IdConfiguracao;
    }
    /**
     * Set IdConfiguracao value
     * @param int $idConfiguracao
     * @return \StructType\ConfigTypePortal
     */
    public function setIdConfiguracao($idConfiguracao = null)
    {
        // validation for constraint: int
        if (!is_null($idConfiguracao) && !(is_int($idConfiguracao) || ctype_digit($idConfiguracao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idConfiguracao, true), gettype($idConfiguracao)), __LINE__);
        }
        $this->IdConfiguracao = $idConfiguracao;
        return $this;
    }
    /**
     * Get IdConfiguracaoParametro value
     * @return int|null
     */
    public function getIdConfiguracaoParametro()
    {
        return $this->IdConfiguracaoParametro;
    }
    /**
     * Set IdConfiguracaoParametro value
     * @param int $idConfiguracaoParametro
     * @return \StructType\ConfigTypePortal
     */
    public function setIdConfiguracaoParametro($idConfiguracaoParametro = null)
    {
        // validation for constraint: int
        if (!is_null($idConfiguracaoParametro) && !(is_int($idConfiguracaoParametro) || ctype_digit($idConfiguracaoParametro))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idConfiguracaoParametro, true), gettype($idConfiguracaoParametro)), __LINE__);
        }
        $this->IdConfiguracaoParametro = $idConfiguracaoParametro;
        return $this;
    }
    /**
     * Get Valor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValor()
    {
        return isset($this->Valor) ? $this->Valor : null;
    }
    /**
     * Set Valor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $valor
     * @return \StructType\ConfigTypePortal
     */
    public function setValor($valor = null)
    {
        // validation for constraint: string
        if (!is_null($valor) && !is_string($valor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        if (is_null($valor) || (is_array($valor) && empty($valor))) {
            unset($this->Valor);
        } else {
            $this->Valor = $valor;
        }
        return $this;
    }
}
