<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClienteType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ClienteType
 * @subpackage Structs
 */
class ClienteType extends AbstractStructBase
{
    /**
     * The ChaveCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChaveCliente;
    /**
     * The CpfCnpj
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CpfCnpj;
    /**
     * The IdCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdCliente;
    /**
     * The NomeCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NomeCliente;
    /**
     * The TipoPessoa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TipoPessoa;
    /**
     * Constructor method for ClienteType
     * @uses ClienteType::setChaveCliente()
     * @uses ClienteType::setCpfCnpj()
     * @uses ClienteType::setIdCliente()
     * @uses ClienteType::setNomeCliente()
     * @uses ClienteType::setTipoPessoa()
     * @param string $chaveCliente
     * @param string $cpfCnpj
     * @param int $idCliente
     * @param string $nomeCliente
     * @param string $tipoPessoa
     */
    public function __construct($chaveCliente = null, $cpfCnpj = null, $idCliente = null, $nomeCliente = null, $tipoPessoa = null)
    {
        $this
            ->setChaveCliente($chaveCliente)
            ->setCpfCnpj($cpfCnpj)
            ->setIdCliente($idCliente)
            ->setNomeCliente($nomeCliente)
            ->setTipoPessoa($tipoPessoa);
    }
    /**
     * Get ChaveCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChaveCliente()
    {
        return isset($this->ChaveCliente) ? $this->ChaveCliente : null;
    }
    /**
     * Set ChaveCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chaveCliente
     * @return \StructType\ClienteType
     */
    public function setChaveCliente($chaveCliente = null)
    {
        // validation for constraint: string
        if (!is_null($chaveCliente) && !is_string($chaveCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chaveCliente, true), gettype($chaveCliente)), __LINE__);
        }
        if (is_null($chaveCliente) || (is_array($chaveCliente) && empty($chaveCliente))) {
            unset($this->ChaveCliente);
        } else {
            $this->ChaveCliente = $chaveCliente;
        }
        return $this;
    }
    /**
     * Get CpfCnpj value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpfCnpj()
    {
        return isset($this->CpfCnpj) ? $this->CpfCnpj : null;
    }
    /**
     * Set CpfCnpj value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpfCnpj
     * @return \StructType\ClienteType
     */
    public function setCpfCnpj($cpfCnpj = null)
    {
        // validation for constraint: string
        if (!is_null($cpfCnpj) && !is_string($cpfCnpj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpfCnpj, true), gettype($cpfCnpj)), __LINE__);
        }
        if (is_null($cpfCnpj) || (is_array($cpfCnpj) && empty($cpfCnpj))) {
            unset($this->CpfCnpj);
        } else {
            $this->CpfCnpj = $cpfCnpj;
        }
        return $this;
    }
    /**
     * Get IdCliente value
     * @return int|null
     */
    public function getIdCliente()
    {
        return $this->IdCliente;
    }
    /**
     * Set IdCliente value
     * @param int $idCliente
     * @return \StructType\ClienteType
     */
    public function setIdCliente($idCliente = null)
    {
        // validation for constraint: int
        if (!is_null($idCliente) && !(is_int($idCliente) || ctype_digit($idCliente))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idCliente, true), gettype($idCliente)), __LINE__);
        }
        $this->IdCliente = $idCliente;
        return $this;
    }
    /**
     * Get NomeCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNomeCliente()
    {
        return isset($this->NomeCliente) ? $this->NomeCliente : null;
    }
    /**
     * Set NomeCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nomeCliente
     * @return \StructType\ClienteType
     */
    public function setNomeCliente($nomeCliente = null)
    {
        // validation for constraint: string
        if (!is_null($nomeCliente) && !is_string($nomeCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeCliente, true), gettype($nomeCliente)), __LINE__);
        }
        if (is_null($nomeCliente) || (is_array($nomeCliente) && empty($nomeCliente))) {
            unset($this->NomeCliente);
        } else {
            $this->NomeCliente = $nomeCliente;
        }
        return $this;
    }
    /**
     * Get TipoPessoa value
     * @return string|null
     */
    public function getTipoPessoa()
    {
        return $this->TipoPessoa;
    }
    /**
     * Set TipoPessoa value
     * @uses \EnumType\EnumTipoPessoa::valueIsValid()
     * @uses \EnumType\EnumTipoPessoa::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoPessoa
     * @return \StructType\ClienteType
     */
    public function setTipoPessoa($tipoPessoa = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTipoPessoa::valueIsValid($tipoPessoa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EnumTipoPessoa', is_array($tipoPessoa) ? implode(', ', $tipoPessoa) : var_export($tipoPessoa, true), implode(', ', \EnumType\EnumTipoPessoa::getValidValues())), __LINE__);
        }
        $this->TipoPessoa = $tipoPessoa;
        return $this;
    }
}
