<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CartaoParametroType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CartaoParametroType
 * @subpackage Structs
 */
class CartaoParametroType extends AbstractStructBase
{
    /**
     * The IdParametro
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdParametro;
    /**
     * The Valor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Valor;
    /**
     * Constructor method for CartaoParametroType
     * @uses CartaoParametroType::setIdParametro()
     * @uses CartaoParametroType::setValor()
     * @param int $idParametro
     * @param string $valor
     */
    public function __construct($idParametro = null, $valor = null)
    {
        $this
            ->setIdParametro($idParametro)
            ->setValor($valor);
    }
    /**
     * Get IdParametro value
     * @return int|null
     */
    public function getIdParametro()
    {
        return $this->IdParametro;
    }
    /**
     * Set IdParametro value
     * @param int $idParametro
     * @return \StructType\CartaoParametroType
     */
    public function setIdParametro($idParametro = null)
    {
        // validation for constraint: int
        if (!is_null($idParametro) && !(is_int($idParametro) || ctype_digit($idParametro))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idParametro, true), gettype($idParametro)), __LINE__);
        }
        $this->IdParametro = $idParametro;
        return $this;
    }
    /**
     * Get Valor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValor()
    {
        return isset($this->Valor) ? $this->Valor : null;
    }
    /**
     * Set Valor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $valor
     * @return \StructType\CartaoParametroType
     */
    public function setValor($valor = null)
    {
        // validation for constraint: string
        if (!is_null($valor) && !is_string($valor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        if (is_null($valor) || (is_array($valor) && empty($valor))) {
            unset($this->Valor);
        } else {
            $this->Valor = $valor;
        }
        return $this;
    }
}
