<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CampanhaDesconto StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CampanhaDesconto
 * @subpackage Structs
 */
class CampanhaDesconto extends AbstractStructBase
{
    /**
     * The PercentualHonorario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PercentualHonorario;
    /**
     * The PercentualJuros
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PercentualJuros;
    /**
     * The PercentualMulta
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PercentualMulta;
    /**
     * The PercentualPrincipal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PercentualPrincipal;
    /**
     * Constructor method for CampanhaDesconto
     * @uses CampanhaDesconto::setPercentualHonorario()
     * @uses CampanhaDesconto::setPercentualJuros()
     * @uses CampanhaDesconto::setPercentualMulta()
     * @uses CampanhaDesconto::setPercentualPrincipal()
     * @param float $percentualHonorario
     * @param float $percentualJuros
     * @param float $percentualMulta
     * @param float $percentualPrincipal
     */
    public function __construct($percentualHonorario = null, $percentualJuros = null, $percentualMulta = null, $percentualPrincipal = null)
    {
        $this
            ->setPercentualHonorario($percentualHonorario)
            ->setPercentualJuros($percentualJuros)
            ->setPercentualMulta($percentualMulta)
            ->setPercentualPrincipal($percentualPrincipal);
    }
    /**
     * Get PercentualHonorario value
     * @return float|null
     */
    public function getPercentualHonorario()
    {
        return $this->PercentualHonorario;
    }
    /**
     * Set PercentualHonorario value
     * @param float $percentualHonorario
     * @return \StructType\CampanhaDesconto
     */
    public function setPercentualHonorario($percentualHonorario = null)
    {
        // validation for constraint: float
        if (!is_null($percentualHonorario) && !(is_float($percentualHonorario) || is_numeric($percentualHonorario))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentualHonorario, true), gettype($percentualHonorario)), __LINE__);
        }
        $this->PercentualHonorario = $percentualHonorario;
        return $this;
    }
    /**
     * Get PercentualJuros value
     * @return float|null
     */
    public function getPercentualJuros()
    {
        return $this->PercentualJuros;
    }
    /**
     * Set PercentualJuros value
     * @param float $percentualJuros
     * @return \StructType\CampanhaDesconto
     */
    public function setPercentualJuros($percentualJuros = null)
    {
        // validation for constraint: float
        if (!is_null($percentualJuros) && !(is_float($percentualJuros) || is_numeric($percentualJuros))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentualJuros, true), gettype($percentualJuros)), __LINE__);
        }
        $this->PercentualJuros = $percentualJuros;
        return $this;
    }
    /**
     * Get PercentualMulta value
     * @return float|null
     */
    public function getPercentualMulta()
    {
        return $this->PercentualMulta;
    }
    /**
     * Set PercentualMulta value
     * @param float $percentualMulta
     * @return \StructType\CampanhaDesconto
     */
    public function setPercentualMulta($percentualMulta = null)
    {
        // validation for constraint: float
        if (!is_null($percentualMulta) && !(is_float($percentualMulta) || is_numeric($percentualMulta))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentualMulta, true), gettype($percentualMulta)), __LINE__);
        }
        $this->PercentualMulta = $percentualMulta;
        return $this;
    }
    /**
     * Get PercentualPrincipal value
     * @return float|null
     */
    public function getPercentualPrincipal()
    {
        return $this->PercentualPrincipal;
    }
    /**
     * Set PercentualPrincipal value
     * @param float $percentualPrincipal
     * @return \StructType\CampanhaDesconto
     */
    public function setPercentualPrincipal($percentualPrincipal = null)
    {
        // validation for constraint: float
        if (!is_null($percentualPrincipal) && !(is_float($percentualPrincipal) || is_numeric($percentualPrincipal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percentualPrincipal, true), gettype($percentualPrincipal)), __LINE__);
        }
        $this->PercentualPrincipal = $percentualPrincipal;
        return $this;
    }
}
