<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalculoTypePortal StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CalculoTypePortal
 * @subpackage Structs
 */
class CalculoTypePortal extends AbstractStructBase
{
    /**
     * The CampanhaDesconto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CampanhaDesconto
     */
    public $CampanhaDesconto;
    /**
     * The OpcoesParcelamento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfOpcesParcelamentoType
     */
    public $OpcoesParcelamento;
    /**
     * The Contrato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Contrato;
    /**
     * The IdNegociacao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdNegociacao;
    /**
     * The ValorAtualizado
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorAtualizado;
    /**
     * The ValorOriginal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorOriginal;
    /**
     * Constructor method for CalculoTypePortal
     * @uses CalculoTypePortal::setCampanhaDesconto()
     * @uses CalculoTypePortal::setOpcoesParcelamento()
     * @uses CalculoTypePortal::setContrato()
     * @uses CalculoTypePortal::setIdNegociacao()
     * @uses CalculoTypePortal::setValorAtualizado()
     * @uses CalculoTypePortal::setValorOriginal()
     * @param \StructType\CampanhaDesconto $campanhaDesconto
     * @param \ArrayType\ArrayOfOpcesParcelamentoType $opcoesParcelamento
     * @param string $contrato
     * @param int $idNegociacao
     * @param float $valorAtualizado
     * @param float $valorOriginal
     */
    public function __construct(\StructType\CampanhaDesconto $campanhaDesconto = null, \ArrayType\ArrayOfOpcesParcelamentoType $opcoesParcelamento = null, $contrato = null, $idNegociacao = null, $valorAtualizado = null, $valorOriginal = null)
    {
        $this
            ->setCampanhaDesconto($campanhaDesconto)
            ->setOpcoesParcelamento($opcoesParcelamento)
            ->setContrato($contrato)
            ->setIdNegociacao($idNegociacao)
            ->setValorAtualizado($valorAtualizado)
            ->setValorOriginal($valorOriginal);
    }
    /**
     * Get CampanhaDesconto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CampanhaDesconto|null
     */
    public function getCampanhaDesconto()
    {
        return isset($this->CampanhaDesconto) ? $this->CampanhaDesconto : null;
    }
    /**
     * Set CampanhaDesconto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CampanhaDesconto $campanhaDesconto
     * @return \StructType\CalculoTypePortal
     */
    public function setCampanhaDesconto(\StructType\CampanhaDesconto $campanhaDesconto = null)
    {
        if (is_null($campanhaDesconto) || (is_array($campanhaDesconto) && empty($campanhaDesconto))) {
            unset($this->CampanhaDesconto);
        } else {
            $this->CampanhaDesconto = $campanhaDesconto;
        }
        return $this;
    }
    /**
     * Get OpcoesParcelamento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfOpcesParcelamentoType|null
     */
    public function getOpcoesParcelamento()
    {
        return isset($this->OpcoesParcelamento) ? $this->OpcoesParcelamento : null;
    }
    /**
     * Set OpcoesParcelamento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfOpcesParcelamentoType $opcoesParcelamento
     * @return \StructType\CalculoTypePortal
     */
    public function setOpcoesParcelamento(\ArrayType\ArrayOfOpcesParcelamentoType $opcoesParcelamento = null)
    {
        if (is_null($opcoesParcelamento) || (is_array($opcoesParcelamento) && empty($opcoesParcelamento))) {
            unset($this->OpcoesParcelamento);
        } else {
            $this->OpcoesParcelamento = $opcoesParcelamento;
        }
        return $this;
    }
    /**
     * Get Contrato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContrato()
    {
        return isset($this->Contrato) ? $this->Contrato : null;
    }
    /**
     * Set Contrato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contrato
     * @return \StructType\CalculoTypePortal
     */
    public function setContrato($contrato = null)
    {
        // validation for constraint: string
        if (!is_null($contrato) && !is_string($contrato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contrato, true), gettype($contrato)), __LINE__);
        }
        if (is_null($contrato) || (is_array($contrato) && empty($contrato))) {
            unset($this->Contrato);
        } else {
            $this->Contrato = $contrato;
        }
        return $this;
    }
    /**
     * Get IdNegociacao value
     * @return int|null
     */
    public function getIdNegociacao()
    {
        return $this->IdNegociacao;
    }
    /**
     * Set IdNegociacao value
     * @param int $idNegociacao
     * @return \StructType\CalculoTypePortal
     */
    public function setIdNegociacao($idNegociacao = null)
    {
        // validation for constraint: int
        if (!is_null($idNegociacao) && !(is_int($idNegociacao) || ctype_digit($idNegociacao))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idNegociacao, true), gettype($idNegociacao)), __LINE__);
        }
        $this->IdNegociacao = $idNegociacao;
        return $this;
    }
    /**
     * Get ValorAtualizado value
     * @return float|null
     */
    public function getValorAtualizado()
    {
        return $this->ValorAtualizado;
    }
    /**
     * Set ValorAtualizado value
     * @param float $valorAtualizado
     * @return \StructType\CalculoTypePortal
     */
    public function setValorAtualizado($valorAtualizado = null)
    {
        // validation for constraint: float
        if (!is_null($valorAtualizado) && !(is_float($valorAtualizado) || is_numeric($valorAtualizado))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorAtualizado, true), gettype($valorAtualizado)), __LINE__);
        }
        $this->ValorAtualizado = $valorAtualizado;
        return $this;
    }
    /**
     * Get ValorOriginal value
     * @return float|null
     */
    public function getValorOriginal()
    {
        return $this->ValorOriginal;
    }
    /**
     * Set ValorOriginal value
     * @param float $valorOriginal
     * @return \StructType\CalculoTypePortal
     */
    public function setValorOriginal($valorOriginal = null)
    {
        // validation for constraint: float
        if (!is_null($valorOriginal) && !(is_float($valorOriginal) || is_numeric($valorOriginal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorOriginal, true), gettype($valorOriginal)), __LINE__);
        }
        $this->ValorOriginal = $valorOriginal;
        return $this;
    }
}
