<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BoletoType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BoletoType
 * @subpackage Structs
 */
class BoletoType extends AbstractStructBase
{
    /**
     * The ChaveCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChaveCliente;
    /**
     * The NossoNumero
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NossoNumero;
    /**
     * The Parcela
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Parcela;
    /**
     * Constructor method for BoletoType
     * @uses BoletoType::setChaveCliente()
     * @uses BoletoType::setNossoNumero()
     * @uses BoletoType::setParcela()
     * @param string $chaveCliente
     * @param string $nossoNumero
     * @param string $parcela
     */
    public function __construct($chaveCliente = null, $nossoNumero = null, $parcela = null)
    {
        $this
            ->setChaveCliente($chaveCliente)
            ->setNossoNumero($nossoNumero)
            ->setParcela($parcela);
    }
    /**
     * Get ChaveCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChaveCliente()
    {
        return isset($this->ChaveCliente) ? $this->ChaveCliente : null;
    }
    /**
     * Set ChaveCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $chaveCliente
     * @return \StructType\BoletoType
     */
    public function setChaveCliente($chaveCliente = null)
    {
        // validation for constraint: string
        if (!is_null($chaveCliente) && !is_string($chaveCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($chaveCliente, true), gettype($chaveCliente)), __LINE__);
        }
        if (is_null($chaveCliente) || (is_array($chaveCliente) && empty($chaveCliente))) {
            unset($this->ChaveCliente);
        } else {
            $this->ChaveCliente = $chaveCliente;
        }
        return $this;
    }
    /**
     * Get NossoNumero value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNossoNumero()
    {
        return isset($this->NossoNumero) ? $this->NossoNumero : null;
    }
    /**
     * Set NossoNumero value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nossoNumero
     * @return \StructType\BoletoType
     */
    public function setNossoNumero($nossoNumero = null)
    {
        // validation for constraint: string
        if (!is_null($nossoNumero) && !is_string($nossoNumero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nossoNumero, true), gettype($nossoNumero)), __LINE__);
        }
        if (is_null($nossoNumero) || (is_array($nossoNumero) && empty($nossoNumero))) {
            unset($this->NossoNumero);
        } else {
            $this->NossoNumero = $nossoNumero;
        }
        return $this;
    }
    /**
     * Get Parcela value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParcela()
    {
        return isset($this->Parcela) ? $this->Parcela : null;
    }
    /**
     * Set Parcela value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parcela
     * @return \StructType\BoletoType
     */
    public function setParcela($parcela = null)
    {
        // validation for constraint: string
        if (!is_null($parcela) && !is_string($parcela)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parcela, true), gettype($parcela)), __LINE__);
        }
        if (is_null($parcela) || (is_array($parcela) && empty($parcela))) {
            unset($this->Parcela);
        } else {
            $this->Parcela = $parcela;
        }
        return $this;
    }
}
