<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BoletoRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BoletoRequest
 * @subpackage Structs
 */
class BoletoRequest extends BoletoType
{
    /**
     * The Contrato
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Contrato;
    /**
     * The ValorParcela
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorParcela;
    /**
     * The VencimentoParcela
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VencimentoParcela;
    /**
     * Constructor method for BoletoRequest
     * @uses BoletoRequest::setContrato()
     * @uses BoletoRequest::setValorParcela()
     * @uses BoletoRequest::setVencimentoParcela()
     * @param string $contrato
     * @param float $valorParcela
     * @param string $vencimentoParcela
     */
    public function __construct($contrato = null, $valorParcela = null, $vencimentoParcela = null)
    {
        $this
            ->setContrato($contrato)
            ->setValorParcela($valorParcela)
            ->setVencimentoParcela($vencimentoParcela);
    }
    /**
     * Get Contrato value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContrato()
    {
        return isset($this->Contrato) ? $this->Contrato : null;
    }
    /**
     * Set Contrato value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contrato
     * @return \StructType\BoletoRequest
     */
    public function setContrato($contrato = null)
    {
        // validation for constraint: string
        if (!is_null($contrato) && !is_string($contrato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contrato, true), gettype($contrato)), __LINE__);
        }
        if (is_null($contrato) || (is_array($contrato) && empty($contrato))) {
            unset($this->Contrato);
        } else {
            $this->Contrato = $contrato;
        }
        return $this;
    }
    /**
     * Get ValorParcela value
     * @return float|null
     */
    public function getValorParcela()
    {
        return $this->ValorParcela;
    }
    /**
     * Set ValorParcela value
     * @param float $valorParcela
     * @return \StructType\BoletoRequest
     */
    public function setValorParcela($valorParcela = null)
    {
        // validation for constraint: float
        if (!is_null($valorParcela) && !(is_float($valorParcela) || is_numeric($valorParcela))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valorParcela, true), gettype($valorParcela)), __LINE__);
        }
        $this->ValorParcela = $valorParcela;
        return $this;
    }
    /**
     * Get VencimentoParcela value
     * @return string|null
     */
    public function getVencimentoParcela()
    {
        return $this->VencimentoParcela;
    }
    /**
     * Set VencimentoParcela value
     * @param string $vencimentoParcela
     * @return \StructType\BoletoRequest
     */
    public function setVencimentoParcela($vencimentoParcela = null)
    {
        // validation for constraint: string
        if (!is_null($vencimentoParcela) && !is_string($vencimentoParcela)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vencimentoParcela, true), gettype($vencimentoParcela)), __LINE__);
        }
        $this->VencimentoParcela = $vencimentoParcela;
        return $this;
    }
}
