<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BoletoOriginalResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BoletoOriginalResponse
 * @subpackage Structs
 */
class BoletoOriginalResponse extends AbstractStructBase
{
    /**
     * The Contratos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfContratoBoletoResponse
     */
    public $Contratos;
    /**
     * The CpfCnpj
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CpfCnpj;
    /**
     * The IdBoleto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdBoleto;
    /**
     * The IdCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdCliente;
    /**
     * The LinhaDigitavel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LinhaDigitavel;
    /**
     * The NomeCliente
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NomeCliente;
    /**
     * The NossoNumero
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NossoNumero;
    /**
     * The Parcela
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Parcela;
    /**
     * The Valor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Valor;
    /**
     * The Vencimento
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Vencimento;
    /**
     * Constructor method for BoletoOriginalResponse
     * @uses BoletoOriginalResponse::setContratos()
     * @uses BoletoOriginalResponse::setCpfCnpj()
     * @uses BoletoOriginalResponse::setIdBoleto()
     * @uses BoletoOriginalResponse::setIdCliente()
     * @uses BoletoOriginalResponse::setLinhaDigitavel()
     * @uses BoletoOriginalResponse::setNomeCliente()
     * @uses BoletoOriginalResponse::setNossoNumero()
     * @uses BoletoOriginalResponse::setParcela()
     * @uses BoletoOriginalResponse::setValor()
     * @uses BoletoOriginalResponse::setVencimento()
     * @param \ArrayType\ArrayOfContratoBoletoResponse $contratos
     * @param string $cpfCnpj
     * @param string $idBoleto
     * @param int $idCliente
     * @param string $linhaDigitavel
     * @param string $nomeCliente
     * @param string $nossoNumero
     * @param string $parcela
     * @param float $valor
     * @param string $vencimento
     */
    public function __construct(\ArrayType\ArrayOfContratoBoletoResponse $contratos = null, $cpfCnpj = null, $idBoleto = null, $idCliente = null, $linhaDigitavel = null, $nomeCliente = null, $nossoNumero = null, $parcela = null, $valor = null, $vencimento = null)
    {
        $this
            ->setContratos($contratos)
            ->setCpfCnpj($cpfCnpj)
            ->setIdBoleto($idBoleto)
            ->setIdCliente($idCliente)
            ->setLinhaDigitavel($linhaDigitavel)
            ->setNomeCliente($nomeCliente)
            ->setNossoNumero($nossoNumero)
            ->setParcela($parcela)
            ->setValor($valor)
            ->setVencimento($vencimento);
    }
    /**
     * Get Contratos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfContratoBoletoResponse|null
     */
    public function getContratos()
    {
        return isset($this->Contratos) ? $this->Contratos : null;
    }
    /**
     * Set Contratos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfContratoBoletoResponse $contratos
     * @return \StructType\BoletoOriginalResponse
     */
    public function setContratos(\ArrayType\ArrayOfContratoBoletoResponse $contratos = null)
    {
        if (is_null($contratos) || (is_array($contratos) && empty($contratos))) {
            unset($this->Contratos);
        } else {
            $this->Contratos = $contratos;
        }
        return $this;
    }
    /**
     * Get CpfCnpj value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCpfCnpj()
    {
        return isset($this->CpfCnpj) ? $this->CpfCnpj : null;
    }
    /**
     * Set CpfCnpj value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cpfCnpj
     * @return \StructType\BoletoOriginalResponse
     */
    public function setCpfCnpj($cpfCnpj = null)
    {
        // validation for constraint: string
        if (!is_null($cpfCnpj) && !is_string($cpfCnpj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cpfCnpj, true), gettype($cpfCnpj)), __LINE__);
        }
        if (is_null($cpfCnpj) || (is_array($cpfCnpj) && empty($cpfCnpj))) {
            unset($this->CpfCnpj);
        } else {
            $this->CpfCnpj = $cpfCnpj;
        }
        return $this;
    }
    /**
     * Get IdBoleto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdBoleto()
    {
        return isset($this->IdBoleto) ? $this->IdBoleto : null;
    }
    /**
     * Set IdBoleto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idBoleto
     * @return \StructType\BoletoOriginalResponse
     */
    public function setIdBoleto($idBoleto = null)
    {
        // validation for constraint: string
        if (!is_null($idBoleto) && !is_string($idBoleto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idBoleto, true), gettype($idBoleto)), __LINE__);
        }
        if (is_null($idBoleto) || (is_array($idBoleto) && empty($idBoleto))) {
            unset($this->IdBoleto);
        } else {
            $this->IdBoleto = $idBoleto;
        }
        return $this;
    }
    /**
     * Get IdCliente value
     * @return int|null
     */
    public function getIdCliente()
    {
        return $this->IdCliente;
    }
    /**
     * Set IdCliente value
     * @param int $idCliente
     * @return \StructType\BoletoOriginalResponse
     */
    public function setIdCliente($idCliente = null)
    {
        // validation for constraint: int
        if (!is_null($idCliente) && !(is_int($idCliente) || ctype_digit($idCliente))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idCliente, true), gettype($idCliente)), __LINE__);
        }
        $this->IdCliente = $idCliente;
        return $this;
    }
    /**
     * Get LinhaDigitavel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLinhaDigitavel()
    {
        return isset($this->LinhaDigitavel) ? $this->LinhaDigitavel : null;
    }
    /**
     * Set LinhaDigitavel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $linhaDigitavel
     * @return \StructType\BoletoOriginalResponse
     */
    public function setLinhaDigitavel($linhaDigitavel = null)
    {
        // validation for constraint: string
        if (!is_null($linhaDigitavel) && !is_string($linhaDigitavel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linhaDigitavel, true), gettype($linhaDigitavel)), __LINE__);
        }
        if (is_null($linhaDigitavel) || (is_array($linhaDigitavel) && empty($linhaDigitavel))) {
            unset($this->LinhaDigitavel);
        } else {
            $this->LinhaDigitavel = $linhaDigitavel;
        }
        return $this;
    }
    /**
     * Get NomeCliente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNomeCliente()
    {
        return isset($this->NomeCliente) ? $this->NomeCliente : null;
    }
    /**
     * Set NomeCliente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nomeCliente
     * @return \StructType\BoletoOriginalResponse
     */
    public function setNomeCliente($nomeCliente = null)
    {
        // validation for constraint: string
        if (!is_null($nomeCliente) && !is_string($nomeCliente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeCliente, true), gettype($nomeCliente)), __LINE__);
        }
        if (is_null($nomeCliente) || (is_array($nomeCliente) && empty($nomeCliente))) {
            unset($this->NomeCliente);
        } else {
            $this->NomeCliente = $nomeCliente;
        }
        return $this;
    }
    /**
     * Get NossoNumero value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNossoNumero()
    {
        return isset($this->NossoNumero) ? $this->NossoNumero : null;
    }
    /**
     * Set NossoNumero value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nossoNumero
     * @return \StructType\BoletoOriginalResponse
     */
    public function setNossoNumero($nossoNumero = null)
    {
        // validation for constraint: string
        if (!is_null($nossoNumero) && !is_string($nossoNumero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nossoNumero, true), gettype($nossoNumero)), __LINE__);
        }
        if (is_null($nossoNumero) || (is_array($nossoNumero) && empty($nossoNumero))) {
            unset($this->NossoNumero);
        } else {
            $this->NossoNumero = $nossoNumero;
        }
        return $this;
    }
    /**
     * Get Parcela value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParcela()
    {
        return isset($this->Parcela) ? $this->Parcela : null;
    }
    /**
     * Set Parcela value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parcela
     * @return \StructType\BoletoOriginalResponse
     */
    public function setParcela($parcela = null)
    {
        // validation for constraint: string
        if (!is_null($parcela) && !is_string($parcela)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parcela, true), gettype($parcela)), __LINE__);
        }
        if (is_null($parcela) || (is_array($parcela) && empty($parcela))) {
            unset($this->Parcela);
        } else {
            $this->Parcela = $parcela;
        }
        return $this;
    }
    /**
     * Get Valor value
     * @return float|null
     */
    public function getValor()
    {
        return $this->Valor;
    }
    /**
     * Set Valor value
     * @param float $valor
     * @return \StructType\BoletoOriginalResponse
     */
    public function setValor($valor = null)
    {
        // validation for constraint: float
        if (!is_null($valor) && !(is_float($valor) || is_numeric($valor))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valor, true), gettype($valor)), __LINE__);
        }
        $this->Valor = $valor;
        return $this;
    }
    /**
     * Get Vencimento value
     * @return string|null
     */
    public function getVencimento()
    {
        return $this->Vencimento;
    }
    /**
     * Set Vencimento value
     * @param string $vencimento
     * @return \StructType\BoletoOriginalResponse
     */
    public function setVencimento($vencimento = null)
    {
        // validation for constraint: string
        if (!is_null($vencimento) && !is_string($vencimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vencimento, true), gettype($vencimento)), __LINE__);
        }
        $this->Vencimento = $vencimento;
        return $this;
    }
}
