<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutenticacaoResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AutenticacaoResponse
 * @subpackage Structs
 */
class AutenticacaoResponse extends AbstractStructBase
{
    /**
     * The DataExpiracao
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataExpiracao;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * Constructor method for AutenticacaoResponse
     * @uses AutenticacaoResponse::setDataExpiracao()
     * @uses AutenticacaoResponse::setToken()
     * @param string $dataExpiracao
     * @param string $token
     */
    public function __construct($dataExpiracao = null, $token = null)
    {
        $this
            ->setDataExpiracao($dataExpiracao)
            ->setToken($token);
    }
    /**
     * Get DataExpiracao value
     * @return string|null
     */
    public function getDataExpiracao()
    {
        return $this->DataExpiracao;
    }
    /**
     * Set DataExpiracao value
     * @param string $dataExpiracao
     * @return \StructType\AutenticacaoResponse
     */
    public function setDataExpiracao($dataExpiracao = null)
    {
        // validation for constraint: string
        if (!is_null($dataExpiracao) && !is_string($dataExpiracao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataExpiracao, true), gettype($dataExpiracao)), __LINE__);
        }
        $this->DataExpiracao = $dataExpiracao;
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \StructType\AutenticacaoResponse
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
}
