<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssessoriaTypePortal StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AssessoriaTypePortal
 * @subpackage Structs
 */
class AssessoriaTypePortal extends AbstractStructBase
{
    /**
     * The CPFCNPJ
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CPFCNPJ;
    /**
     * The Configuracoes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfConfigTypePortalResponse
     */
    public $Configuracoes;
    /**
     * The Diretorio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Diretorio;
    /**
     * The IdAssessoria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IdAssessoria;
    /**
     * The Nome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Nome;
    /**
     * The NomeFantasia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NomeFantasia;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Senha;
    /**
     * The Token
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Token;
    /**
     * The Usuario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Usuario;
    /**
     * Constructor method for AssessoriaTypePortal
     * @uses AssessoriaTypePortal::setCPFCNPJ()
     * @uses AssessoriaTypePortal::setConfiguracoes()
     * @uses AssessoriaTypePortal::setDiretorio()
     * @uses AssessoriaTypePortal::setIdAssessoria()
     * @uses AssessoriaTypePortal::setNome()
     * @uses AssessoriaTypePortal::setNomeFantasia()
     * @uses AssessoriaTypePortal::setSenha()
     * @uses AssessoriaTypePortal::setToken()
     * @uses AssessoriaTypePortal::setUsuario()
     * @param string $cPFCNPJ
     * @param \ArrayType\ArrayOfConfigTypePortalResponse $configuracoes
     * @param string $diretorio
     * @param int $idAssessoria
     * @param string $nome
     * @param string $nomeFantasia
     * @param string $senha
     * @param string $token
     * @param string $usuario
     */
    public function __construct($cPFCNPJ = null, \ArrayType\ArrayOfConfigTypePortalResponse $configuracoes = null, $diretorio = null, $idAssessoria = null, $nome = null, $nomeFantasia = null, $senha = null, $token = null, $usuario = null)
    {
        $this
            ->setCPFCNPJ($cPFCNPJ)
            ->setConfiguracoes($configuracoes)
            ->setDiretorio($diretorio)
            ->setIdAssessoria($idAssessoria)
            ->setNome($nome)
            ->setNomeFantasia($nomeFantasia)
            ->setSenha($senha)
            ->setToken($token)
            ->setUsuario($usuario);
    }
    /**
     * Get CPFCNPJ value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCPFCNPJ()
    {
        return isset($this->CPFCNPJ) ? $this->CPFCNPJ : null;
    }
    /**
     * Set CPFCNPJ value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cPFCNPJ
     * @return \StructType\AssessoriaTypePortal
     */
    public function setCPFCNPJ($cPFCNPJ = null)
    {
        // validation for constraint: string
        if (!is_null($cPFCNPJ) && !is_string($cPFCNPJ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cPFCNPJ, true), gettype($cPFCNPJ)), __LINE__);
        }
        if (is_null($cPFCNPJ) || (is_array($cPFCNPJ) && empty($cPFCNPJ))) {
            unset($this->CPFCNPJ);
        } else {
            $this->CPFCNPJ = $cPFCNPJ;
        }
        return $this;
    }
    /**
     * Get Configuracoes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfConfigTypePortalResponse|null
     */
    public function getConfiguracoes()
    {
        return isset($this->Configuracoes) ? $this->Configuracoes : null;
    }
    /**
     * Set Configuracoes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfConfigTypePortalResponse $configuracoes
     * @return \StructType\AssessoriaTypePortal
     */
    public function setConfiguracoes(\ArrayType\ArrayOfConfigTypePortalResponse $configuracoes = null)
    {
        if (is_null($configuracoes) || (is_array($configuracoes) && empty($configuracoes))) {
            unset($this->Configuracoes);
        } else {
            $this->Configuracoes = $configuracoes;
        }
        return $this;
    }
    /**
     * Get Diretorio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDiretorio()
    {
        return isset($this->Diretorio) ? $this->Diretorio : null;
    }
    /**
     * Set Diretorio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $diretorio
     * @return \StructType\AssessoriaTypePortal
     */
    public function setDiretorio($diretorio = null)
    {
        // validation for constraint: string
        if (!is_null($diretorio) && !is_string($diretorio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($diretorio, true), gettype($diretorio)), __LINE__);
        }
        if (is_null($diretorio) || (is_array($diretorio) && empty($diretorio))) {
            unset($this->Diretorio);
        } else {
            $this->Diretorio = $diretorio;
        }
        return $this;
    }
    /**
     * Get IdAssessoria value
     * @return int|null
     */
    public function getIdAssessoria()
    {
        return $this->IdAssessoria;
    }
    /**
     * Set IdAssessoria value
     * @param int $idAssessoria
     * @return \StructType\AssessoriaTypePortal
     */
    public function setIdAssessoria($idAssessoria = null)
    {
        // validation for constraint: int
        if (!is_null($idAssessoria) && !(is_int($idAssessoria) || ctype_digit($idAssessoria))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($idAssessoria, true), gettype($idAssessoria)), __LINE__);
        }
        $this->IdAssessoria = $idAssessoria;
        return $this;
    }
    /**
     * Get Nome value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNome()
    {
        return isset($this->Nome) ? $this->Nome : null;
    }
    /**
     * Set Nome value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nome
     * @return \StructType\AssessoriaTypePortal
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        if (is_null($nome) || (is_array($nome) && empty($nome))) {
            unset($this->Nome);
        } else {
            $this->Nome = $nome;
        }
        return $this;
    }
    /**
     * Get NomeFantasia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNomeFantasia()
    {
        return isset($this->NomeFantasia) ? $this->NomeFantasia : null;
    }
    /**
     * Set NomeFantasia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nomeFantasia
     * @return \StructType\AssessoriaTypePortal
     */
    public function setNomeFantasia($nomeFantasia = null)
    {
        // validation for constraint: string
        if (!is_null($nomeFantasia) && !is_string($nomeFantasia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeFantasia, true), gettype($nomeFantasia)), __LINE__);
        }
        if (is_null($nomeFantasia) || (is_array($nomeFantasia) && empty($nomeFantasia))) {
            unset($this->NomeFantasia);
        } else {
            $this->NomeFantasia = $nomeFantasia;
        }
        return $this;
    }
    /**
     * Get Senha value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSenha()
    {
        return isset($this->Senha) ? $this->Senha : null;
    }
    /**
     * Set Senha value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $senha
     * @return \StructType\AssessoriaTypePortal
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        if (is_null($senha) || (is_array($senha) && empty($senha))) {
            unset($this->Senha);
        } else {
            $this->Senha = $senha;
        }
        return $this;
    }
    /**
     * Get Token value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToken()
    {
        return isset($this->Token) ? $this->Token : null;
    }
    /**
     * Set Token value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $token
     * @return \StructType\AssessoriaTypePortal
     */
    public function setToken($token = null)
    {
        // validation for constraint: string
        if (!is_null($token) && !is_string($token)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($token, true), gettype($token)), __LINE__);
        }
        if (is_null($token) || (is_array($token) && empty($token))) {
            unset($this->Token);
        } else {
            $this->Token = $token;
        }
        return $this;
    }
    /**
     * Get Usuario value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUsuario()
    {
        return isset($this->Usuario) ? $this->Usuario : null;
    }
    /**
     * Set Usuario value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $usuario
     * @return \StructType\AssessoriaTypePortal
     */
    public function setUsuario($usuario = null)
    {
        // validation for constraint: string
        if (!is_null($usuario) && !is_string($usuario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($usuario, true), gettype($usuario)), __LINE__);
        }
        if (is_null($usuario) || (is_array($usuario) && empty($usuario))) {
            unset($this->Usuario);
        } else {
            $this->Usuario = $usuario;
        }
        return $this;
    }
}
